/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.ImageURIRegistry;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolTipLabelProvider
extends DecoratingColumLabelProvider {
    private AdapterFactoryItemDelegator itemDelegator;
    private final ColumnViewerInformationControlToolTipSupport toolTipSupport;

    public ToolTipLabelProvider(ComposedAdapterFactory adapterFactory, ColumnViewerInformationControlToolTipSupport toolTipSupport) {
        super((ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory), new ILabelDecorator(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String decorateText(String text, Object element) {
                return text;
            }

            public Image decorateImage(Image image, Object element) {
                return image;
            }
        });
        this.toolTipSupport = toolTipSupport;
        this.itemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)adapterFactory);
    }

    public String getToolTipText(Object element) {
        ArrayList<IItemPropertyDescriptor> propertyDescriptors = new ArrayList<IItemPropertyDescriptor>();
        List underlyingPropertyDescriptors = this.itemDelegator.getPropertyDescriptors(element);
        if (underlyingPropertyDescriptors != null) {
            propertyDescriptors.addAll(underlyingPropertyDescriptors);
        }
        Iterator it = propertyDescriptors.iterator();
        while (it.hasNext()) {
            IItemPropertyDescriptor itemPropertyDescriptor = (IItemPropertyDescriptor)it.next();
            Object propertyValue = itemPropertyDescriptor.getPropertyValue(element);
            String valueLabel = itemPropertyDescriptor.getLabelProvider(element).getText(propertyValue);
            if (!StringUtil.isEmpty((String)valueLabel)) continue;
            it.remove();
        }
        if (!propertyDescriptors.isEmpty()) {
            String finalText = ToolTipLabelProvider.renderHTML(propertyDescriptors, element, false);
            try {
                AbstractHoverInformationControlManager hoverInformationControlManager = (AbstractHoverInformationControlManager)ReflectUtil.getValue((String)"hoverInformationControlManager", (Object)this.toolTipSupport);
                Point size = UIUtil.caclcuateSize((String)finalText);
                hoverInformationControlManager.setSizeConstraints(size.x, size.y + (propertyDescriptors.size() + 1) / 5 + 1, true, false);
            }
            catch (Throwable throwable) {}
            return finalText;
        }
        return null;
    }

    public static String renderHTML(AdapterFactoryItemDelegator itemDelegator, Object element) {
        List propertyDescriptors = itemDelegator.getPropertyDescriptors(element);
        if (propertyDescriptors != null) {
            return ToolTipLabelProvider.renderHTML(propertyDescriptors, element, false);
        }
        return null;
    }

    public static String renderHTML(List<IItemPropertyDescriptor> propertyDescriptors, Object element, boolean links) {
        if (propertyDescriptors.size() > 0) {
            StringBuilder result = new StringBuilder();
            result.append("<table style='word-wrap: break-word; word-break: break-all; " + (links ? "" : "margin-top: 3pt; ") + "border-collapse: collapse;'>");
            for (IItemPropertyDescriptor propertyDescriptor : propertyDescriptors) {
                result.append("<tr>");
                String displayName = propertyDescriptor.getDisplayName(element);
                result.append("<td style='word-break: keep-all; padding-left: 4pt; padding-right: 4pt; border: 1px solid gray;'>");
                if (links) {
                    result.append("<a style='text-decoration: none; color: inherit;' href='property:/").append(URI.encodeSegment((String)displayName, (boolean)false)).append("'>");
                }
                result.append(DiagnosticDecorator.escapeContent((String)displayName));
                if (links) {
                    result.append("</a>");
                }
                result.append("</td>");
                result.append("<td style='padding-right: 4pt; border: 1px solid gray;'>");
                IItemLabelProvider propertyLabelProvider = propertyDescriptor.getLabelProvider(element);
                Object propertyValue = propertyDescriptor.getPropertyValue(element);
                if (propertyValue instanceof IItemPropertySource) {
                    propertyValue = ((IItemPropertySource)propertyValue).getEditableValue(element);
                }
                if (propertyValue instanceof EList) {
                    EList propertyValues = (EList)propertyValue;
                    boolean needsBreak = false;
                    for (Object value : propertyValues) {
                        if (needsBreak) {
                            result.append("<br/>\n");
                        } else {
                            needsBreak = true;
                        }
                        ToolTipLabelProvider.renderHTMLPropertyValue(result, propertyLabelProvider, value, links);
                    }
                } else {
                    ToolTipLabelProvider.renderHTMLPropertyValue(result, propertyLabelProvider, propertyValue, links);
                }
                result.append("</td>");
                result.append("</tr>\n");
            }
            result.append("</table>");
            return result.toString();
        }
        return null;
    }

    public static void renderHTMLPropertyValue(StringBuilder result, IItemLabelProvider propertyLabelProvider, Object propertyValue, boolean links) {
        String valueText;
        String href = null;
        if (links) {
            URI uri;
            Object unwrappedValue = AdapterFactoryEditingDomain.unwrap((Object)propertyValue);
            if (unwrappedValue instanceof EObject) {
                EObject eObject = (EObject)unwrappedValue;
                uri = EcoreUtil.getURI((EObject)eObject);
                if (!uri.isCurrentDocumentReference()) {
                    href = uri.toString();
                }
            } else if (unwrappedValue instanceof Resource) {
                Resource resource = (Resource)unwrappedValue;
                uri = resource.getURI();
                href = uri.toString();
            }
            if (href != null) {
                result.append("<a href=\"").append(href).append("\">");
            }
        }
        if ((valueText = propertyLabelProvider.getText(propertyValue)).endsWith("...") && propertyValue instanceof String) {
            String[] lines = propertyValue.toString().split("\r?\n");
            if (lines.length > 1) {
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    result.append(DiagnosticDecorator.escapeContent((String)line)).append("<br/>");
                    ++n2;
                }
            } else {
                result.append(DiagnosticDecorator.escapeContent((String)valueText));
            }
        } else {
            Object image = propertyLabelProvider.getImage(propertyValue);
            if (image != null) {
                result.append("<img style='margin-bottom: -2px; margin-right: 4px;' src='" + ImageURIRegistry.INSTANCE.getImageURI(ExtendedImageRegistry.INSTANCE.getImage(image)) + "'/>");
            }
            if (!StringUtil.isEmpty((String)valueText)) {
                result.append(StringUtil.isEmpty((String)valueText) ? "&nbsp;" : DiagnosticDecorator.escapeContent((String)valueText));
            }
        }
        if (href != null) {
            result.append("<a/>");
        }
    }
}

