/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.extractor.lib;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.oomph.extractor.lib.BINDescriptor;
import org.eclipse.oomph.extractor.lib.BINMarker;
import org.eclipse.oomph.extractor.lib.IO;

public final class BINExtractor
extends IO {
    private static final String NL = System.getProperty("line.separator");
    private static final boolean DEBUG = "true".equals(System.getProperty("org.eclipse.oomph.extractor.lib.BINExtractor.log"));

    public static void main(String[] args) throws Exception {
        BINDescriptor descriptor;
        if (args.length < 2) {
            BINExtractor.exit();
        }
        String executable = args[0];
        String targetFolder = args[1];
        String javaHome = null;
        boolean export = false;
        File markerFile = null;
        File extractorFile = null;
        File libdataFile = null;
        File descriptorFile = null;
        File zipFile = null;
        File jreTarCabFile = null;
        int extraArgs = args.length;
        if (args.length > 2) {
            String arg = args[2];
            if ("-export".equals(arg)) {
                if (args.length < 7) {
                    BINExtractor.exit();
                }
                export = true;
                markerFile = new File(args[3]);
                extractorFile = new File(args[4]);
                libdataFile = new File(args[5]);
                descriptorFile = new File(args[6]);
                zipFile = new File(targetFolder);
                jreTarCabFile = args.length > 7 ? new File(args[7]) : new File(zipFile.getAbsoluteFile().getParentFile(), "jre.tar.cab");
            } else if ("--".equals(arg)) {
                extraArgs = 3;
            } else {
                javaHome = arg;
                if (args.length > 3 && "--".equals(args[3])) {
                    extraArgs = 4;
                }
            }
        }
        FileInputStream in = new FileInputStream(executable);
        try {
            BufferedInputStream stream = new BufferedInputStream(in);
            byte[] pattern = BINMarker.getBytes();
            if (export) {
                BINExtractor.copy((InputStream)new ByteArrayInputStream(pattern), markerFile);
            }
            IO.KMPInputStream kmpStream = new IO.KMPInputStream(stream, pattern);
            int[] failure = kmpStream.getFailure();
            if (export) {
                BINExtractor.copy((InputStream)kmpStream, extractorFile);
            } else {
                BINExtractor.drain(kmpStream);
            }
            kmpStream = new IO.KMPInputStream(stream, pattern, failure);
            if (export) {
                BINExtractor.copy((InputStream)kmpStream, libdataFile);
            } else {
                BINExtractor.drain(kmpStream);
            }
            kmpStream = new IO.KMPInputStream(stream, pattern, failure);
            descriptor = new BINDescriptor(kmpStream);
            if (export) {
                descriptor.write(descriptorFile);
            }
            kmpStream = new IO.KMPInputStream(stream, pattern, failure);
            if (export) {
                BINExtractor.copy((InputStream)kmpStream, zipFile);
            } else {
                BINExtractor.unzip(kmpStream, targetFolder);
            }
            if (export && descriptor.getFormat() == 2) {
                kmpStream = new IO.KMPInputStream(stream, pattern, failure);
                BINExtractor.copy((InputStream)kmpStream, jreTarCabFile);
            }
        }
        finally {
            BINExtractor.close(in);
        }
        if (!export) {
            String launcher;
            PrintStream log;
            Vector<String> vmArgs = null;
            int vmArgStart = args.length;
            int vmArgCount = 0;
            int i = extraArgs;
            while (i < args.length) {
                String arg = args[i];
                if ("-vmargs".equals(arg)) {
                    vmArgStart = i;
                    ++vmArgCount;
                    vmArgs = new Vector<String>();
                } else if (vmArgs != null) {
                    ++vmArgCount;
                    vmArgs.add(arg);
                }
                ++i;
            }
            PrintStream printStream = log = DEBUG ? new PrintStream(new File(targetFolder, "extractor.log"), "UTF-8") : null;
            if (DEBUG) {
                int i2 = 0;
                while (i2 < args.length) {
                    log.println("arg[" + i2 + "]='" + args[i2] + "'");
                    ++i2;
                }
                log.println();
                log.println("executable=" + executable);
                log.println("targetFolder=" + targetFolder);
                log.println("javaHome=" + javaHome);
                log.println("vmArgs=" + vmArgs);
                log.println();
            }
            if (javaHome != null || vmArgs != null && !vmArgs.isEmpty()) {
                BINExtractor.adjustIni(String.valueOf(targetFolder) + File.separator + descriptor.getIniPath(), javaHome, vmArgs);
            }
            String[] command = new String[args.length - extraArgs - vmArgCount + 1];
            command[0] = launcher = String.valueOf(targetFolder) + File.separator + descriptor.getLauncherPath();
            int i3 = extraArgs;
            int j = 1;
            while (i3 < vmArgStart) {
                command[j] = args[i3];
                ++i3;
                ++j;
            }
            if (DEBUG) {
                i3 = 0;
                while (i3 < command.length) {
                    log.println("command[" + i3 + "]='" + command[i3] + "'");
                    ++i3;
                }
                log.close();
            }
            Runtime.getRuntime().exec(command);
        }
    }

    private static void exit() {
        System.out.println("Usage: <product>.exe <product.zip> -export <marker.txt> <extractor>.exe <extractor-lib>.jar <product-descriptor> [<jre.tar.cab>]");
        System.exit(1);
    }

    private static void copy(InputStream source, File targetFile) throws IOException {
        File parentFile = targetFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        FileOutputStream target = new FileOutputStream(targetFile);
        try {
            BINExtractor.copy(source, target);
        }
        finally {
            BINExtractor.close(target);
        }
    }

    private static void adjustIni(String iniPath, String javaHome, Vector vmArgs) throws IOException {
        File file = new File(iniPath);
        Vector<String> lines = new Vector<String>();
        if (file.exists()) {
            String line;
            FileInputStream in = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader(in);
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
            bufferedReader.close();
            ((Reader)reader).close();
            ((InputStream)in).close();
        }
        if (javaHome != null) {
            String value = BINExtractor.getVMPath(javaHome);
            String option = "-vm";
            int optionIndex = lines.indexOf(option);
            if (optionIndex != -1) {
                lines.set(optionIndex + 1, value);
            } else {
                int vmargsIndex = lines.indexOf("-vmargs");
                if (vmargsIndex == -1) {
                    vmargsIndex = lines.size();
                }
                lines.add(vmargsIndex, option);
                lines.add(vmargsIndex + 1, value);
            }
        }
        if (vmArgs != null && !vmArgs.isEmpty()) {
            int vmargsIndex = lines.indexOf("-vmargs");
            if (vmargsIndex == -1) {
                lines.add("-vmargs");
                vmargsIndex = lines.size();
            }
            Enumeration it = vmArgs.elements();
            while (it.hasMoreElements()) {
                lines.add((String)it.nextElement());
            }
        }
        FileOutputStream out = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter(out);
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        Enumeration it = lines.elements();
        while (it.hasMoreElements()) {
            bufferedWriter.write((String)it.nextElement());
            bufferedWriter.write(NL);
        }
        bufferedWriter.close();
        ((Writer)writer).close();
        ((OutputStream)out).close();
    }

    private static String getVMPath(String javaHome) {
        if (javaHome.endsWith(".exe")) {
            return new File(javaHome).getParent();
        }
        return new File(javaHome, "bin").toString();
    }
}

