/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.e4.ui.css.core.css2.CSS2ColorHelper;
import org.eclipse.e4.ui.css.core.css2.CSS2RGBColorImpl;
import org.eclipse.e4.ui.css.core.dom.properties.Gradient;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.ThemeElementDefinitionHelper;
import org.eclipse.e4.ui.internal.css.swt.CSSActivator;
import org.eclipse.e4.ui.internal.css.swt.definition.IColorAndFontProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.RGBColor;

public class CSSSWTColorHelper {
    public static final String COLOR_DEFINITION_MARKER = "#";
    private static final Pattern HEX_COLOR_VALUE_PATTERN = Pattern.compile("#[a-fA-F0-9]{6}");
    private static Field[] cachedFields;

    public static Color getSWTColor(RGBColor rgbColor, Display display) {
        RGBA rgb = CSSSWTColorHelper.getRGBA(rgbColor);
        return new Color((Device)display, rgb);
    }

    public static Color getSWTColor(CSSValue value, Display display) {
        if (value.getCssValueType() != 1) {
            return null;
        }
        Color color = display.getSystemColor(2);
        RGBA rgba = CSSSWTColorHelper.getRGBA((CSSPrimitiveValue)value, display);
        if (rgba != null) {
            color = new Color((Device)display, rgba.rgb.red, rgba.rgb.green, rgba.rgb.blue, rgba.alpha);
        }
        return color;
    }

    private static RGBA getRGBA(CSSPrimitiveValue value, Display display) {
        RGBA rgba = CSSSWTColorHelper.getRGBA(value);
        if (rgba == null && display != null) {
            String name = value.getStringValue();
            if (CSSSWTColorHelper.hasColorDefinitionAsValue(name)) {
                rgba = CSSSWTColorHelper.findColorByDefinition(name);
            } else if (name.contains("-")) {
                name = name.replace('-', '_');
                rgba = CSSSWTColorHelper.process(display, name);
            }
        }
        return rgba;
    }

    public static boolean hasColorDefinitionAsValue(CSSValue value) {
        CSSPrimitiveValue primitiveValue;
        if (value.getCssValueType() == 1 && (primitiveValue = (CSSPrimitiveValue)value).getPrimitiveType() == 19) {
            return CSSSWTColorHelper.hasColorDefinitionAsValue(primitiveValue.getStringValue());
        }
        return false;
    }

    public static boolean hasColorDefinitionAsValue(String name) {
        if (name.startsWith(COLOR_DEFINITION_MARKER)) {
            return !HEX_COLOR_VALUE_PATTERN.matcher(name).matches();
        }
        return false;
    }

    private static RGBA process(Display display, String value) {
        Field[] fields = CSSSWTColorHelper.getFields();
        try {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getName().equals(value)) {
                    return display.getSystemColor(field.getInt(null)).getRGBA();
                }
                ++n2;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {}
        return display.getSystemColor(2).getRGBA();
    }

    private static Field[] getFields() {
        if (cachedFields == null) {
            Class<SWT> clazz = SWT.class;
            Field[] allFields = clazz.getDeclaredFields();
            ArrayList<Field> applicableFields = new ArrayList<Field>(allFields.length);
            Field[] fieldArray = allFields;
            int n = allFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getType() == Integer.TYPE && Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && field.getName().startsWith("COLOR")) {
                    applicableFields.add(field);
                }
                ++n2;
            }
            cachedFields = applicableFields.toArray(new Field[applicableFields.size()]);
        }
        return cachedFields;
    }

    public static RGBA getRGBA(String name) {
        RGBColor color = CSS2ColorHelper.getRGBColor((String)name);
        if (color != null) {
            return CSSSWTColorHelper.getRGBA(color);
        }
        return null;
    }

    public static RGBA getRGBA(RGBColor color) {
        return new RGBA((int)color.getRed().getFloatValue((short)1), (int)color.getGreen().getFloatValue((short)1), (int)color.getBlue().getFloatValue((short)1), 255);
    }

    public static RGBA getRGBA(CSSValue value) {
        if (value.getCssValueType() != 1) {
            return null;
        }
        return CSSSWTColorHelper.getRGBA((CSSPrimitiveValue)value);
    }

    public static RGBA getRGBA(CSSPrimitiveValue value) {
        RGBA rgba = null;
        switch (value.getPrimitiveType()) {
            case 19: 
            case 21: {
                String string = value.getStringValue();
                rgba = CSSSWTColorHelper.getRGBA(string);
                break;
            }
            case 25: {
                RGBColor rgbColor = value.getRGBColorValue();
                rgba = CSSSWTColorHelper.getRGBA(rgbColor);
            }
        }
        return rgba;
    }

    public static Integer getPercent(CSSPrimitiveValue value) {
        int percent = 0;
        switch (value.getPrimitiveType()) {
            case 2: {
                percent = (int)value.getFloatValue((short)2);
            }
        }
        return percent;
    }

    /*
     * Unable to fully structure code
     */
    public static Gradient getGradient(CSSValueList list, Display display) {
        gradient = new Gradient();
        i = 0;
        while (i < list.getLength()) {
            block19: {
                value = list.item(i);
                if (value.getCssValueType() != 1) break block19;
                primType = ((CSSPrimitiveValue)value).getPrimitiveType();
                if (primType != 21) ** GOTO lbl-1000
                var6_6 = value.getCssText();
                tmp = -1;
                switch (var6_6.hashCode()) {
                    case -1102672091: {
                        if (var6_6.equals("linear")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case -938579425: {
                        if (var6_6.equals("radial")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 89650992: {
                        if (var6_6.equals("gradient")) {
                            tmp = 3;
                        }
                        break;
                    }
                }
                block5 : switch (tmp) {
                    case 1: {
                        gradient.setLinear(true);
                        break;
                    }
                    case 2: {
                        gradient.setLinear(false);
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        switch (primType) {
                            case 19: 
                            case 21: 
                            case 25: {
                                rgba = CSSSWTColorHelper.getRGBA((CSSPrimitiveValue)value, display);
                                if (rgba != null) {
                                    gradient.addRGB((Object)rgba, (CSSPrimitiveValue)value);
                                    break block5;
                                }
                                gradient.setVertical(value.getCssText().equals("false") == false);
                                break block5;
                            }
                            case 2: {
                                gradient.addPercent(CSSSWTColorHelper.getPercent((CSSPrimitiveValue)value));
                            }
                        }
                    }
                    case 3: 
                }
            }
            ++i;
        }
        return gradient;
    }

    public static Color[] getSWTColors(Gradient grad, Display display, CSSEngine engine) throws Exception {
        List values = grad.getValues();
        Color[] colors = new Color[values.size()];
        int i = 0;
        while (i < values.size()) {
            Color color;
            CSSPrimitiveValue value = (CSSPrimitiveValue)values.get(i);
            colors[i] = color = (Color)engine.convert((CSSValue)value, Color.class, (Object)display);
            ++i;
        }
        return colors;
    }

    public static int[] getPercents(Gradient grad) {
        if (grad.getRGBs().size() == grad.getPercents().size() + 1) {
            int[] percents = new int[grad.getPercents().size()];
            int i = 0;
            while (i < percents.length) {
                int value = (Integer)grad.getPercents().get(i);
                if (value < 0 || value > 100) {
                    return CSSSWTColorHelper.getDefaultPercents(grad);
                }
                percents[i] = value;
                ++i;
            }
            return percents;
        }
        return CSSSWTColorHelper.getDefaultPercents(grad);
    }

    private static int[] getDefaultPercents(Gradient grad) {
        if (grad.getRGBs().size() <= 1) {
            return new int[0];
        }
        int[] percents = new int[grad.getRGBs().size() - 1];
        float increment = 100.0f / (float)(grad.getRGBs().size() - 1);
        int i = 0;
        while (i < percents.length) {
            percents[i] = Math.round((float)(i + 1) * increment);
            ++i;
        }
        return percents;
    }

    public static RGBColor getRGBColor(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return new CSS2RGBColorImpl(red, green, blue);
    }

    public static RGBColor getRGBColor(RGB color) {
        int red = color.red;
        int green = color.green;
        int blue = color.blue;
        return new CSS2RGBColorImpl(red, green, blue);
    }

    private static RGBA findColorByDefinition(String name) {
        RGB rgb;
        IColorAndFontProvider provider = CSSActivator.getDefault().getColorAndFontProvider();
        if (provider != null && (rgb = provider.getColor(ThemeElementDefinitionHelper.normalizeId(name.substring(1)))) != null) {
            return new RGBA(rgb.red, rgb.green, rgb.blue, 255);
        }
        return null;
    }

    public static boolean equals(Color c1, Color c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.equals((Object)c2);
    }

    public static void setForeground(Control control, Color newColor) {
        if (!CSSSWTColorHelper.equals(control.getForeground(), newColor)) {
            control.setForeground(newColor);
        }
    }

    public static void setBackground(Control control, Color newColor) {
        if (!CSSSWTColorHelper.equals(control.getBackground(), newColor)) {
            control.setBackground(newColor);
        }
    }

    public static void setSelectionForeground(CTabFolder folder, Color newColor) {
        if (!CSSSWTColorHelper.equals(folder.getSelectionForeground(), newColor)) {
            folder.setSelectionForeground(newColor);
        }
    }

    public static void setSelectionBackground(CTabFolder folder, Color newColor) {
        if (!CSSSWTColorHelper.equals(folder.getSelectionBackground(), newColor)) {
            folder.setSelectionBackground(newColor);
        }
    }
}

