/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.questionnaire;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.setup.ui.questionnaire.AnimatedCanvas;
import org.eclipse.oomph.setup.ui.questionnaire.ExitShell;
import org.eclipse.oomph.setup.ui.questionnaire.Messages;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class GearAnimator
extends AnimatedCanvas.Animator {
    public static final String RECORDER_PREFERENCE_KEY = "RECORDER_PREFERENCE_KEY";
    public static final int NONE = -1;
    public static final int PAGE_WIDTH = 620;
    public static final int PAGE_HEIGHT = 420;
    public static final int BORDER = 30;
    public static final int GEARS = 7;
    private static final int TEETH = 8;
    private static final float ANGLE = 45.0f;
    private static final double RADIAN = Math.PI / 180;
    private static final int EXIT = -2;
    private static final int BACK = -3;
    private static final int NEXT = -4;
    private static final int CHOICES = -5;
    private static final String[] TITLES = new String[]{Messages.GearAnimator_titles_welcome, Messages.GearAnimator_titles_refreshResources, Messages.GearAnimator_titles_showLineNumbers, Messages.GearAnimator_titles_checkSpelling, Messages.GearAnimator_titles_executeJobsInBackground, Messages.GearAnimator_titles_encodeTextFiles, Messages.GearAnimator_titles_enablePreferenceRecorder};
    static final int BIG_FONT_PX = 48;
    static final int NORMAL_FONT_PX = 36;
    private static Color WHITE;
    private static Color GRAY;
    private static Color DARK_GRAY;
    private final List<Listener> listeners = new ArrayList<Listener>();
    private Color purple;
    private Color tooltipColor;
    private Font tooltipFont;
    private Font bigFont;
    private Font hoverFont;
    private Font normalFont;
    private Font numberFont;
    private Image exit;
    private Image exitHover;
    private Image question;
    private final Image[] welcomeImages = new Image[2];
    private final Image[] summaryImages = new Image[2];
    private final Image[] backImages = new Image[2];
    private final Image[] nextImages = new Image[2];
    private final Image[] yesImages = new Image[5];
    private final Image[] noImages = new Image[5];
    private final Page[] pages = new Page[8];
    private final Point[] tooltipPoints = new Point[this.pages.length];
    private final Path[] gearPaths = new Path[8];
    private final Color[] gearBackground = new Color[2];
    private final Color[] gearForeground = new Color[2];
    private float radius;
    private int pageY;
    private int answerY;
    private int buttonR;
    private long startAnimation;
    private float speed;
    private float angle;
    private boolean overflow;
    private int selection;
    private int oldSelection = -1;
    private int hover = -1;
    private int oldHover = -1;
    private Image pageBuffer;
    private GC pageGC;
    private Image oldPageBuffer;
    private GC oldPageGC;
    private boolean pageBufferUpdated;
    private boolean oldShowOverlay;
    private boolean summaryShown;
    private Rectangle exitBox;
    private Rectangle backBox;
    private Rectangle nextBox;

    public GearAnimator(Display display) {
        super(display);
        WHITE = display.getSystemColor(1);
        GRAY = display.getSystemColor(15);
        DARK_GRAY = display.getSystemColor(16);
    }

    protected void init() {
        super.init();
        Display display = this.getDisplay();
        this.bigFont = this.createFont(48, 620, TITLES);
        this.hoverFont = this.createFont(54, 620, TITLES);
        this.normalFont = this.createFont(36, 620, TITLES);
        this.numberFont = this.createFont(24);
        this.tooltipFont = this.createFont(16);
        this.exit = this.loadImage("exit.png");
        this.exitHover = this.loadImage("exit_hover.png");
        this.question = this.loadImage("question.png");
        this.welcomeImages[0] = this.loadImage("welcome.png");
        this.welcomeImages[1] = this.loadImage("welcome_select.png");
        this.summaryImages[0] = this.loadImage("summary.png");
        this.summaryImages[1] = this.loadImage("summary_select.png");
        this.backImages[0] = this.loadImage("back.png");
        this.backImages[1] = this.loadImage("back_hover.png");
        this.nextImages[0] = this.loadImage("next.png");
        this.nextImages[1] = this.loadImage("next_hover.png");
        this.buttonR = this.nextImages[0].getBounds().height / 2;
        this.answerY = 540 - this.buttonR;
        this.yesImages[0] = this.loadImage("yes.png");
        this.yesImages[1] = this.loadImage("yes_select.png");
        this.yesImages[2] = this.loadImage("yes_hover.png");
        this.yesImages[3] = this.loadImage("yes_big.png");
        this.yesImages[4] = this.loadImage("yes_badge.png");
        this.noImages[0] = this.loadImage("no.png");
        this.noImages[1] = this.loadImage("no_select.png");
        this.noImages[2] = this.loadImage("no_hover.png");
        this.noImages[3] = this.loadImage("no_big.png");
        this.noImages[4] = this.loadImage("no_badge.png");
        this.radius = 32.0f;
        this.setSize((int)(14.0f * this.radius), (int)(2.0f * this.radius));
        this.pageY = this.getHeight() + 60;
        this.gearBackground[0] = this.createColor(169, 171, 202);
        this.gearForeground[0] = this.createColor(140, 132, 171);
        this.gearBackground[1] = this.createColor(247, 148, 30);
        this.gearForeground[1] = this.createColor(207, 108, 0);
        this.purple = this.createColor(43, 34, 84);
        this.tooltipColor = this.createColor(253, 232, 206);
        this.pages[0] = new ImagePage(0, TITLES[0], 0, 0, 0, new TextAnswer(""));
        this.pages[1] = new PreferencePage(1, TITLES[1], 0, 5, 29, "/instance/org.eclipse.core.resources/refresh.lightweight.enabled");
        this.pages[2] = new PreferencePage(2, TITLES[2], 1, 19, 30, "/instance/org.eclipse.ui.editors/lineNumberRuler");
        this.pages[3] = new PreferencePage(3, TITLES[3], 1, 186, 37, "/instance/org.eclipse.ui.editors/spellingEnabled");
        this.pages[4] = new PreferencePage(4, TITLES[4], 0, 23, 160, "/instance/org.eclipse.ui.workbench/RUN_IN_BACKGROUND");
        this.pages[5] = new PreferencePage(5, TITLES[5], 0, 181, 95, "/instance/org.eclipse.core.resources/encoding", "UTF-8", null);
        this.pages[6] = new PreferencePage(6, TITLES[6], 1, 57, 82, RECORDER_PREFERENCE_KEY);
        this.pages[7] = new SummaryPage(7, "Summary");
        this.pageBuffer = new Image((Device)display, 620, 420);
        this.pageGC = new GC((Drawable)this.pageBuffer);
        this.pageGC.setAdvanced(true);
        this.oldPageBuffer = new Image((Device)display, 620, 420);
        this.oldPageGC = new GC((Drawable)this.oldPageBuffer);
        this.oldPageGC.setAdvanced(true);
    }

    protected void dispose() {
        Object[] objectArray = this.gearPaths;
        int n = this.gearPaths.length;
        int n2 = 0;
        while (n2 < n) {
            Path path = objectArray[n2];
            if (path != null) {
                path.dispose();
            }
            ++n2;
        }
        objectArray = this.pages;
        n = this.pages.length;
        n2 = 0;
        while (n2 < n) {
            Path page = objectArray[n2];
            if (page != null) {
                page.dispose();
            }
            ++n2;
        }
        this.pageGC.dispose();
        this.pageBuffer.dispose();
        this.oldPageGC.dispose();
        this.oldPageBuffer.dispose();
        super.dispose();
    }

    public Font getBigFont() {
        return this.bigFont;
    }

    public Font getHoverFont() {
        return this.hoverFont;
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(Listener listener) {
        List<Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Listener[] getListeners() {
        List<Listener> list = this.listeners;
        synchronized (list) {
            return this.listeners.toArray(new Listener[this.listeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(Listener listener) {
        List<Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void restart() {
        this.angle = 0.0f;
        this.speed = 0.0f;
    }

    public final Page[] getPages() {
        return this.pages;
    }

    public final int getSelection() {
        return this.selection;
    }

    public final void setSelection(int selection) {
        this.hover = -1;
        this.oldHover = -1;
        if (selection < 0) {
            selection = 0;
            this.overflow = true;
        } else if (selection > this.pages.length - 1) {
            selection = this.pages.length - 1;
            this.overflow = true;
        }
        if (this.overflow) {
            this.overflow = false;
            while (this.advance()) {
            }
            this.overflow = true;
            return;
        }
        this.oldSelection = this.selection;
        this.selection = selection;
        if (this.getSelectedPage() instanceof SummaryPage) {
            this.summaryShown = true;
        }
        this.oldPageBuffer.dispose();
        this.oldPageBuffer = this.pageBuffer;
        this.oldPageGC.dispose();
        this.oldPageGC = this.pageGC;
        this.pageBuffer = new Image((Device)this.getDisplay(), 620, 420);
        this.pageGC = new GC((Drawable)this.pageBuffer);
        this.pageGC.setAdvanced(true);
        this.pageBufferUpdated = false;
        this.restart();
    }

    public final int getOldSelection() {
        return this.oldSelection;
    }

    public final Page getSelectedPage() {
        return this.pages[this.selection];
    }

    protected boolean onKeyPressed(KeyEvent e) {
        if (e.keyCode == 27) {
            this.exit();
            return true;
        }
        if (e.keyCode == 0x1000007) {
            this.setSelection(0);
            return true;
        }
        if (e.keyCode == 0x1000008) {
            this.setSelection(7);
            return true;
        }
        if (e.keyCode == 0x1000004 || e.keyCode == 0x1000006) {
            this.setSelection(this.getSelection() + 1);
            return true;
        }
        if (e.keyCode == 0x1000003 || e.keyCode == 0x1000005) {
            this.setSelection(this.getSelection() - 1);
            return true;
        }
        if (e.character >= '0' && e.character <= '6') {
            this.setSelection(e.character - 48);
            return true;
        }
        if (e.character == '\r') {
            Page page = this.getSelectedPage();
            if (page instanceof SummaryPage) {
                page.doAnswer(0);
            } else {
                this.setSelection(this.getSelection() + 1);
            }
            return true;
        }
        if (e.character == 'y' || e.character == 'Y' || e.character == '+') {
            Page page = this.getSelectedPage();
            if (page instanceof PreferencePage) {
                page.doAnswer(0);
            }
            return true;
        }
        if (e.character == 'n' || e.character == 'N' || e.character == '-') {
            Page page = this.getSelectedPage();
            if (page instanceof PreferencePage) {
                page.doAnswer(1);
            }
            return true;
        }
        return false;
    }

    protected boolean onMouseMove(int x, int y) {
        if (x != Integer.MIN_VALUE && y != Integer.MIN_VALUE) {
            GC gc = new GC((Drawable)this.getCanvas());
            int i = 0;
            while (i < this.gearPaths.length) {
                Path path = this.gearPaths[i];
                if (path != null && path.contains((float)x, (float)y, gc, false)) {
                    if (i != this.hover) {
                        this.hover = i;
                    }
                    return true;
                }
                ++i;
            }
            if (this.exitBox != null && this.exitBox.contains(x, y)) {
                this.hover = -2;
                return true;
            }
            Page page = this.getSelectedPage();
            if (page != null) {
                if (page.showBack() && this.backBox != null && this.backBox.contains(x, y)) {
                    this.hover = -3;
                    return true;
                }
                if (page.showNext() && this.nextBox != null && this.nextBox.contains(x, y)) {
                    this.hover = -4;
                    return true;
                }
                this.hover = page.onMouseMove(x -= 30, y -= this.pageY);
                if (this.hover != -1) {
                    return true;
                }
            }
        }
        this.hover = -1;
        return false;
    }

    protected boolean onMouseDown(int x, int y) {
        if (x != Integer.MIN_VALUE && y != Integer.MIN_VALUE) {
            GC gc = new GC((Drawable)this.getCanvas());
            int i = 0;
            while (i < this.gearPaths.length) {
                Path path = this.gearPaths[i];
                if (path != null && path.contains((float)x, (float)y, gc, false)) {
                    if (i != this.getSelection()) {
                        this.setSelection(i);
                    }
                    return true;
                }
                ++i;
            }
            if (this.exitBox != null && this.exitBox.contains(x, y)) {
                this.exit();
                return true;
            }
            Page page = this.getSelectedPage();
            if (page != null) {
                if (page.showBack() && this.backBox != null && this.backBox.contains(x, y)) {
                    this.setSelection(this.getSelection() - 1);
                    return true;
                }
                if (page.showNext() && this.nextBox != null && this.nextBox.contains(x, y)) {
                    this.setSelection(this.getSelection() + 1);
                    return true;
                }
                if (page.onMouseDown(x -= 30, y -= this.pageY)) {
                    return true;
                }
            }
        }
        return false;
    }

    protected void exit() {
        this.hover = -2;
        AnimatedCanvas canvas = this.getCanvas();
        canvas.redraw();
        ExitShell exitShell = new ExitShell(this);
        Boolean result = (Boolean)exitShell.openModal();
        if (Boolean.TRUE.equals(result)) {
            Listener[] listenerArray = this.getListeners();
            int n = listenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Listener listener = listenerArray[n2];
                listener.onExit(this, this.getSelectedPage());
                ++n2;
            }
        }
        this.hover = -1;
        if (!canvas.isDisposed()) {
            canvas.redraw();
        }
    }

    protected boolean shouldShowOverlay() {
        Page page = this.getSelectedPage();
        if (page instanceof ImagePage) {
            ImagePage questionPage = (ImagePage)page;
            if (this.hover <= -5) {
                int hoveredChoice = -this.hover + -5;
                return hoveredChoice == questionPage.getOverlayChoice();
            }
            int choice = questionPage.getChoice();
            if (choice != -1) {
                return choice == questionPage.getOverlayChoice();
            }
        }
        return (System.currentTimeMillis() / 1000L & 1L) == 1L;
    }

    protected boolean advance() {
        boolean showOverlay;
        boolean needsRedraw = false;
        if (this.overflow) {
            this.overflow = false;
            needsRedraw = true;
        }
        if ((showOverlay = this.shouldShowOverlay()) != this.oldShowOverlay) {
            this.oldShowOverlay = showOverlay;
            this.updatePage();
            needsRedraw = true;
        }
        if (this.hover != this.oldHover) {
            needsRedraw = true;
        }
        if (this.speed >= 45.0f) {
            this.startAnimation = 0L;
            return needsRedraw;
        }
        long now = System.currentTimeMillis();
        if (this.startAnimation == 0L) {
            this.startAnimation = now;
        }
        long timeSinceStart = now - this.startAnimation;
        this.speed = (float)timeSinceStart * 45.0f / 1900.0f;
        this.angle += this.speed;
        return true;
    }

    protected void paint(GC gc, Image buffer) {
        gc.setFont(this.getBaseFont());
        gc.setLineWidth(3);
        gc.setAntialias(1);
        Page page = this.getSelectedPage();
        int alpha = Math.min((int)(255.0f * this.speed / 45.0f), 255);
        int i = 0;
        while (i < 8) {
            if (i != this.selection && (i < 7 || this.summaryShown)) {
                this.tooltipPoints[i] = this.paintGear(gc, i, alpha);
            }
            ++i;
        }
        this.tooltipPoints[this.selection] = this.paintGear(gc, this.selection, alpha);
        int centerX = 650 - this.exit.getBounds().width / 2;
        int centerY = 30 + this.exit.getBounds().height / 2;
        Image exitImage = this.hover == -2 ? this.exitHover : this.exit;
        this.exitBox = exitImage.getBounds();
        this.exitBox.x = centerX - exitImage.getBounds().width / 2;
        this.exitBox.y = centerY - exitImage.getBounds().height / 2;
        gc.drawImage(exitImage, this.exitBox.x, this.exitBox.y);
        if (!this.pageBufferUpdated) {
            this.updatePage();
            this.pageBufferUpdated = true;
        }
        if (this.oldSelection == -1) {
            gc.setAlpha(alpha);
            gc.drawImage(this.pageBuffer, 30, this.pageY);
            gc.setAlpha(255);
        } else {
            double progress = 2.0f * this.speed / 45.0f;
            int slide = Math.min((int)(620.0 * progress * progress), 620);
            gc.setAlpha(255 - alpha);
            if (this.selection > this.oldSelection) {
                gc.drawImage(this.oldPageBuffer, slide, 0, 620 - slide, 420, 30, this.pageY, 620 - slide, 420);
                gc.setAlpha(alpha);
                gc.drawImage(this.pageBuffer, 0, 0, slide, 420, 650 - slide, this.pageY, slide, 420);
            } else {
                gc.drawImage(this.oldPageBuffer, 0, 0, 620 - slide, 420, 30 + slide, this.pageY, 620 - slide, 420);
                gc.setAlpha(alpha);
                gc.drawImage(this.pageBuffer, 620 - slide, 0, slide, 420, 30, this.pageY, slide, 420);
            }
            gc.setAlpha(255);
        }
        if (this.hover >= 0 && this.hover < this.tooltipPoints.length) {
            Point point = this.tooltipPoints[this.hover];
            String title = this.pages[this.hover].getTitle();
            gc.setFont(this.tooltipFont);
            gc.setForeground(DARK_GRAY);
            gc.setBackground(this.tooltipColor);
            Rectangle rectangle = GearAnimator.drawText(gc, point.x, point.y + 14, title, 2);
            gc.setForeground(GRAY);
            gc.setLineWidth(1);
            gc.drawRectangle(rectangle);
        }
        if (page.showBack()) {
            this.backBox = AnimatedCanvas.Animator.drawImage(gc, this.backImages[this.hover == -3 ? 1 : 0], 30 + this.buttonR, this.answerY);
        }
        if (page.showNext()) {
            this.nextBox = AnimatedCanvas.Animator.drawImage(gc, this.nextImages[this.hover == -4 ? 1 : 0], 650 - this.buttonR, this.answerY);
        }
        this.oldHover = this.hover;
    }

    private Point paintGear(GC gc, int i, int alpha) {
        double offset = (float)(2 * i) * this.radius;
        double x = (double)(30.0f + this.radius) + offset;
        double y = 30.0f + this.radius;
        double r2 = (double)this.radius * (double)0.8f;
        double r3 = (double)this.radius * 0.5;
        int selected = 0;
        double factor = 1.0;
        if (i == this.oldSelection) {
            if (this.speed < 22.5f) {
                selected = 1;
            }
        } else if (i == this.selection) {
            if (this.speed >= 22.5f) {
                selected = 1;
                factor += (double)(45.0f - this.speed) * 0.02;
            } else {
                factor += (double)this.speed * 0.02;
            }
        }
        boolean hovered = false;
        if (i == this.hover) {
            factor += 0.1;
            this.oldHover = this.hover;
            if (selected == 0) {
                hovered = true;
            }
        }
        double outerR = factor * (double)this.radius;
        double innerR = factor * r2;
        float angleOffset = (this.angle + (float)i * 45.0f) * (float)(i % 2 == 1 ? -1 : 1);
        gc.setForeground(hovered ? DARK_GRAY : this.gearForeground[selected]);
        gc.setBackground(hovered ? GRAY : this.gearBackground[selected]);
        Display display = this.getDisplay();
        Path path = GearAnimator.drawGear(gc, display, x, y, outerR, innerR, angleOffset);
        if (this.gearPaths[i] != null) {
            this.gearPaths[i].dispose();
        }
        this.gearPaths[i] = path;
        int ovalX = (int)(x - factor * r3);
        int ovalY = (int)(y - factor * r3);
        int ovalR = (int)(2.0 * factor * r3);
        gc.setBackground(WHITE);
        gc.fillOval(ovalX, ovalY, ovalR, ovalR);
        gc.drawOval(ovalX, ovalY, ovalR, ovalR);
        if (i == 0) {
            AnimatedCanvas.Animator.drawImage(gc, this.welcomeImages[selected], (int)x, (int)y);
        } else if (i < 7) {
            String number = Integer.toString(i);
            gc.setForeground(selected == 1 ? this.gearForeground[1] : GRAY);
            gc.setFont(this.numberFont);
            AnimatedCanvas.Animator.drawText(gc, x, y - 1.0, number);
        } else {
            AnimatedCanvas.Animator.drawImage(gc, this.summaryImages[selected], (int)x, (int)y);
        }
        return this.paintBadge(gc, x, y, outerR, i, alpha);
    }

    private Point paintBadge(GC gc, double x, double y, double outerR, int i, int alpha) {
        if (this.selection >= 7) {
            gc.setAlpha(255 - alpha);
        } else if (this.oldSelection >= 7) {
            gc.setAlpha(alpha);
        }
        Page page = this.pages[i];
        Answer answer = page.getChoiceAnswer();
        if (answer instanceof ImageAnswer) {
            ImageAnswer imageAnswer = (ImageAnswer)answer;
            Image image = imageAnswer.getImages()[4];
            gc.drawImage(image, (int)(x - (double)(image.getBounds().width / 2)), (int)(y - outerR - 12.0));
        }
        gc.setAlpha(255);
        return new Point((int)x, (int)(y + outerR));
    }

    private Page updatePage() {
        this.pageGC.setBackground(WHITE);
        this.pageGC.fillRectangle(this.pageBuffer.getBounds());
        Page page = this.getSelectedPage();
        page.paint(this.pageGC);
        return page;
    }

    void updateOverlay(int x, int y) {
        Page page = this.getSelectedPage();
        if (page instanceof ImagePage) {
            ImagePage questionPage;
            ImagePage imagePage = questionPage = (ImagePage)page;
            imagePage.overlayX = imagePage.overlayX + x;
            ImagePage imagePage2 = questionPage;
            imagePage2.overlayY = imagePage2.overlayY + y;
            System.out.println(questionPage.overlayX + ", " + questionPage.overlayY);
            this.updatePage();
            this.overflow = true;
        }
    }

    private static Path drawGear(GC gc, Display display, double cx, double cy, double outerR, double innerR, float angleOffset) {
        double radian2 = 0.39269908169872414;
        double radian3 = 0.06;
        Path path = new Path((Device)display);
        int i = 0;
        while (i < 8) {
            double radian = (double)((float)i * 45.0f + angleOffset) * (Math.PI / 180);
            double x = cx + outerR * Math.cos(radian);
            double y = cy - outerR * Math.sin(radian);
            if (i == 0) {
                path.moveTo((float)((int)x), (float)((int)y));
            }
            double r1 = radian + radian3;
            double r3 = radian + radian2;
            double r2 = r3 - radian3;
            double r4 = r3 + radian2;
            x = cx + innerR * Math.cos(r1);
            y = cy - innerR * Math.sin(r1);
            path.lineTo((float)((int)x), (float)((int)y));
            x = cx + innerR * Math.cos(r2);
            y = cy - innerR * Math.sin(r2);
            path.lineTo((float)((int)x), (float)((int)y));
            x = cx + outerR * Math.cos(r3);
            y = cy - outerR * Math.sin(r3);
            path.lineTo((float)((int)x), (float)((int)y));
            x = cx + outerR * Math.cos(r4);
            y = cy - outerR * Math.sin(r4);
            path.lineTo((float)((int)x), (float)((int)y));
            ++i;
        }
        path.close();
        gc.fillPath(path);
        gc.drawPath(path);
        return path;
    }

    public abstract class Answer {
        public abstract Point getSize(GC var1, Page var2);

        public abstract Rectangle paint(GC var1, Page var2, int var3, int var4, int var5, boolean var6, boolean var7);
    }

    public class BackButton
    extends ImageAnswer {
        public BackButton() {
            super(GearAnimator.this.backImages);
        }
    }

    public class ImageAnswer
    extends Answer {
        private final Image[] images;

        public ImageAnswer(Image ... images) {
            this.images = images;
        }

        public final Image[] getImages() {
            return this.images;
        }

        public Point getSize(GC gc, Page page) {
            Rectangle bounds = this.images[2].getBounds();
            return new Point(bounds.width, bounds.height);
        }

        public Rectangle paint(GC gc, Page page, int index, int x, int y, boolean hovered, boolean selected) {
            Image image = this.images[0];
            if (hovered) {
                image = this.images[2];
            } else if (selected) {
                image = this.images[1];
            } else if (page instanceof ImagePage && this.images.length > 3) {
                int overlayChoice = ((ImagePage)page).getOverlayChoice();
                boolean overlayChoiceYes = overlayChoice == index;
                boolean showOverlay = GearAnimator.this.shouldShowOverlay();
                if (showOverlay == overlayChoiceYes) {
                    image = this.images[3];
                }
            }
            return AnimatedCanvas.Animator.drawImage(gc, image, x, y);
        }
    }

    public class ImagePage
    extends Page {
        private final Image image;
        private final Image overlay;
        private final int overlayChoice;
        private int overlayX;
        private int overlayY;

        public ImagePage(int index, String title, int overlayChoice, int overlayX, int overlayY, Answer ... answers) {
            super(index, title);
            this.overlayChoice = overlayChoice;
            this.setAnswers(answers);
            Display display = GearAnimator.this.getDisplay();
            this.image = this.doLoadImage(display, index, "");
            this.overlay = this.doLoadImage(display, index, "_ovr");
            this.overlayX = overlayX;
            this.overlayY = overlayY;
        }

        public ImagePage(int index, String title, int overlayChoice, int overlayX, int overlayY) {
            this(index, title, overlayChoice, overlayX, overlayY, gearAnimator.new ImageAnswer(gearAnimator.yesImages), gearAnimator.new ImageAnswer(gearAnimator.noImages));
        }

        public final int getOverlayChoice() {
            return this.overlayChoice;
        }

        protected void paintContent(GC gc) {
            if (this.image != null) {
                Rectangle bounds = this.image.getBounds();
                int x = (620 - bounds.width) / 2;
                int y = (420 - bounds.height) / 2;
                gc.drawImage(this.image, x, y);
                if (this.overlay != null && GearAnimator.this.shouldShowOverlay()) {
                    gc.drawImage(this.overlay, x + this.overlayX, y + this.overlayY);
                }
            }
        }

        private Image doLoadImage(Display display, int index, String suffix) {
            try {
                return GearAnimator.this.loadImage("page" + index + suffix + ".png");
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    public static interface Listener {
        public void onAnswer(GearAnimator var1, Page var2, Answer var3);

        public void onExit(GearAnimator var1, Page var2);
    }

    public class NextButton
    extends ImageAnswer {
        public NextButton() {
            super(GearAnimator.this.nextImages);
        }
    }

    public abstract class Page {
        private final int index;
        private final String title;
        private Answer[] answers;
        private Rectangle[] answerBoxes;
        private int choice = -1;

        public Page(int index, String title) {
            this.index = index;
            this.title = title;
        }

        public final int getIndex() {
            return this.index;
        }

        public final String getTitle() {
            return this.title;
        }

        public final Answer[] getAnswers() {
            return this.answers;
        }

        public final void setAnswers(Answer[] answers) {
            this.answers = answers;
            this.answerBoxes = new Rectangle[answers.length];
        }

        public final int getAnswer(int x, int y) {
            int i = 0;
            while (i < this.answers.length) {
                Rectangle box = this.answerBoxes[i];
                if (box != null && box.contains(x, y)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public final Answer getChoiceAnswer() {
            return this.choice == -1 ? null : this.answers[this.choice];
        }

        public final int getChoice() {
            return this.choice;
        }

        public final void setChoice(int choice) {
            this.choice = choice;
        }

        protected void dispose() {
        }

        protected boolean showBack() {
            return this.index > 0;
        }

        protected boolean showNext() {
            return this.index < 7;
        }

        protected int onMouseMove(int x, int y) {
            int i = this.getAnswer(x, y);
            if (i != -1) {
                GearAnimator.this.pageBufferUpdated = false;
                return -5 - i;
            }
            if (GearAnimator.this.hover <= -5) {
                GearAnimator.this.pageBufferUpdated = false;
            }
            return -1;
        }

        protected boolean onMouseDown(int x, int y) {
            int i = this.getAnswer(x, y);
            if (i != -1) {
                this.doAnswer(i);
                return true;
            }
            return false;
        }

        protected final void paint(GC gc) {
            String title = this.getTitle();
            Font oldFont = gc.getFont();
            gc.setFont(GearAnimator.this.bigFont);
            Point extent = gc.stringExtent(title);
            gc.setForeground(GearAnimator.this.purple);
            gc.drawText(title, (620 - extent.x) / 2, 0, true);
            gc.setFont(oldFont);
            this.paintContent(gc);
            this.paintAnswers(gc);
        }

        protected abstract void paintContent(GC var1);

        protected int getAnswerY() {
            return GearAnimator.this.answerY;
        }

        private void doAnswer(int i) {
            int selection;
            Answer answer = this.answers[i];
            if (i == this.choice) {
                GearAnimator.this.hover = -1;
                this.choice = -1;
                answer = null;
            } else {
                this.setChoice(i);
            }
            GearAnimator.this.updatePage();
            Listener[] listenerArray = GearAnimator.this.getListeners();
            int n = listenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Listener listener = listenerArray[n2];
                listener.onAnswer(GearAnimator.this, this, answer);
                ++n2;
            }
            if (answer != null && (selection = GearAnimator.this.getSelection()) < 7) {
                GearAnimator.this.setSelection(selection + 1);
            }
        }

        private void paintAnswers(GC gc) {
            boolean[] selecteds = new boolean[this.answers.length];
            boolean[] hovereds = new boolean[this.answers.length];
            Point[] sizes = new Point[this.answers.length];
            int width = (this.answers.length - 1) * 30;
            int height = 0;
            int i = 0;
            while (i < this.answers.length) {
                boolean bl = selecteds[i] = i == this.choice;
                if (-5 - i == GearAnimator.this.hover) {
                    GearAnimator.this.oldHover = GearAnimator.this.hover;
                    hovereds[i] = true;
                }
                sizes[i] = this.answers[i].getSize(gc, this);
                width += sizes[i].x;
                height = Math.max(height, sizes[i].y);
                ++i;
            }
            int x = (620 - width) / 2;
            int y = this.getAnswerY() - GearAnimator.this.pageY;
            int i2 = 0;
            while (i2 < this.answers.length) {
                Answer answer = this.answers[i2];
                this.answerBoxes[i2] = answer.paint(gc, this, i2, x, y, hovereds[i2], selecteds[i2]);
                x += 30 + sizes[i2].x;
                ++i2;
            }
        }
    }

    public class PreferencePage
    extends ImagePage {
        private final URI preferenceKey;
        private final String yesValue;
        private final String noValue;

        public PreferencePage(int index, String title, int overlayChoice, int overlayX, int overlayY, String preferenceKey, String yesValue, String noValue) {
            super(index, title, overlayChoice, overlayX, overlayY, new ImageAnswer(GearAnimator.this.yesImages), new ImageAnswer(GearAnimator.this.noImages));
            this.preferenceKey = PreferencesFactory.eINSTANCE.createURI(preferenceKey);
            this.yesValue = yesValue;
            this.noValue = noValue;
        }

        public PreferencePage(int index, String title, int overlayChoice, int overlayX, int overlayY, String preferenceKey) {
            this(index, title, overlayChoice, overlayX, overlayY, preferenceKey, "true", "false");
        }

        public final URI getPreferenceKey() {
            return this.preferenceKey;
        }

        public final String getYesValue() {
            return this.yesValue;
        }

        public final String getNoValue() {
            return this.noValue;
        }
    }

    public class SummaryPage
    extends Page {
        private Rectangle[] boxes;

        public SummaryPage(int index, String title) {
            super(index, title);
            this.setAnswers(new Answer[]{new TextAnswer("Finish")});
        }

        protected boolean showNext() {
            return false;
        }

        protected int onMouseMove(int x, int y) {
            if (this.boxes != null) {
                int i = 0;
                while (i < this.boxes.length) {
                    Rectangle box = this.boxes[i];
                    if (box.contains(x, y)) {
                        return i + 1;
                    }
                    ++i;
                }
            }
            return super.onMouseMove(x, y);
        }

        protected boolean onMouseDown(int x, int y) {
            if (this.boxes != null) {
                int i = 0;
                while (i < this.boxes.length) {
                    Rectangle box = this.boxes[i];
                    if (box.contains(x, y)) {
                        GearAnimator.this.setSelection(i + 1);
                        return true;
                    }
                    ++i;
                }
            }
            return super.onMouseDown(x, y);
        }

        protected void paintContent(GC gc) {
            gc.setFont(GearAnimator.this.normalFont);
            this.boxes = new Rectangle[6];
            int offsetX = ((GearAnimator)GearAnimator.this).yesImages[4].getBounds().width + 12;
            int minWidth = Integer.MAX_VALUE;
            int maxWidth = 0;
            int i = 1;
            while (i < 7) {
                Page page = GearAnimator.this.pages[i];
                Point extent = gc.stringExtent(page.getTitle());
                int width = extent.x;
                minWidth = Math.min(minWidth, width);
                maxWidth = Math.max(maxWidth, width);
                this.boxes[i - 1] = new Rectangle(0, 0, offsetX + width, extent.y + 4);
                ++i;
            }
            int width = (minWidth + maxWidth) / 2 + offsetX;
            int i2 = 1;
            while (i2 < 7) {
                int x = (620 - width) / 2;
                int y = 40 * (1 + i2);
                ImagePage page = (ImagePage)GearAnimator.this.pages[i2];
                ImageAnswer answer = (ImageAnswer)page.getChoiceAnswer();
                if (answer != null) {
                    gc.drawImage(answer.images[4], x, y + 8);
                    gc.setForeground(GearAnimator.this.purple);
                } else {
                    gc.drawImage(GearAnimator.this.question, x, y + 8);
                    gc.setForeground(DARK_GRAY);
                }
                String title = page.getTitle();
                if (title.endsWith("?")) {
                    title = title.substring(0, title.length() - 1);
                }
                gc.drawText(title, x + offsetX, y);
                this.boxes[i2 - 1].x = x;
                this.boxes[i2 - 1].y = y + 4;
                ++i2;
            }
        }
    }

    public class TextAnswer
    extends Answer {
        private final String text;

        public TextAnswer(String text) {
            this.text = text;
        }

        public final String getText() {
            return this.text;
        }

        public Point getSize(GC gc, Page page) {
            gc.setFont(GearAnimator.this.hoverFont);
            return gc.stringExtent(this.text);
        }

        public Rectangle paint(GC gc, Page page, int index, int x, int y, boolean hovered, boolean selected) {
            gc.setFont(hovered ? GearAnimator.this.hoverFont : GearAnimator.this.bigFont);
            gc.setForeground(selected ? GearAnimator.this.purple : DARK_GRAY);
            Point extent = gc.stringExtent(this.text);
            gc.drawText(this.text, x -= extent.x / 2 - 60, y -= extent.y / 2, true);
            return new Rectangle(x, y, extent.x, extent.y);
        }
    }
}

