/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.keys.BindingPersistence;
import org.eclipse.ui.internal.keys.BindingService;

public class BindingToModelProcessor {
    private Map<String, MBindingContext> contexts = new HashMap<String, MBindingContext>();
    private Map<String, MCommand> commands = new HashMap<String, MCommand>();
    private Map<String, MBindingTable> tables = new HashMap<String, MBindingTable>();
    private Set<MKeyBinding> keys = new HashSet<MKeyBinding>();

    @Execute
    void process(MApplication application, IEclipseContext context) {
        ContextManager contextManager;
        this.gatherContexts(application.getRootContext());
        this.gatherCommands(application.getCommands());
        this.gatherTables(application.getBindingTables());
        CommandManager commandManager = (CommandManager)context.get(CommandManager.class);
        if (commandManager == null) {
            WorkbenchPlugin.log("Command manager was null in org.eclipse.ui.internal.BindingToModelProcessor");
        }
        if ((contextManager = (ContextManager)context.get(ContextManager.class)) == null) {
            WorkbenchPlugin.log("Context manager was null in org.eclipse.ui.internal.BindingToModelProcessor");
        }
        BindingManager bindingManager = new BindingManager(contextManager, commandManager);
        context.set(BindingManager.class, (Object)bindingManager);
        BindingPersistence persistence = new BindingPersistence(bindingManager, commandManager);
        persistence.read();
        application.getTags().add("activeSchemeId:" + bindingManager.getActiveScheme().getId());
        Collection activeBindingsForScheme = bindingManager.getActiveBindingsDisregardingContextFlat();
        for (Object obj : activeBindingsForScheme) {
            Binding binding = (Binding)obj;
            this.addBinding(application, binding);
        }
        this.removeBindings();
        persistence.dispose();
        this.contexts.clear();
        this.commands.clear();
        this.tables.clear();
        this.keys.clear();
    }

    private void gatherTables(List<MBindingTable> bindingTables) {
        for (MBindingTable table : bindingTables) {
            this.tables.put(table.getBindingContext().getElementId(), table);
            this.keys.addAll(table.getBindings());
        }
    }

    public final void addBinding(MApplication application, Binding binding) {
        MBindingTable table = this.tables.get(binding.getContextId());
        if (table == null) {
            table = this.createTable(application, binding.getContextId());
        }
        MKeyBinding model = BindingService.createOrUpdateMKeyBinding(application, table, binding);
        this.keys.remove(model);
    }

    private void removeBindings() {
        for (MKeyBinding key : this.keys) {
            EObject obj;
            if (key.getTags().contains("type:user") || !((obj = ((EObject)key).eContainer()) instanceof MBindingTable)) continue;
            MBindingTable table = (MBindingTable)obj;
            table.getBindings().remove(key);
        }
    }

    public MBindingContext getBindingContext(MApplication application, String id) {
        MBindingContext result = this.contexts.get(id);
        if (result == null) {
            result = this.searchContexts(id, application.getRootContext());
            if (result == null) {
                result = MCommandsFactory.INSTANCE.createBindingContext();
                result.setElementId(id);
                result.setName("Auto::" + id);
                application.getRootContext().add(result);
            }
            if (result != null) {
                this.contexts.put(id, result);
            }
        }
        return result;
    }

    private MBindingContext searchContexts(String id, List<MBindingContext> rootContext) {
        for (MBindingContext context : rootContext) {
            if (context.getElementId().equals(id)) {
                return context;
            }
            MBindingContext result = this.searchContexts(id, context.getChildren());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private MBindingTable createTable(MApplication application, String contextId) {
        MBindingTable table = CommandsFactoryImpl.eINSTANCE.createBindingTable();
        table.setBindingContext(this.getBindingContext(application, contextId));
        table.setElementId(contextId);
        application.getBindingTables().add(table);
        this.tables.put(table.getBindingContext().getElementId(), table);
        return table;
    }

    private void gatherCommands(List<MCommand> commandList) {
        for (MCommand cmd : commandList) {
            this.commands.put(cmd.getElementId(), cmd);
        }
    }

    private void gatherContexts(List<MBindingContext> contextList) {
        for (MBindingContext ctx : contextList) {
            this.gatherContexts(ctx);
        }
    }

    private void gatherContexts(MBindingContext ctx) {
        if (ctx == null) {
            return;
        }
        this.contexts.put(ctx.getElementId(), ctx);
        this.gatherContexts(ctx.getChildren());
    }
}

