/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.equinox.internal.p2.touchpoint.natives.ClosedBackupStoreException;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.osgi.util.NLS;

public class SimpleBackupStore
implements IBackupStore {
    public static final String BACKUP_FILE_EXTENSION = "p2bu";
    public static final String DIR_PLACEHOLDER = "emptydir";
    private static final String ROOTCHAR = "_";
    private final Path buStoreRoot;
    private String buInPlaceSuffix;
    private List<Path> buInPlace;
    private long backupCounter;
    private long restoreCounter;
    private boolean closed;

    public SimpleBackupStore() {
        this(null, ".p2bu");
    }

    public SimpleBackupStore(File buStoreParent, String prefix) {
        String unique = UUID.randomUUID().toString();
        String buStoreName = String.valueOf(prefix) + ROOTCHAR + unique;
        this.buStoreRoot = buStoreParent != null ? buStoreParent.toPath().resolve(buStoreName) : Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve(buStoreName);
        this.buInPlaceSuffix = String.format("-%s.%s", unique, BACKUP_FILE_EXTENSION);
        this.buInPlace = new ArrayList<Path>();
    }

    @Override
    public String getBackupName() {
        return this.buStoreRoot.getFileName().toString();
    }

    public File getBackupRoot() {
        return this.buStoreRoot.toFile();
    }

    @Override
    public boolean backup(File file) throws IOException {
        this.assertOpen();
        Path path = file.toPath();
        if (Files.isDirectory(path, new LinkOption[0])) {
            return this.backupDirectory(path.toFile());
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IOException(NLS.bind((String)Messages.BackupStore_file_not_found, (Object)path.toAbsolutePath()));
        }
        Path buPath = this.toBackupPath(path);
        if (Files.isDirectory(buPath, new LinkOption[0])) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_directory_file_mismatch, (Object)buPath.toAbsolutePath()));
        }
        return this.moveToBackup(path, buPath);
    }

    @Override
    public boolean backupDirectory(File file) throws IOException {
        this.assertOpen();
        Path path = file.toPath();
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_not_a_directory, (Object)file.getAbsolutePath()));
        }
        if (Files.list(path).count() > 0L) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_directory_not_empty, (Object)file.getAbsolutePath()));
        }
        return this.moveDirToBackup(path);
    }

    @Override
    public void backupAll(File file) throws IOException {
        this.assertOpen();
        Path path = file.toPath().normalize();
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path f, BasicFileAttributes attrs) throws IOException {
                SimpleBackupStore.this.backup(f.toFile());
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    throw exc;
                }
                SimpleBackupStore.this.moveDirToBackup(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Override
    public boolean backupCopy(File file) throws IOException {
        this.assertOpen();
        Path path = file.toPath();
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IOException(NLS.bind((String)Messages.BackupStore_file_not_found, (Object)file.getAbsolutePath()));
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_can_not_copy_directory, (Object)file.getAbsolutePath()));
        }
        Path buPath = this.toBackupPath(path);
        if (Files.isDirectory(buPath, new LinkOption[0])) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_directory_file_mismatch, (Object)buPath.toAbsolutePath()));
        }
        if (Files.exists(buPath, new LinkOption[0])) {
            return false;
        }
        Files.createDirectories(buPath.getParent(), new FileAttribute[0]);
        Files.copy(path, buPath, StandardCopyOption.REPLACE_EXISTING);
        ++this.backupCounter;
        return true;
    }

    @Override
    public void backupCopyAll(File file) throws IOException {
        this.assertOpen();
        Path path = file.toPath();
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        path = path.normalize();
        if (Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS)) {
            this.backupCopy(file);
        } else if (Files.isDirectory(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path f, BasicFileAttributes attrs) throws IOException {
                    SimpleBackupStore.this.backupCopy(f.toFile());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc != null) {
                        throw exc;
                    }
                    SimpleBackupStore.this.copyDirToBackup(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    @Override
    public void restore() throws IOException {
        this.assertOpen();
        this.closed = true;
        HashMap<Path, Throwable> unrestorable = new HashMap<Path, Throwable>();
        this.restoreBackups(unrestorable);
        this.restoreInPlaceBackups(unrestorable);
        boolean restored = true;
        if (!unrestorable.isEmpty()) {
            restored = false;
            unrestorable.forEach((p, err) -> Util.logError(NLS.bind((String)Messages.BackupStore_manual_restore_needed, (Object)err, (Object)p.toAbsolutePath())));
        }
        if (this.backupCounter != this.restoreCounter) {
            restored = false;
            if (!unrestorable.isEmpty()) {
                Util.logError(NLS.bind((String)Messages.BackupStore_0_of_1_items_restored, (Object)this.restoreCounter, (Object)this.backupCounter));
            } else {
                Util.logError(NLS.bind((String)Messages.BackupStore_externally_modified_0_of_1_restored, (Object)this.restoreCounter, (Object)this.backupCounter));
            }
        }
        if (!restored) {
            throw new IOException(Messages.BackupStore_errors_while_restoring_see_log);
        }
    }

    @Override
    public void discard() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            SimpleBackupStore.deleteAll(this.buStoreRoot);
        }
        catch (IOException iOException) {
            Util.logWarning(NLS.bind((String)Messages.BackupStore_can_not_remove_bu_directory, (Object)this.buStoreRoot.toAbsolutePath()));
        }
        for (Path buFile : this.buInPlace) {
            try {
                SimpleBackupStore.deleteAll(buFile);
            }
            catch (IOException iOException) {
                Util.logWarning(NLS.bind((String)Messages.BackupStore_can_not_remove_bu_file, (Object)buFile.toAbsolutePath()));
            }
        }
    }

    private void assertOpen() {
        if (this.closed) {
            throw new ClosedBackupStoreException(Messages.BackupStore_closed_store);
        }
    }

    private boolean copyDirToBackup(Path path) throws IOException {
        Path buPath = this.toBackupPath(path);
        if (Files.exists(buPath, new LinkOption[0])) {
            return false;
        }
        Path placeholderPath = path.resolve(DIR_PLACEHOLDER);
        try {
            Files.createFile(placeholderPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IOException(NLS.bind((String)Messages.BackupStore_can_not_create_placeholder, (Object)placeholderPath.toAbsolutePath()), e);
        }
        Path buPlaceholderPath = buPath.resolve(DIR_PLACEHOLDER);
        this.moveToBackup(placeholderPath, buPlaceholderPath);
        return true;
    }

    private boolean moveDirToBackup(Path dir) throws IOException {
        boolean copied = this.copyDirToBackup(dir);
        try {
            Files.delete(dir);
        }
        catch (IOException iOException) {
            throw new IOException(NLS.bind((String)Messages.BackupStore_can_not_remove, (Object)dir.toAbsolutePath()));
        }
        return copied;
    }

    private boolean moveToBackup(Path path, Path buPath) throws IOException {
        if (Files.exists(buPath, new LinkOption[0])) {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                throw new IOException(NLS.bind((String)Messages.BackupStore_can_not_remove, (Object)path.toAbsolutePath()), e);
            }
            return false;
        }
        Path buPathDir = buPath.getParent();
        try {
            Files.createDirectories(buPathDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_file_directory_mismatch, (Object)buPathDir.toAbsolutePath()), e);
        }
        try {
            this.move(path, buPath);
        }
        catch (IOException e) {
            if (!SimpleBackupStore.isEclipseExe(path)) {
                throw e;
            }
            Path inPlaceBuPath = this.toInPlaceBackupPath(path);
            this.move(path, inPlaceBuPath);
            this.buInPlace.add(inPlaceBuPath);
        }
        ++this.backupCounter;
        return true;
    }

    private void restoreBackups(final Map<Path, Throwable> unrestorable) throws IOException {
        if (!Files.exists(this.buStoreRoot, new LinkOption[0])) {
            unrestorable.put(this.buStoreRoot, new IOException(NLS.bind((String)Messages.BackupStore_missing_backup_directory, (Object)this.buStoreRoot.toAbsolutePath())));
            return;
        }
        Files.walkFileTree(this.buStoreRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path buDir, BasicFileAttributes attrs) {
                try {
                    if (Files.isSameFile(SimpleBackupStore.this.buStoreRoot, buDir)) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path dir = SimpleBackupStore.this.toSourcePath(buDir);
                    if (Files.isRegularFile(dir, new LinkOption[0])) {
                        Files.delete(dir);
                    }
                    Files.createDirectories(dir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    unrestorable.put(buDir, e);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path buFile, BasicFileAttributes attrs) {
                Path file = SimpleBackupStore.this.toSourcePath(buFile);
                try {
                    if (Files.isSameFile(buFile.getParent(), SimpleBackupStore.this.buStoreRoot)) {
                        unrestorable.put(buFile, new IOException("Not a directory"));
                    } else {
                        if (!SimpleBackupStore.DIR_PLACEHOLDER.equals(buFile.getFileName().toString())) {
                            SimpleBackupStore.deleteAll(file);
                            SimpleBackupStore.this.move(buFile, file);
                        } else {
                            Files.delete(buFile);
                        }
                        ++SimpleBackupStore.this.restoreCounter;
                    }
                }
                catch (IOException e) {
                    unrestorable.put(buFile, e);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                unrestorable.put(file, exc);
                throw exc;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path buDir, IOException exc) throws IOException {
                if (exc != null) {
                    unrestorable.put(buDir, exc);
                    throw exc;
                }
                try {
                    Files.delete(buDir);
                }
                catch (DirectoryNotEmptyException e) {
                    String children = Files.list(buDir).map(p -> p.relativize(buDir)).map(Path::toString).collect(Collectors.joining(","));
                    unrestorable.put(buDir, new IOException(String.format("Directory %s not empty: %s", buDir, children, e)));
                }
                catch (IOException e) {
                    unrestorable.put(buDir, e);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void restoreInPlaceBackups(Map<Path, Throwable> unrestorable) {
        for (Path buPath : this.buInPlace) {
            Path path = this.toInPlaceSourcePath(buPath);
            try {
                this.move(buPath, path);
                ++this.restoreCounter;
            }
            catch (IOException e) {
                unrestorable.put(buPath, e);
            }
        }
    }

    protected Path toBackupPath(Path path) throws IOException {
        Path pathNormal = path.normalize();
        String buPath = pathNormal.toAbsolutePath().toString();
        String buPrefix = "";
        while (buPath.startsWith(File.separator)) {
            buPrefix = String.valueOf(buPrefix) + ROOTCHAR;
            buPath = buPath.substring(1);
        }
        if (!buPrefix.isEmpty()) {
            buPath = Paths.get(buPrefix, buPath).toString();
        } else {
            int idx = buPath.indexOf(":");
            if (idx < 1) {
                throw new IllegalArgumentException("File is neither absolute nor has a drive name: " + buPath);
            }
            buPath = String.valueOf(buPath.substring(0, idx)) + buPath.substring(idx + 1);
        }
        Path buFile = this.buStoreRoot.resolve(buPath);
        return buFile;
    }

    protected Path toSourcePath(Path buPath) {
        Path buPathRel = this.buStoreRoot.relativize(buPath);
        String pathName = buPathRel.toString();
        String prefix = "";
        while (pathName.startsWith(ROOTCHAR)) {
            prefix = String.valueOf(prefix) + File.separator;
            pathName = pathName.substring(1);
        }
        pathName = prefix.isEmpty() ? String.valueOf(pathName.charAt(0)) + ":" + pathName.substring(1) : String.valueOf(prefix) + pathName;
        return Paths.get(pathName, new String[0]);
    }

    protected Path toInPlaceBackupPath(Path path) {
        String buPathName = path.getFileName() + this.buInPlaceSuffix;
        Path buPath = path.toAbsolutePath().resolveSibling(buPathName);
        return buPath;
    }

    protected Path toInPlaceSourcePath(Path buPath) {
        String buPathName = buPath.getFileName().toString();
        int suffixIdx = buPathName.indexOf(this.buInPlaceSuffix);
        if (suffixIdx <= 0) {
            throw new IllegalArgumentException();
        }
        String pathName = buPathName.substring(0, suffixIdx);
        Path path = buPath.resolveSibling(pathName);
        return path;
    }

    protected void move(Path source, Path target) throws IOException {
        Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
    }

    private static boolean isEclipseExe(Path file) {
        String launcherName;
        String name = file.getFileName().toString();
        String launcher = System.getProperty("eclipse.launcher");
        if (launcher != null && name.equalsIgnoreCase(launcherName = Paths.get(launcher, new String[0]).getFileName().toString())) {
            return true;
        }
        return name.equalsIgnoreCase("eclipse.exe") || name.equalsIgnoreCase("eclipsec.exe");
    }

    private static void deleteAll(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    throw exc;
                }
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

