/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.setup.p2.util.MarketPlaceListing;
import org.eclipse.oomph.setup.ui.AbstractSetupDialog;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.wizards.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionsDialog
extends AbstractSetupDialog {
    public static final String TITLE = Messages.ExtensionsDialog_title;
    public static final String HEADER = Messages.ExtensionsDialog_header;
    public static final String DESCRIPTION = Messages.ExtensionsDialog_description;
    private CheckboxTableViewer extensionViewer;
    private final Collection<? extends Resource> extensions;
    private final Collection<Resource> result = new LinkedHashSet<Resource>();

    public ExtensionsDialog(Shell parentShell, Collection<? extends Resource> extensions) {
        super(parentShell, HEADER, 800, 300, SetupUIPlugin.INSTANCE, false);
        this.extensions = extensions;
    }

    public Collection<? extends Resource> getResult() {
        return this.result;
    }

    protected String getShellText() {
        return TITLE;
    }

    protected String getDefaultMessage() {
        return String.valueOf(DESCRIPTION) + ".";
    }

    protected void createUI(Composite parent) {
        this.extensionViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)0);
        Table registrationTable = this.extensionViewer.getTable();
        registrationTable.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.extensionViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ExtensionsDialog.this.extensions.toArray();
            }
        });
        this.extensionViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                URI uri = ((Resource)element).getURI();
                if (MarketPlaceListing.isMarketPlaceListing((URI)uri)) {
                    return SetupUIPlugin.INSTANCE.getSWTImage("marketplace16.png");
                }
                return SetupUIPlugin.INSTANCE.getSWTImage("full/obj16/Configuration");
            }

            public String getText(Object element) {
                return ((Resource)element).getURI().toString();
            }
        });
        this.extensionViewer.setInput(this.extensions);
        this.extensionViewer.setCheckedElements(this.extensions.toArray());
        this.extensionViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExtensionsDialog.this.updateEnablement();
            }
        });
    }

    protected Map<String, String> getCurrentSelfRegistrations() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        return result;
    }

    protected void updateEnablement() {
        boolean catalogSelectionChanged;
        HashSet<Object> checkedElements = new HashSet<Object>(Arrays.asList(this.extensionViewer.getCheckedElements()));
        boolean applyEnabled = catalogSelectionChanged = !checkedElements.equals(new HashSet<Resource>(this.extensions));
        this.getButton(0).setEnabled(applyEnabled);
        this.extensionViewer.refresh();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1024, Messages.ExtensionsDialog_selectAllButton_text, true);
        this.createButton(parent, 1025, Messages.ExtensionsDialog_deselectAllButton_text, true);
        super.createButtonsForButtonBar(parent);
        this.updateEnablement();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1024) {
            this.extensionViewer.setCheckedElements(((Collection)this.extensionViewer.getInput()).toArray());
            this.updateEnablement();
        } else if (buttonId == 1025) {
            this.extensionViewer.setCheckedElements(new Object[0]);
            this.updateEnablement();
        } else if (buttonId == 0) {
            HashSet<Object> checkedElements = new HashSet<Object>(Arrays.asList(this.extensionViewer.getCheckedElements()));
            this.result.addAll(this.extensions);
            this.result.retainAll(checkedElements);
        }
        super.buttonPressed(buttonId);
    }
}

