/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import java.util.Collection;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.oomph.internal.ui.OomphTransferDelegate;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;

public class OomphDragAdapter
implements DragSourceListener {
    protected EditingDomain domain;
    protected ISelectionProvider selectionProvider;
    protected Collection<? extends OomphTransferDelegate> delegates;

    public OomphDragAdapter(EditingDomain domain, ISelectionProvider selectionProvider, Collection<? extends OomphTransferDelegate> delegates) {
        this.domain = domain;
        this.selectionProvider = selectionProvider;
        this.delegates = delegates;
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.selectionProvider.getSelection();
        event.doit = false;
        for (OomphTransferDelegate oomphTransferDelegate : this.delegates) {
            if (!oomphTransferDelegate.setSelection(this.domain, selection)) continue;
            event.doit = true;
        }
    }

    public void dragSetData(DragSourceEvent event) {
        for (OomphTransferDelegate oomphTransferDelegate : this.delegates) {
            if (!oomphTransferDelegate.isSupportedType(event.dataType)) continue;
            event.data = oomphTransferDelegate.getData();
            if (event.data != null) break;
            event.doit = false;
            break;
        }
    }

    public void dragFinished(DragSourceEvent event) {
        for (OomphTransferDelegate oomphTransferDelegate : this.delegates) {
            oomphTransferDelegate.clear();
        }
    }
}

