/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.net.auth;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.net.NetUIMessages;
import org.eclipse.ui.internal.net.auth.Authentication;

public class UserValidationDialog
extends Dialog {
    protected Text usernameField;
    protected Text passwordField;
    protected String host;
    protected String message;
    protected Authentication userAuthentication = null;

    public static Authentication getAuthentication(String host, String message) {
        class UIOperation
        implements Runnable {
            public Authentication authentication;
            private final /* synthetic */ String val$host;
            private final /* synthetic */ String val$message;

            UIOperation(String string, String string2) {
                this.val$host = string;
                this.val$message = string2;
            }

            @Override
            public void run() {
                this.authentication = UserValidationDialog.askForAuthentication(this.val$host, this.val$message);
            }
        }
        UIOperation uio = new UIOperation(host, message);
        if (Display.getCurrent() != null) {
            uio.run();
        } else {
            Display.getDefault().syncExec((Runnable)uio);
        }
        return uio.authentication;
    }

    protected static Authentication askForAuthentication(String host, String message) {
        UserValidationDialog ui = new UserValidationDialog(null, host, message);
        ui.open();
        return ui.getAuthentication();
    }

    protected UserValidationDialog(Shell parentShell, String host, String message) {
        super(parentShell);
        this.host = host;
        this.message = message;
        this.setBlockOnOpen(true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NetUIMessages.UserValidationDialog_0);
    }

    public void create() {
        super.create();
        this.usernameField.selectAll();
        this.usernameField.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        Label label = new Label(main, 64);
        Object text = NLS.bind((String)NetUIMessages.UserValidationDialog_1, (Object)this.host);
        text = (String)text + "\n\n" + this.message;
        label.setText((String)text);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        this.createUsernameFields(main);
        this.createPasswordFields(main);
        PlatformUI.setHelp((Composite)main, (String)"org.eclipse.update.ui.UserValidationDialog");
        return main;
    }

    protected void createPasswordFields(Composite parent) {
        new Label(parent, 0).setText(NetUIMessages.UserValidationDialog_2);
        this.passwordField = new Text(parent, 0x400800);
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.passwordField.setLayoutData((Object)data);
        new Label(parent, 0);
    }

    protected void createUsernameFields(Composite parent) {
        new Label(parent, 0).setText(NetUIMessages.UserValidationDialog_3);
        this.usernameField = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.usernameField.setLayoutData((Object)data);
        new Label(parent, 0);
    }

    public Authentication getAuthentication() {
        return this.userAuthentication;
    }

    protected void okPressed() {
        this.userAuthentication = new Authentication(this.usernameField.getText(), this.passwordField.getText());
        super.okPressed();
    }
}

