/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.osgi.util.NLS;

public class NLSReport {
    private static final List<String> REPORT_HEAD = Arrays.asList("<html>", "<head>", "<meta charset='utf-8'/>", "<title>NLS Report</title>", "<style>", "table, th, td {", "  border: 1px solid black;", "  border-collapse: collapse;", "  white-space: pre;", "}", "th, td {", "  text-align: left;", "}", "</style>", "</head>", "<body>", "<table>", "<tr>", "<th>", "Property", "</th>", "<th>", "Value", "</th>", "</tr>");
    private static final List<String> REPORT_TAIL = Arrays.asList("<table>", "</body>", "</html>");
    private final File oomphGitClone;
    private PrintStream out;
    private static final List<String> SUBSTITUTIONS = Arrays.asList("{0}", "{1}", "{2}", "{3}", "{4}");
    private static final Pattern SUBSITUTION = Pattern.compile(" (?<!\\\\)\\{([0-9]+)\\}|^\\{([0-9]+)\\}");
    private File reportFile;

    public NLSReport(File oomphGitClone) {
        this.oomphGitClone = oomphGitClone;
    }

    public File report() {
        URI relativeURI;
        URI fileURI;
        this.openReport();
        File pluginsFolder = new File(this.oomphGitClone, "plugins");
        URI pluginsURI = URI.createFileURI((String)pluginsFolder.toString()).appendSegment("");
        List allFiles = IOUtil.listBreadthFirst((File)pluginsFolder);
        Collections.sort(allFiles);
        for (File file : allFiles) {
            Map properties;
            fileURI = URI.createFileURI((String)file.toString());
            relativeURI = fileURI.deresolve(pluginsURI);
            String pluginID = relativeURI.segment(0);
            String name = relativeURI.lastSegment();
            if (name.equals("Messages.java")) {
                String className = relativeURI.toString().replaceAll("^.*src/", "").replaceAll("\\.java", "").replace('/', '.');
                URI messagesURI = relativeURI.trimSegments(1).appendSegment("messages.properties");
                this.reportMessages(pluginID, className, messagesURI);
                continue;
            }
            if (name.equals("MANIFEST.MF") && relativeURI.segmentCount() == 3 && "META-INF".equals(relativeURI.segment(1))) {
                properties = PropertiesUtil.loadProperties((File)file);
                String bundleActivator = (String)properties.get("Bundle-Activator");
                String bundleLocalization = (String)properties.get("Bundle-Localization");
                if (bundleLocalization == null) continue;
                File localizationFile = new File(pluginsFolder, pluginID + "/" + bundleLocalization + ".properties");
                URI localizationFileURI = URI.createFileURI((String)localizationFile.toString()).deresolve(pluginsURI);
                Map localizationProperties = PropertiesUtil.loadProperties((File)localizationFile);
                this.reportActivator(pluginID, bundleActivator, localizationFileURI, localizationProperties);
                continue;
            }
            if (!name.equals("fragment.properties")) continue;
            properties = PropertiesUtil.loadProperties((File)file);
            this.report(relativeURI, properties);
        }
        File featuresFolder = new File(this.oomphGitClone, "features");
        URI featuresURI = URI.createFileURI((String)featuresFolder.toString()).appendSegment("");
        allFiles = IOUtil.listBreadthFirst((File)featuresFolder);
        Collections.sort(allFiles);
        for (File file : allFiles) {
            fileURI = URI.createFileURI((String)file.toString());
            relativeURI = fileURI.deresolve(featuresURI);
            String name = relativeURI.lastSegment();
            if (!name.equals("feature.properties") || relativeURI.segmentCount() != 2) continue;
            Map properties = PropertiesUtil.loadProperties((File)file);
            this.report(relativeURI, properties);
        }
        this.closeReport();
        return this.reportFile;
    }

    private void openReport() {
        try {
            this.reportFile = File.createTempFile("NLSReport", ".html");
            this.out = new PrintStream(this.reportFile, "UTF-8");
            for (String line : REPORT_HEAD) {
                this.out.println(line);
            }
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    private void closeReport() {
        for (String line : REPORT_TAIL) {
            this.out.println(line);
        }
        this.out.close();
    }

    private void reportActivator(String pluginID, String bundleActivatorName, URI localizationFileURI, Map<String, String> localizationProperties) {
        for (Map.Entry<String, String> entry : localizationProperties.entrySet()) {
            String bound2;
            Object[] substitutions;
            String bound1;
            String value = entry.getValue();
            int subsitutionCount = NLSReport.getSubsitutionCount(value);
            if (subsitutionCount <= 0 || (bound1 = NLS.bind((String)value, (Object[])(substitutions = SUBSTITUTIONS.subList(0, subsitutionCount).toArray()))).equals(bound2 = NLS.bind((String)value, (Object[])substitutions)) && bound1.equals(value)) continue;
            throw new RuntimeException();
        }
        if (bundleActivatorName != null) {
            try {
                Class bundleActivatorClass = CommonPlugin.loadClass((String)pluginID, (String)bundleActivatorName);
                if (ResourceLocator.class.isAssignableFrom(bundleActivatorClass)) {
                    String containerClassName = bundleActivatorName.substring(0, bundleActivatorName.indexOf(36));
                    Class containerClass = CommonPlugin.loadClass((String)pluginID, (String)containerClassName);
                    ResourceLocator plugin = (ResourceLocator)ReflectUtil.getValue((String)"plugin", (Object)containerClass);
                    for (Map.Entry<String, String> entry : localizationProperties.entrySet()) {
                        String bound2;
                        Object[] substitutions;
                        String bound1;
                        String value = plugin.getString(entry.getKey());
                        if (!value.equals(entry.getValue())) {
                            throw new RuntimeException();
                        }
                        int subsitutionCount = NLSReport.getSubsitutionCount(value);
                        if (subsitutionCount <= 0 || (bound1 = NLS.bind((String)value, (Object[])(substitutions = SUBSTITUTIONS.subList(0, subsitutionCount).toArray()))).equals(bound2 = plugin.getString(entry.getKey(), substitutions)) && bound1.equals(value)) continue;
                        throw new RuntimeException();
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.report(localizationFileURI, localizationProperties);
    }

    private void report(URI localizationFileURI, Map<String, String> localizationProperties) {
        this.out.println("<tr>");
        this.out.print("<td colspan='2' style='font-weight: bold;'>");
        this.out.print(DiagnosticDecorator.escapeContent((String)localizationFileURI.toString()));
        this.out.println("</td>");
        this.out.println("</tr>");
        for (Map.Entry<String, String> entry : localizationProperties.entrySet()) {
            this.out.println("<tr>");
            this.out.print("<td>");
            this.out.print(entry.getKey());
            this.out.println("</td>");
            this.out.print("<td>");
            this.out.print(DiagnosticDecorator.escapeContent((String)entry.getValue()));
            this.out.println("</td>");
            this.out.println("</tr>");
        }
    }

    private static int getSubsitutionCount(String message) {
        int count = 0;
        Matcher matcher = SUBSITUTION.matcher(message);
        while (matcher.find()) {
            int value;
            String index = matcher.group(1);
            if (index == null) {
                index = matcher.group(2);
            }
            if ((value = Integer.parseInt(index)) <= count) continue;
            value = count;
        }
        return count;
    }

    private void reportMessages(String pluginID, String messagesClassName, URI messagesURI) {
        try {
            Class messagesClass = CommonPlugin.loadClass((String)pluginID, (String)messagesClassName);
            Field[] fields = messagesClass.getFields();
            LinkedHashMap<String, String> messages = new LinkedHashMap<String, String>();
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                Object value = field.get(null);
                messages.put(field.getName(), value.toString());
                ++n2;
            }
            this.report(messagesURI, messages);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

