/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.ui.ImageURIRegistry;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.internal.ui.OomphTransferDelegate;
import org.eclipse.oomph.jreinfo.JRE;
import org.eclipse.oomph.jreinfo.JREManager;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.internal.core.CacheUsageConfirmer;
import org.eclipse.oomph.p2.internal.ui.CacheUsageConfirmerUI;
import org.eclipse.oomph.setup.Configuration;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.Macro;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.IndexManager;
import org.eclipse.oomph.setup.internal.core.util.ResourceMirror;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.p2.P2Task;
import org.eclipse.oomph.setup.p2.util.MarketPlaceListing;
import org.eclipse.oomph.setup.p2.util.P2TaskUISevices;
import org.eclipse.oomph.setup.ui.P2TaskUIServicesPrompter;
import org.eclipse.oomph.setup.ui.SetupPropertyTester;
import org.eclipse.oomph.setup.ui.SetupTransferSupport;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.wizards.ConfirmationPage;
import org.eclipse.oomph.setup.ui.wizards.Messages;
import org.eclipse.oomph.setup.ui.wizards.ProgressPage;
import org.eclipse.oomph.setup.ui.wizards.ProjectPage;
import org.eclipse.oomph.setup.ui.wizards.SetupWizardDialog;
import org.eclipse.oomph.setup.ui.wizards.SetupWizardPage;
import org.eclipse.oomph.setup.ui.wizards.VariablePage;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardDescriptor;

public abstract class SetupWizard
extends Wizard
implements IPageChangedListener {
    public static final String HELP_FOLDER = "/org.eclipse.oomph.setup.doc/html/user/wizard/";
    static boolean ecfWorkAround;
    private Trigger trigger;
    private String triggerName;
    private Object lastPage;
    private ResourceSet resourceSet;
    private CatalogManager catalogManager;
    private SetupTransferSupport setupTransferSupport;
    private Configuration configuration;
    private final List<Resource> configurationResources = new ArrayList<Resource>();
    private final List<Resource> appliedConfigurationResources = new UniqueEList();
    private SetupContext setupContext;
    private SetupTaskPerformer performer;
    private String vmPath;
    private OS os;
    private IndexLoader indexLoader;
    private Runnable indexLoadedAction;
    private Runnable finishAction;
    private ComposedAdapterFactory adapterFactory;
    private boolean isCanceled;
    private Shell simpleShell;

    public SetupWizard() {
        this((SetupTaskPerformer)null);
    }

    public SetupWizard(SetupTaskPerformer performer) {
        this.initUI();
        if (performer == null) {
            this.resourceSet = SetupCoreUtil.createResourceSet();
            this.setTrigger(Trigger.STARTUP);
            if (SetupContext.WORKSPACE_LOCATION_URI != null) {
                this.setSetupContext(SetupContext.create((ResourceSet)this.resourceSet));
            }
        } else {
            this.setPerformer(performer);
            this.setTrigger(performer.getTrigger());
            this.setSetupContext(performer.getSetupContext());
            this.resourceSet = performer.getUser().eResource().getResourceSet();
        }
    }

    public SetupWizard(SetupContext setupContext) {
        this.initUI();
        this.setTrigger(Trigger.STARTUP);
        this.setSetupContext(setupContext);
        this.resourceSet = setupContext.getUser().eResource().getResourceSet();
    }

    private void initUI() {
        this.setDefaultPageImageDescriptor(SetupUIPlugin.INSTANCE.getImageDescriptor("install_wiz.png"));
        this.setNeedsProgressMonitor(false);
    }

    public abstract String getHelpPath();

    public ComposedAdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            this.adapterFactory = BaseEditUtil.createAdapterFactory();
        }
        return this.adapterFactory;
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public String getTriggerName() {
        if (this.triggerName != null) {
            return this.triggerName;
        }
        if (this.trigger != null) {
            return this.trigger.toString();
        }
        return "ALL";
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName == null ? null : triggerName.toUpperCase();
    }

    public IndexLoader getIndexLoader() {
        return this.indexLoader;
    }

    public void setIndexLoader(IndexLoader indexLoader) {
        this.indexLoader = indexLoader;
        if (indexLoader != null) {
            indexLoader.setWizard(this);
        }
    }

    public void setIndexLoadedAction(Runnable indexLoadedAction) {
        this.indexLoadedAction = indexLoadedAction;
    }

    public void setFinishAction(Runnable finishAction) {
        this.finishAction = finishAction;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public SetupTransferSupport getTransferSupport() {
        if (this.setupTransferSupport == null) {
            this.setupTransferSupport = new SetupTransferSupport();
        }
        return this.setupTransferSupport;
    }

    public Collection<? extends Resource> getConfigurationResources() {
        return new ArrayList<Resource>(this.configurationResources);
    }

    public Collection<? extends Resource> getUnappliedConfigurationResources() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        block0: for (Resource configurationResource : this.configurationResources) {
            URI uri = configurationResource.getURI();
            for (Resource appliedConfigurationResource : this.appliedConfigurationResources) {
                if (uri.equals(appliedConfigurationResource.getURI())) continue block0;
            }
            result.add(configurationResource);
        }
        return result;
    }

    public void setConfigurationResources(Collection<? extends Resource> configurationResources) {
        if (!this.configurationResources.equals(new ArrayList<Resource>(configurationResources))) {
            this.configuration = null;
            this.configurationResources.clear();
            this.configurationResources.addAll(configurationResources);
        }
    }

    public Collection<? extends Resource> getAppliedConfigurationResources() {
        return new ArrayList<Resource>(this.appliedConfigurationResources);
    }

    public void addAppliedConfigurationResource(Resource configurationResource) {
        URI uri = configurationResource.getURI();
        for (Resource resource : this.appliedConfigurationResources) {
            if (!uri.equals(resource.getURI())) continue;
            return;
        }
        if (MarketPlaceListing.isMarketPlaceListing((URI)configurationResource.getURI())) {
            this.appliedConfigurationResources.add(0, configurationResource);
        } else {
            this.appliedConfigurationResources.add(configurationResource);
        }
    }

    public void addConfigurationListener(ProjectPage.ConfigurationListener configurationListener) {
    }

    public void removeAppliedConfigurationResource(Resource configurationResource) {
        this.appliedConfigurationResources.remove(configurationResource);
    }

    public Configuration getConfiguration() {
        if (this.configuration == null) {
            ResourceSet resourceSet = this.getResourceSet();
            for (Resource resource : this.configurationResources) {
                OomphTransferDelegate.TextTransferDelegate delegate;
                String xml;
                Configuration configuration;
                if (!resource.isLoaded()) {
                    URI uri = resource.getURI();
                    if ("zip".equals(uri.fileExtension())) {
                        this.configuration = SetupFactory.eINSTANCE.createConfiguration();
                        this.reloadIndex(URI.createURI((String)("archive:" + String.valueOf(uri) + "!/")));
                        return this.configuration;
                    }
                    if ("org.eclipse.setup".equals(uri.lastSegment())) {
                        this.configuration = SetupFactory.eINSTANCE.createConfiguration();
                        this.reloadIndex(uri);
                        return this.configuration;
                    }
                    Resource localResource = resourceSet.getResource(uri, false);
                    if (localResource != null) {
                        resourceSet.getResources().remove((Object)localResource);
                    }
                    resourceSet.getResources().add((Object)resource);
                    try {
                        resourceSet.getResource(uri, true);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    Configuration configuration2 = (Configuration)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SetupPackage.Literals.CONFIGURATION);
                    if (configuration2 != null) {
                        this.configuration = configuration2;
                        break;
                    }
                }
                if ((configuration = (Configuration)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SetupPackage.Literals.CONFIGURATION)) == null || (xml = (String)(delegate = new OomphTransferDelegate.TextTransferDelegate(configuration){
                    {
                        this.eObjects = Collections.singleton(configuration);
                    }
                }).getData()) == null) continue;
                final URI uri = resource.getURI();
                Resource localResource = resourceSet.getResource(uri, false);
                if (localResource != null) {
                    resourceSet.getResources().remove((Object)localResource);
                }
                localResource = resourceSet.createResource(uri);
                try {
                    localResource.load((InputStream)new URIConverter.ReadableInputStream(xml), resourceSet.getLoadOptions());
                    Configuration localConfiguration = (Configuration)EcoreUtil.getObjectByType((Collection)localResource.getContents(), (EClassifier)SetupPackage.Literals.CONFIGURATION);
                    ResourceMirror.WithProductImages resourceMirror = new ResourceMirror.WithProductImages(resourceSet){

                        protected void run(String taskName, IProgressMonitor monitor) {
                            this.perform(uri);
                            this.resolveProxies();
                        }

                        protected boolean await(long timeout) throws InterruptedException {
                            Display display = SetupWizard.this.getShell().getDisplay();
                            while (!super.await(500L)) {
                                if (display.isDisposed()) break;
                                while (display.readAndDispatch()) {
                                }
                            }
                            return true;
                        }
                    };
                    resourceMirror.begin((IProgressMonitor)new NullProgressMonitor());
                    if (localConfiguration == null) continue;
                    this.configuration = localConfiguration;
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.configuration;
    }

    public CatalogManager getCatalogManager() {
        if (this.catalogManager == null) {
            this.catalogManager = new CatalogManager();
        }
        return this.catalogManager;
    }

    public SetupContext getSetupContext() {
        return this.setupContext;
    }

    public void setSetupContext(SetupContext setupContext) {
        this.setupContext = setupContext;
    }

    public Installation getInstallation() {
        return this.setupContext == null ? null : this.setupContext.getInstallation();
    }

    public Workspace getWorkspace() {
        return this.setupContext == null ? null : this.setupContext.getWorkspace();
    }

    public User getUser() {
        return this.setupContext == null ? null : this.setupContext.getUser();
    }

    public SetupTaskPerformer getPerformer() {
        return this.performer;
    }

    public void setPerformer(SetupTaskPerformer performer) {
        this.performer = performer;
        if (performer != null) {
            performer.put(CacheUsageConfirmer.class, (Object)new CacheUsageConfirmerUI());
            performer.put(P2TaskUISevices.class, (Object)new P2TaskUIServicesPrompter());
        }
    }

    public String getVMPath() {
        return this.getOS().isCurrentOS() ? this.vmPath : null;
    }

    public void setVMPath(String vmPath) {
        this.vmPath = vmPath;
    }

    public OS getOS() {
        return this.os == null ? OS.INSTANCE : this.os;
    }

    public void setOS(OS os) {
        this.os = os;
        this.updateJREs(this.getCatalogManager().getIndex());
    }

    public void setContainer(IWizardContainer newContainer) {
        IWizardContainer oldContainer = this.getContainer();
        if (oldContainer instanceof IPageChangeProvider) {
            ((IPageChangeProvider)oldContainer).removePageChangedListener((IPageChangedListener)this);
        }
        super.setContainer(newContainer);
        if (newContainer instanceof IPageChangeProvider) {
            ((IPageChangeProvider)newContainer).addPageChangedListener((IPageChangedListener)this);
        }
    }

    public Shell getShell() {
        if (this.simpleShell != null) {
            return this.simpleShell;
        }
        return super.getShell();
    }

    public void setSimpleShell(Shell simpleShell) {
        this.simpleShell = simpleShell;
    }

    public boolean isSimple() {
        return this.simpleShell != null;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        if (SetupPropertyTester.getHandlingShell() == null) {
            SetupPropertyTester.setHandlingShell(pageContainer.getShell());
        }
    }

    public void addPages() {
        IDialogSettings wizardSection = SetupUIPlugin.INSTANCE.getDialogSettings(SetupWizard.class.getSimpleName());
        this.setDialogSettings(wizardSection);
        this.addPage((IWizardPage)new VariablePage());
        this.addPage((IWizardPage)new ConfirmationPage());
        this.addPage((IWizardPage)new ProgressPage());
    }

    public void pageChanged(PageChangedEvent event) {
        Object targetPage = event.getSelectedPage();
        boolean forward = true;
        if (this.lastPage != null) {
            IWizardPage[] iWizardPageArray = this.getPages();
            int n = iWizardPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage page = iWizardPageArray[n2];
                if (page == this.lastPage) break;
                if (page == targetPage) {
                    forward = false;
                    break;
                }
                ++n2;
            }
            if (this.lastPage instanceof SetupWizardPage) {
                ((SetupWizardPage)((Object)this.lastPage)).leavePage(forward);
            }
        }
        this.lastPage = targetPage;
        if (this.isCanceled) {
            this.dispose();
            this.getContainer().getShell().dispose();
        } else if (targetPage instanceof SetupWizardPage) {
            SetupWizardPage setupWizardPage = (SetupWizardPage)((Object)targetPage);
            setupWizardPage.enterPage(forward);
        }
    }

    public IWizardPage getCurrentPage() {
        IWizardContainer container = this.getContainer();
        if (container != null) {
            return container.getCurrentPage();
        }
        return null;
    }

    public boolean canFinish() {
        SetupWizardPage.WizardFinisher wizardFinisher;
        IWizardPage currentPage = this.getCurrentPage();
        if (currentPage instanceof SetupWizardPage && (wizardFinisher = ((SetupWizardPage)currentPage).getWizardFinisher()) != null) {
            return true;
        }
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (!page.isPageComplete()) {
                if (page instanceof ProgressPage && currentPage instanceof ConfirmationPage) break;
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean performFinish() {
        SetupWizardPage.WizardFinisher wizardFinisher;
        IWizardPage currentPage = this.getCurrentPage();
        if (currentPage instanceof SetupWizardPage && (wizardFinisher = ((SetupWizardPage)currentPage).getWizardFinisher()) != null) {
            return wizardFinisher.performFinish();
        }
        if (currentPage instanceof ProgressPage) {
            this.clearStartupProperties();
            if (this.finishAction != null) {
                UIUtil.syncExec((Runnable)this.finishAction);
            }
            return true;
        }
        if (currentPage instanceof SetupWizardPage) {
            ((SetupWizardPage)currentPage).gotoNextPage();
        }
        return false;
    }

    public boolean performCancel() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            SetupWizardPage setupWizardPage;
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof SetupWizardPage && !(setupWizardPage = (SetupWizardPage)page).performCancel()) {
                return false;
            }
            ++n2;
        }
        this.isCanceled = true;
        this.clearStartupProperties();
        return true;
    }

    public void sendStats(boolean success) {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof SetupWizardPage) {
                SetupWizardPage setupWizardPage = (SetupWizardPage)page;
                setupWizardPage.sendStats(success);
            }
            ++n2;
        }
    }

    private void clearStartupProperties() {
        System.clearProperty("oomph.setup.offline.startup");
        System.clearProperty("oomph.setup.mirrors.startup");
    }

    public int openDialog(Shell parentShell) {
        SetupWizardDialog dialog = new SetupWizardDialog(parentShell, this);
        return dialog.open();
    }

    public void reloadIndex(final URI indexLocationURI) {
        if (this.indexLoader == null) {
            this.indexLoader = new ProgressMonitorDialogIndexLoader();
            this.indexLoader.setWizard(this);
        }
        this.indexLoader.reloading = true;
        this.indexLoader.reloaded = false;
        UIUtil.asyncExec((Control)this.getShell(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SetupWizard.this.indexLoader.reloadIndex(indexLocationURI);
            }
        });
    }

    protected void reloadIndexResources(Set<Resource> updatedResources) {
        Workspace workspace;
        LinkedHashSet<Resource> excludedResources = new LinkedHashSet<Resource>();
        Resource selectionResource = this.getCatalogManager().getSelection().eResource();
        excludedResources.add(selectionResource);
        LinkedHashSet<URI> excludedResourceURIs = new LinkedHashSet<URI>();
        Installation installation = this.setupContext.getInstallation();
        if (installation != null) {
            Resource resource = installation.eResource();
            excludedResources.add(resource);
            if (SetupContext.INSTALLATION_SETUP_URI.equals(resource.getURI())) {
                excludedResourceURIs.add(SetupContext.INSTALLATION_SETUP_URI);
            }
        }
        if ((workspace = this.setupContext.getWorkspace()) != null) {
            Resource resource = workspace.eResource();
            excludedResources.add(resource);
            if (SetupContext.WORKSPACE_SETUP_URI.equals(resource.getURI())) {
                excludedResourceURIs.add(SetupContext.WORKSPACE_SETUP_URI);
            }
        }
        User user = this.setupContext.getUser();
        excludedResources.add(user.eResource());
        boolean ecoreChanged = false;
        HashSet<Object> retainedResources = new HashSet<Object>();
        EList resources = this.resourceSet.getResources();
        Iterator iterator = resources.iterator();
        while (iterator.hasNext()) {
            Object resource = (Resource)iterator.next();
            if (!excludedResources.contains(resource) && (updatedResources == null || updatedResources.contains(resource))) {
                if ("ecore".equals(resource.getURI().fileExtension())) {
                    iterator.remove();
                    ecoreChanged = true;
                    continue;
                }
                resource.unload();
                continue;
            }
            retainedResources.add(resource);
        }
        resources.remove((Object)selectionResource);
        if (ecoreChanged) {
            for (Resource resource : retainedResources) {
                if ("ecore".equals(resource.getURI().fileExtension())) {
                    resources.remove((Object)resource);
                    continue;
                }
                if (resource == selectionResource) continue;
                resource.unload();
            }
        }
        if (updatedResources == null || ecoreChanged) {
            if (updatedResources == null) {
                ECFURIHandlerImpl.clearExpectedETags();
            }
            this.resourceSet.getLoadOptions().put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITH_ETAG_CHECKING);
            this.resourceSet.getPackageRegistry().clear();
            LinkedHashSet<URI> linkedHashSet = new LinkedHashSet<URI>();
            linkedHashSet.add(SetupContext.INDEX_SETUP_URI);
            linkedHashSet.add(SetupContext.USER_SETUP_URI);
            linkedHashSet.addAll(excludedResourceURIs);
            this.loadIndex(false, linkedHashSet.toArray(new URI[linkedHashSet.size()]));
        } else {
            LinkedHashSet<URI> linkedHashSet = new LinkedHashSet<URI>();
            for (Object resource : resources) {
                linkedHashSet.add(resource.getURI());
            }
            this.loadIndex(false, linkedHashSet.toArray(new URI[linkedHashSet.size()]));
        }
    }

    public void loadIndex() {
        this.loadIndex(true, SetupContext.INDEX_SETUP_URI, SetupContext.USER_SETUP_URI);
    }

    protected void loadIndex(final boolean configure, final URI ... uris) {
        if (this.indexLoader == null) {
            this.indexLoader = new ProgressMonitorDialogIndexLoader();
            this.indexLoader.setWizard(this);
        }
        UIUtil.asyncExec((Control)this.getShell(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SetupWizard.this.indexLoader.loadIndex(configure, SetupWizard.this.resourceSet, uris);
            }
        });
    }

    protected void indexLoaded(Index index) {
        this.setSetupContext(SetupContext.createInstallationWorkspaceAndUser((ResourceSet)this.resourceSet));
        ECFURIHandlerImpl.saveProxies();
        this.resourceSet.getLoadOptions().put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITH_ETAG_CHECKING);
        this.updateJREs(index);
    }

    protected void updateJREs(Index index) {
        if (index != null) {
            ArrayList<JRE.Descriptor> jreDescriptors = new ArrayList<JRE.Descriptor>();
            Annotation jresAnnotation = index.getAnnotation("http://www.eclipse.org/oomph/setup/JRE");
            if (jresAnnotation != null) {
                OS os = this.getOS();
                EList references = jresAnnotation.getReferences();
                for (EObject eObject : references) {
                    if (!(eObject instanceof Macro)) continue;
                    Macro jresMacro = (Macro)eObject;
                    EList setupTasks = jresMacro.getSetupTasks();
                    block1: for (SetupTask setupTask : setupTasks) {
                        if (!(setupTask instanceof P2Task)) continue;
                        P2Task jreP2Task = (P2Task)setupTask;
                        String label = jreP2Task.getLabel();
                        Matcher matcher = Pattern.compile("([1-9][0-9]*)\\.([0-9]+)\\.([0-9]+)").matcher(label);
                        if (!matcher.find()) continue;
                        EList repositories = jreP2Task.getRepositories();
                        for (Requirement requirement : jreP2Task.getRequirements()) {
                            String filter = requirement.getFilter();
                            if (!SetupWizard.matchesFilterContext(filter, os)) continue block1;
                        }
                        Repository repository = (Repository)repositories.get(0);
                        JRE.Descriptor descriptor = new JRE.Descriptor(label + " - " + repository.getURL(), Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), 64, false, (Object)jreP2Task);
                        jreDescriptors.add(descriptor);
                    }
                }
            }
            JREManager.INSTANCE.setJREs(jreDescriptors);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
            this.adapterFactory = null;
        }
    }

    public static URI getBrandingSiteURI(Scope scope) {
        if (scope != null) {
            String detail;
            Annotation annotation = scope.getAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
            if (annotation != null && (detail = (String)annotation.getDetails().get((Object)"siteURI")) != null) {
                return URI.createURI((String)detail);
            }
            return SetupWizard.getBrandingSiteURI(scope.getParentScope());
        }
        return null;
    }

    public static String getLocalBrandingImageURI(Scope scope) {
        try {
            URI imageURI = SetupCoreUtil.getBrandingImageURI((Scope)scope);
            return SetupWizard.getImageURI(imageURI);
        }
        catch (Exception ex) {
            SetupUIPlugin.INSTANCE.log(ex, 2);
            URI imageURI = SetupCoreUtil.getEclipseBrandingImage();
            return SetupWizard.getImageURI(imageURI);
        }
    }

    public static Image getBrandingImage(Scope scope) {
        try {
            URI imageURI = SetupCoreUtil.getBrandingImageURI((Scope)scope);
            return SetupWizard.getImage(imageURI);
        }
        catch (Exception ex) {
            SetupUIPlugin.INSTANCE.log(ex, 2);
            URI imageURI = SetupCoreUtil.getEclipseBrandingImage();
            return SetupWizard.getImage(imageURI);
        }
    }

    public static boolean matchesFilterContext(String filter, OS os) {
        if (StringUtil.isEmpty((String)filter)) {
            return true;
        }
        LinkedHashMap<String, String> filterContext = new LinkedHashMap<String, String>();
        filterContext.put("osgi.ws", os.getOsgiWS());
        filterContext.put("osgi.os", os.getOsgiOS());
        filterContext.put("osgi.arch", os.getOsgiArch());
        InstallableUnit filterContextIU = (InstallableUnit)InstallableUnit.contextIU(filterContext);
        try {
            IMatchExpression matchExpression = InstallableUnit.parseFilter((String)filter);
            return matchExpression.isMatch((Object)filterContextIU);
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    private static String getImageURI(URI imageURI) {
        Image remoteImage = SetupWizard.getImage(imageURI);
        return ImageURIRegistry.INSTANCE.getImageURI(remoteImage).toString();
    }

    private static Image getImage(URI imageURI) {
        Object image = BaseEditUtil.getImage((URI)imageURI);
        return ExtendedImageRegistry.INSTANCE.getImage(image);
    }

    private static boolean hasModalChild(Shell parentShell, Shell excludedShell) {
        if (!parentShell.isDisposed()) {
            Shell[] shellArray = parentShell.getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell otherChildShell = shellArray[n2];
                if (otherChildShell.isVisible() && excludedShell != otherChildShell && (otherChildShell.getStyle() & 0x10000) != 0) {
                    if (otherChildShell.getData("IndexLoaderDialogShell") != null) {
                        otherChildShell.setVisible(false);
                    } else {
                        return true;
                    }
                }
                ++n2;
            }
            Composite grandParent = parentShell.getParent();
            if (grandParent instanceof Shell) {
                return SetupWizard.hasModalChild((Shell)grandParent, parentShell);
            }
        }
        return false;
    }

    private static void setProgressMonitorVisible(Shell shell, ProgressMonitorDialog progressMonitorDialog, Runnable runnable) {
        Shell dialogShell = progressMonitorDialog.getShell();
        if (dialogShell != null && !dialogShell.isDisposed()) {
            if (SetupWizard.hasModalChild(shell, dialogShell)) {
                UIUtil.timerExec((int)200, (Runnable)runnable);
            } else {
                dialogShell.setData("IndexLoaderDialogShell", (Object)progressMonitorDialog);
                dialogShell.setVisible(true);
            }
        }
    }

    public static class Importer
    extends SetupWizard
    implements IImportWizard {
        public static final String WIZARD_ID = "org.eclipse.oomph.setup.ui.ImportWizard";
        private URI projectURI;

        public Importer() {
            this.setTrigger(Trigger.MANUAL);
            this.setSetupContext(SetupContext.create((ResourceSet)this.getResourceSet()));
            this.setWindowTitle(Messages.SetupWizard_importer_title);
        }

        public void setProject(URI projectURI) {
            this.projectURI = projectURI;
        }

        public URI getProject() {
            return this.projectURI;
        }

        @Override
        public String getHelpPath() {
            return "/org.eclipse.oomph.setup.doc/html/user/wizard/DocImportWizard.html";
        }

        public void init(IWorkbench workbench, IStructuredSelection selection) {
        }

        @Override
        public void addPages() {
            Shell performingShell = SetupPropertyTester.getPerformingShell();
            if (performingShell != null) {
                String title = this.getWindowTitle();
                this.addPage((IWizardPage)new ExistingProcessPage(title));
                return;
            }
            this.addPage((IWizardPage)new ProjectPage(new SelectionMemento()));
            super.addPages();
            UIUtil.getDisplay().timerExec(500, new Runnable(){

                @Override
                public void run() {
                    this.getResourceSet().getLoadOptions().put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITHOUT_ETAG_CHECKING);
                    this.loadIndex();
                }
            });
        }

        @Override
        protected void indexLoaded(Index index) {
            super.indexLoaded(index);
            this.getCatalogManager().indexLoaded(index);
        }

        private static final class ExistingProcessPage
        extends WizardPage {
            public ExistingProcessPage(String title) {
                super("ExistingProcess");
                this.setTitle(title);
                this.setErrorMessage(NLS.bind((String)Messages.SetupWizard_ExistingProcessPage_errorMessage, (Object)title));
            }

            public void createControl(Composite parent) {
                Composite container = new Composite(parent, 0);
                container.setLayout((Layout)new GridLayout());
                this.setControl((Control)container);
                GridData explanationGridData = new GridData(0x1000000, 1024, true, true);
                explanationGridData.widthHint = 320;
                Label explanation = new Label(container, 64);
                explanation.setLayoutData((Object)explanationGridData);
                explanation.setText(Messages.SetupWizard_ExistingProcessPage_anotherSetupProcessAlreadyActive);
                Label image = new Label(container, 2048);
                image.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
                image.setImage(SetupUIPlugin.INSTANCE.getSWTImage("existing_process.png"));
                new Label(container, 0);
                new Label(container, 0);
                Label suggestion = new Label(container, 64);
                suggestion.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
                suggestion.setText(Messages.SetupWizard_ExistingProcessPage_completeOtherProcessBeforeImporting);
                Button button = new Button(container, 0);
                button.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
                button.setText(Messages.SetupWizard_ExistingProcessPage_openExistingSetupButton_text);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String title = this.getTitle();
                        String message = Messages.SetupWizard_ExistingProcessPage_existingProcessFinished;
                        Shell currentShell = this.getShell();
                        Shell parentShell = (Shell)currentShell.getParent();
                        currentShell.dispose();
                        Shell performingShell = SetupPropertyTester.getPerformingShell();
                        if (performingShell == null) {
                            IWizardDescriptor descriptor = PlatformUI.getWorkbench().getImportWizardRegistry().findWizard(Importer.WIZARD_ID);
                            if (descriptor == null) {
                                MessageDialog.openInformation((Shell)parentShell, (String)title, (String)message);
                            } else if (MessageDialog.openQuestion((Shell)parentShell, (String)title, (String)(message + "\n" + NLS.bind((String)Messages.SetupWizard_ExistingProcessPage_doYouWantToOpenAgain, (Object)title)))) {
                                try {
                                    IWorkbenchWizard wizard = descriptor.createWizard();
                                    WizardDialog wizardDialog = new WizardDialog(parentShell, (IWizard)wizard);
                                    wizardDialog.setTitle(title);
                                    wizardDialog.open();
                                }
                                catch (CoreException ex) {
                                    SetupUIPlugin.INSTANCE.log(ex);
                                }
                            }
                        } else {
                            boolean visible = !performingShell.isVisible();
                            performingShell.setVisible(visible);
                            if (SetupPropertyTester.getPerformingStatus() != null) {
                                SetupPropertyTester.setPerformingShell(null);
                            }
                            if (visible) {
                                performingShell.setFocus();
                            }
                        }
                    }
                });
                new Label(container, 0).setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
                this.setPageComplete(false);
            }
        }
    }

    public static abstract class IndexLoader {
        private SetupWizard wizard;
        private volatile boolean loading = true;
        private volatile boolean reloading;
        private volatile boolean reloaded;
        protected boolean showETagProgress;

        final void setWizard(SetupWizard wizard) {
            this.wizard = wizard;
        }

        public final SetupWizard getWizard() {
            return this.wizard;
        }

        public abstract void loadIndex(IRunnableWithProgress var1, int var2);

        public void loadIndex(final boolean configure, final ResourceSet resourceSet, final URI ... uris) {
            this.loadIndex(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (configure) {
                        new IndexManager().configure(resourceSet);
                    }
                    this.loadIndex(resourceSet, uris, monitor);
                }
            }, 3000);
        }

        protected final void loadIndex(final ResourceSet resourceSet, final URI[] uris, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.loading = true;
            ResourceMirror.WithProductImages resourceMirror = new ResourceMirror.WithProductImages(resourceSet){

                protected void run(String taskName, IProgressMonitor monitor) {
                    this.perform(uris);
                    this.resolveProxies();
                }
            };
            resourceMirror.begin(monitor);
            if (resourceMirror.isCanceled()) {
                Display display = this.wizard.getShell().getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        resourceSet.getLoadOptions().put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITHOUT_ETAG_CHECKING);
                        LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
                        for (Resource resource : resourceSet.getResources()) {
                            URI uri = resource.getURI();
                            if ("ecore".equals(uri.fileExtension())) continue;
                            uris.add(resource.getURI());
                        }
                        this.loadIndex(false, resourceSet, uris.toArray(new URI[uris.size()]));
                    }
                });
            } else {
                Resource resource = resourceSet.getResource(SetupContext.INDEX_SETUP_URI, false);
                final Index index = (Index)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SetupPackage.Literals.INDEX);
                if (index == null) {
                    this.logErrors(resource);
                }
                Display display = this.wizard.getShell().getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        this.indexLoaded(index);
                        if (wizard.getShell().isDisposed()) {
                            return;
                        }
                        if (wizard.indexLoadedAction != null) {
                            try {
                                wizard.indexLoadedAction.run();
                            }
                            catch (Exception ex) {
                                SetupUIPlugin.INSTANCE.log(ex);
                            }
                        }
                        if (reloading) {
                            loading = false;
                            reloading = false;
                            reloaded = true;
                        } else {
                            final Shell shell = wizard.getShell();
                            reloading = true;
                            loading = false;
                            UIUtil.asyncExec((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (SetupWizard.hasModalChild(shell, null)) {
                                        UIUtil.timerExec((int)200, (Runnable)this);
                                        return;
                                    }
                                    final ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
                                    progressMonitorDialog.setOpenOnRun(false);
                                    try {
                                        progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                                LinkedHashMap uriMap = new LinkedHashMap();
                                                final LinkedHashMap resourceMap = new LinkedHashMap();
                                                URIConverter uriConverter = resourceSet.getURIConverter();
                                                for (Resource resource : resourceSet.getResources()) {
                                                    EList contents = resource.getContents();
                                                    if (!contents.isEmpty()) {
                                                        EClass eClass = ((EObject)contents.get(0)).eClass();
                                                        if (!this.shouldReload(eClass)) continue;
                                                        URI uri = uriConverter.normalize(resource.getURI());
                                                        String scheme = uri.scheme();
                                                        if (uri.isArchive()) {
                                                            String authority = uri.authority();
                                                            if (!authority.startsWith("http:") && !authority.startsWith("https:")) continue;
                                                            URI archiveURI = URI.createURI((String)authority.substring(0, authority.length() - 1));
                                                            CollectionUtil.add(uriMap, (Object)eClass, (Object)archiveURI);
                                                            CollectionUtil.add(resourceMap, (Object)archiveURI, (Object)resource);
                                                            continue;
                                                        }
                                                        if (!"http".equals(scheme) && !"https".equals(scheme)) continue;
                                                        CollectionUtil.add(uriMap, (Object)eClass, (Object)uri);
                                                        CollectionUtil.add(resourceMap, (Object)uri, (Object)resource);
                                                        continue;
                                                    }
                                                    URI uri = uriConverter.normalize(resource.getURI());
                                                    String scheme = uri.scheme();
                                                    if (!"https".equals(scheme)) continue;
                                                    CollectionUtil.add(uriMap, (Object)SetupPackage.Literals.PROJECT, (Object)uri);
                                                    CollectionUtil.add(resourceMap, (Object)uri, (Object)resource);
                                                }
                                                LinkedHashSet resourceURIs = new LinkedHashSet();
                                                EClass[] eClassArray = new EClass[]{SetupPackage.Literals.INDEX, SetupPackage.Literals.PRODUCT_CATALOG, SetupPackage.Literals.PRODUCT, SetupPackage.Literals.PROJECT_CATALOG, SetupPackage.Literals.PROJECT};
                                                int n = eClassArray.length;
                                                int contents = 0;
                                                while (contents < n) {
                                                    EClass eClass = eClassArray[contents];
                                                    Set uris = (Set)uriMap.remove(eClass);
                                                    if (uris != null) {
                                                        resourceURIs.addAll(uris);
                                                    }
                                                    ++contents;
                                                }
                                                for (Set uris : uriMap.values()) {
                                                    resourceURIs.addAll(uris);
                                                }
                                                int size = resourceURIs.size();
                                                if (size != 0) {
                                                    if (showETagProgress) {
                                                        UIUtil.asyncExec((Runnable)new Runnable(){

                                                            @Override
                                                            public void run() {
                                                                UIUtil.timerExec((int)1000, (Runnable)new Runnable(){

                                                                    @Override
                                                                    public void run() {
                                                                        SetupWizard.setProgressMonitorVisible(shell, progressMonitorDialog, this);
                                                                    }
                                                                });
                                                            }
                                                        });
                                                    }
                                                    final HashSet updatedResources = new HashSet();
                                                    new ECFURIHandlerImpl.ETagMirror(){

                                                        protected synchronized void cacheUpdated(URI uri) {
                                                            Set resources = (Set)resourceMap.get(uri);
                                                            if (resources != null) {
                                                                updatedResources.addAll(resources);
                                                            }
                                                        }
                                                    }.begin(resourceURIs, monitor);
                                                    if (!shell.isDisposed() && !updatedResources.isEmpty()) {
                                                        shell.getDisplay().asyncExec(new Runnable(){

                                                            @Override
                                                            public void run() {
                                                                wizard.reloadIndexResources(updatedResources);
                                                            }
                                                        });
                                                    } else {
                                                        reloading = false;
                                                        reloaded = true;
                                                    }
                                                } else {
                                                    reloading = false;
                                                    reloaded = true;
                                                }
                                            }
                                        });
                                    }
                                    catch (InvocationTargetException ex) {
                                        SetupUIPlugin.INSTANCE.log(ex);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }

        public void reloadIndex(final URI indexLocationURI) {
            this.loadIndex(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (indexLocationURI != null) {
                        new IndexManager().configureForProxy(this.getWizard().getResourceSet(), indexLocationURI);
                    }
                    this.getWizard().reloadIndexResources(null);
                }
            }, 1000);
        }

        protected void indexLoaded(Index index) {
            this.wizard.indexLoaded(index);
        }

        protected boolean shouldReload(EClass eClass) {
            return true;
        }

        public void awaitIndexLoad() {
            if (this.loading || this.reloading && !this.reloaded) {
                try {
                    this.waiting();
                    Shell shell = this.wizard.getShell();
                    Display display = shell.getDisplay();
                    while (!this.reloaded) {
                        if (display.isDisposed() || display.readAndDispatch()) continue;
                        display.sleep();
                    }
                }
                finally {
                    this.finishedWaiting();
                }
            }
        }

        protected void waiting() {
            Shell shell = this.wizard.getShell();
            shell.setCursor(shell.getDisplay().getSystemCursor(1));
        }

        protected void finishedWaiting() {
            Shell shell = this.wizard.getShell();
            if (shell != null && !shell.isDisposed()) {
                shell.setCursor(null);
            }
        }

        private void logErrors(Resource resource) {
            try {
                for (Resource.Diagnostic diagnostic : resource.getErrors()) {
                    try {
                        if (diagnostic instanceof Throwable) {
                            Throwable throwable = (Throwable)diagnostic;
                            SetupUIPlugin.INSTANCE.log(throwable);
                            continue;
                        }
                        SetupUIPlugin.INSTANCE.log(diagnostic.getMessage(), 4);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class ProgressMonitorDialogIndexLoader
    extends IndexLoader {
        public ProgressMonitorDialogIndexLoader() {
            this.showETagProgress = true;
        }

        @Override
        public void loadIndex(IRunnableWithProgress runnable, int delay) {
            final Shell shell = this.getWizard().getShell();
            final ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
            progressMonitorDialog.setOpenOnRun(false);
            try {
                UIUtil.timerExec((int)delay, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SetupWizard.setProgressMonitorVisible(shell, progressMonitorDialog, this);
                    }
                });
                progressMonitorDialog.run(true, true, runnable);
            }
            catch (InvocationTargetException ex) {
                SetupUIPlugin.INSTANCE.log(ex);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static final class SelectionMemento
    implements Externalizable {
        private URI productVersion;
        private List<URI> streams;

        public URI getProductVersion() {
            return this.productVersion;
        }

        public void setProductVersion(URI productVersion) {
            this.productVersion = productVersion;
        }

        public List<URI> getStreams() {
            return this.streams;
        }

        public void setStreams(List<URI> streams) {
            this.streams = streams;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            if (this.productVersion != null) {
                out.writeBoolean(true);
                out.writeUTF(this.productVersion.toString());
            } else {
                out.writeBoolean(false);
            }
            if (this.streams != null) {
                out.writeInt(this.streams.size());
                for (URI stream : this.streams) {
                    out.writeUTF(stream.toString());
                }
            } else {
                out.writeInt(-1);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size;
            if (in.readBoolean()) {
                this.productVersion = URI.createURI((String)in.readUTF());
            }
            if ((size = in.readInt()) != -1) {
                this.streams = new ArrayList<URI>();
                int i = 0;
                while (i < size) {
                    URI stream = URI.createURI((String)in.readUTF());
                    this.streams.add(stream);
                    ++i;
                }
            }
        }
    }

    public static class Updater
    extends SetupWizard {
        protected boolean openInBackground;

        public Updater(boolean manual) {
            this.setTrigger(manual ? Trigger.MANUAL : Trigger.STARTUP);
            this.setSetupContext(SetupContext.create((ResourceSet)this.getResourceSet()));
            this.setWindowTitle(Messages.SetupWizard_updater_title);
        }

        public Updater(SetupTaskPerformer performer) {
            super(performer);
            this.openInBackground = true;
            this.setWindowTitle(Messages.SetupWizard_updater_title);
        }

        public Updater(SetupContext setupContext) {
            super(setupContext);
            this.setWindowTitle(Messages.SetupWizard_updater_title);
        }

        @Override
        public String getHelpPath() {
            return "/org.eclipse.oomph.setup.doc/html/user/wizard/DocUpdateWizard.html";
        }

        @Override
        public int openDialog(Shell parentShell) {
            if (this.openInBackground) {
                SetupWizardDialog dialog = new SetupWizardDialog(parentShell, this);
                if ("true".equals(PropertiesUtil.getProperty((String)"oomph.setup.show.initial.progress"))) {
                    dialog.setBlockOnOpen(false);
                    return dialog.open();
                }
                return dialog.openInBackground();
            }
            return super.openDialog(parentShell);
        }

        public static void perform(boolean manual) {
            Updater updater = new Updater(manual){

                @Override
                public void createPageControls(Composite pageContainer) {
                    this.loadIndex();
                    super.createPageControls(pageContainer);
                }
            };
            Shell shell = UIUtil.getShell();
            ((SetupWizard)updater).openDialog(shell);
        }

        public static void perform(SetupContext setupContext) {
            Updater updater = new Updater(setupContext){
                {
                    this.setTrigger(Trigger.MANUAL);
                }

                @Override
                public void createPageControls(Composite pageContainer) {
                    this.loadIndex();
                    super.createPageControls(pageContainer);
                }
            };
            Shell shell = UIUtil.getShell();
            ((SetupWizard)updater).openDialog(shell);
        }
    }
}

