/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin.utils;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.jetty.maven.plugin.OverlayManager;
import org.eclipse.jetty.maven.plugin.WarPluginInfo;

public class MavenProjectHelper {
    private MavenProject project;
    private RepositorySystem repositorySystem;
    private List<ArtifactRepository> remoteRepositories;
    private MavenSession session;
    private final Map<String, MavenProject> artifactToReactorProjectMap;
    private WarPluginInfo warPluginInfo;
    private OverlayManager overlayManager;

    public MavenProjectHelper(MavenProject project, RepositorySystem repositorySystem, List<ArtifactRepository> remoteRepositories, MavenSession session) {
        this.project = project;
        this.repositorySystem = repositorySystem;
        this.remoteRepositories = remoteRepositories;
        this.session = session;
        Set<MavenProject> mavenProjects = MavenProjectHelper.findDependenciesInReactor(project, new HashSet<MavenProject>());
        this.artifactToReactorProjectMap = mavenProjects.stream().collect(Collectors.toMap(MavenProject::getId, Function.identity()));
        this.artifactToReactorProjectMap.put(project.getArtifact().getId(), project);
        this.warPluginInfo = new WarPluginInfo(project);
        this.overlayManager = new OverlayManager(this.warPluginInfo);
    }

    public MavenProject getProject() {
        return this.project;
    }

    public WarPluginInfo getWarPluginInfo() {
        return this.warPluginInfo;
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    public MavenProject getMavenProjectFor(org.apache.maven.artifact.Artifact artifact) {
        return this.artifactToReactorProjectMap.get(artifact.getId());
    }

    public Path getPathFor(org.apache.maven.artifact.Artifact artifact) {
        Path path = artifact.getFile().toPath();
        MavenProject mavenProject = this.getMavenProjectFor(artifact);
        if (mavenProject != null) {
            path = "test-jar".equals(artifact.getType()) ? Paths.get(mavenProject.getBuild().getTestOutputDirectory(), new String[0]) : Paths.get(mavenProject.getBuild().getOutputDirectory(), new String[0]);
        }
        return path;
    }

    public File resolveArtifact(String groupId, String artifactId, String version, String type) throws ArtifactResolutionException {
        ArtifactRequest request = new ArtifactRequest();
        request.setRepositories(RepositoryUtils.toRepos(this.remoteRepositories));
        request.setArtifact((Artifact)new DefaultArtifact(groupId, artifactId, "", type, version));
        ArtifactResult result = this.repositorySystem.resolveArtifact(this.session.getRepositorySession(), request);
        if (result.isResolved()) {
            return result.getArtifact().getFile();
        }
        return null;
    }

    private static Set<MavenProject> findDependenciesInReactor(MavenProject project, Set<MavenProject> visitedProjects) {
        if (visitedProjects.contains(project)) {
            return Collections.emptySet();
        }
        visitedProjects.add(project);
        Collection refs = project.getProjectReferences().values();
        HashSet<MavenProject> availableProjects = new HashSet<MavenProject>(refs);
        for (MavenProject ref : refs) {
            availableProjects.addAll(MavenProjectHelper.findDependenciesInReactor(ref, visitedProjects));
        }
        return availableProjects;
    }
}

