/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session.infinispan;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;

public class BoundDelegatingInputStream
extends InputStream {
    protected final ObjectInput objectInput;
    private final int length;
    private int position = 0;

    public BoundDelegatingInputStream(ObjectInput objectInput) throws IOException {
        this.objectInput = objectInput;
        this.length = objectInput.readInt();
    }

    @Override
    public int read() throws IOException {
        if (this.position < this.length) {
            ++this.position;
            return this.objectInput.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int available = this.length - this.position;
        int read = -1;
        if (this.position == this.length) {
            return read;
        }
        read = b.length > available ? this.objectInput.read(b, 0, available) : this.objectInput.read(b);
        if (read != -1) {
            this.position += read;
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = -1;
        if (this.position == this.length) {
            return read;
        }
        read = this.position + len > this.length ? this.objectInput.read(b, off, this.length - this.position) : this.objectInput.read(b, off, len);
        if (read != -1) {
            this.position += read;
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = 0L;
        skip = (long)this.position + n < (long)this.length ? this.objectInput.skip(this.length - this.position) : this.objectInput.skip(n);
        if (skip > 0L) {
            this.position = (int)((long)this.position + skip);
        }
        return skip;
    }

    @Override
    public int available() throws IOException {
        if (this.position < this.length) {
            int available = this.objectInput.available();
            if (this.position + available > this.length) {
                return this.length - this.position;
            }
            return available;
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.objectInput.close();
    }
}

