/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client.http;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.client.AbstractHttpClientTransport;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.MultiplexConnectionPool;
import org.eclipse.jetty.client.MultiplexHttpDestination;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.http3.HTTP3Configuration;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.client.HTTP3Client;
import org.eclipse.jetty.http3.client.HTTP3ClientConnectionFactory;
import org.eclipse.jetty.http3.client.http.internal.HttpConnectionOverHTTP3;
import org.eclipse.jetty.http3.client.http.internal.SessionClientListener;
import org.eclipse.jetty.http3.client.internal.HTTP3SessionClient;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.util.Callback;

public class HttpClientTransportOverHTTP3
extends AbstractHttpClientTransport
implements ProtocolSession.Factory {
    private final HTTP3ClientConnectionFactory factory = new HTTP3ClientConnectionFactory();
    private final HTTP3Client client;

    public HttpClientTransportOverHTTP3(HTTP3Client client) {
        this.client = Objects.requireNonNull(client);
        this.addBean(client);
        this.setConnectionPoolFactory(destination -> {
            HttpClient httpClient = this.getHttpClient();
            return new MultiplexConnectionPool(destination, httpClient.getMaxConnectionsPerDestination(), (Callback)destination, 1);
        });
    }

    public HTTP3Client getHTTP3Client() {
        return this.client;
    }

    protected void doStart() throws Exception {
        if (!this.client.isStarted()) {
            HttpClient httpClient = this.getHttpClient();
            ClientConnector clientConnector = this.client.getClientConnector();
            clientConnector.setExecutor(httpClient.getExecutor());
            clientConnector.setScheduler(httpClient.getScheduler());
            clientConnector.setByteBufferPool(httpClient.getByteBufferPool());
            clientConnector.setConnectTimeout(Duration.ofMillis(httpClient.getConnectTimeout()));
            clientConnector.setConnectBlocking(httpClient.isConnectBlocking());
            clientConnector.setBindAddress(httpClient.getBindAddress());
            clientConnector.setIdleTimeout(Duration.ofMillis(httpClient.getIdleTimeout()));
            HTTP3Configuration configuration = this.client.getHTTP3Configuration();
            configuration.setInputBufferSize(httpClient.getResponseBufferSize());
            configuration.setUseInputDirectByteBuffers(httpClient.isUseInputDirectByteBuffers());
            configuration.setUseOutputDirectByteBuffers(httpClient.isUseOutputDirectByteBuffers());
        }
        super.doStart();
    }

    public Origin newOrigin(HttpRequest request) {
        return this.getHttpClient().createOrigin(request, new Origin.Protocol(List.of("h3"), false));
    }

    public HttpDestination newHttpDestination(Origin origin) {
        SocketAddress address = origin.getAddress().getSocketAddress();
        return new MultiplexHttpDestination(this.getHttpClient(), origin, this.getHTTP3Client().getClientConnector().isIntrinsicallySecure(address));
    }

    public void connect(InetSocketAddress address, Map<String, Object> context) {
        this.connect((SocketAddress)address, context);
    }

    public void connect(SocketAddress address, Map<String, Object> context) {
        HttpClient httpClient = this.getHttpClient();
        ClientConnector clientConnector = this.client.getClientConnector();
        clientConnector.setConnectTimeout(Duration.ofMillis(httpClient.getConnectTimeout()));
        clientConnector.setConnectBlocking(httpClient.isConnectBlocking());
        clientConnector.setBindAddress(httpClient.getBindAddress());
        HttpDestination destination = (HttpDestination)context.get("org.eclipse.jetty.client.destination");
        context.put("org.eclipse.jetty.client.connector.clientConnectionFactory", destination.getClientConnectionFactory());
        TransportSessionClientListener listener = new TransportSessionClientListener(context);
        this.getHTTP3Client().connect(address, (Session.Client.Listener)listener, context).whenComplete(listener::onConnect);
    }

    public ProtocolSession newProtocolSession(QuicSession quicSession, Map<String, Object> context) {
        return this.factory.newProtocolSession(quicSession, context);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) {
        return this.factory.newConnection(endPoint, context);
    }

    protected HttpConnection newHttpConnection(HttpDestination destination, HTTP3SessionClient session) {
        return new HttpConnectionOverHTTP3(destination, session);
    }

    private class TransportSessionClientListener
    extends SessionClientListener {
        private TransportSessionClientListener(Map<String, Object> context) {
            super(context);
        }

        @Override
        protected HttpConnectionOverHTTP3 newHttpConnection(HttpDestination destination, HTTP3SessionClient session) {
            return (HttpConnectionOverHTTP3)HttpClientTransportOverHTTP3.this.newHttpConnection(destination, session);
        }
    }
}

