/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.docs.programming.server.http3;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.internal.HTTP3ErrorCode;
import org.eclipse.jetty.http3.server.HTTP3ServerConnector;
import org.eclipse.jetty.http3.server.RawHTTP3ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HTTP3ServerDocs {
    public void setup() throws Exception {
        Server server = new Server();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath("/path/to/keystore");
        sslContextFactory.setKeyStorePassword("secret");
        Session.Server.Listener sessionListener = new Session.Server.Listener(){};
        RawHTTP3ServerConnectionFactory http3 = new RawHTTP3ServerConnectionFactory(sessionListener);
        http3.getHTTP3Configuration().setStreamIdleTimeout(15000L);
        HTTP3ServerConnector connector = new HTTP3ServerConnector(server, sslContextFactory, new ConnectionFactory[]{http3});
        connector.getQuicConfiguration().setMaxBidirectionalRemoteStreams(1024);
        server.addConnector((Connector)connector);
        server.start();
    }

    public void accept() {
        Session.Server.Listener sessionListener = new Session.Server.Listener(){

            public void onAccept(Session session) {
                SocketAddress remoteAddress = session.getRemoteSocketAddress();
                System.getLogger("http3").log(System.Logger.Level.INFO, "Connection from {0}", remoteAddress);
            }
        };
    }

    public void preface() {
        Session.Server.Listener sessionListener = new Session.Server.Listener(){

            public Map<Long, Long> onPreface(Session session) {
                HashMap<Long, Long> settings = new HashMap<Long, Long>();
                return settings;
            }
        };
    }

    public void request() {
        Session.Server.Listener sessionListener = new Session.Server.Listener(){

            public Stream.Server.Listener onRequest(Stream.Server stream, HeadersFrame frame) {
                MetaData.Request request = (MetaData.Request)frame.getMetaData();
                return new Stream.Server.Listener(){};
            }
        };
    }

    public void requestContent() {
        Session.Server.Listener sessionListener = new Session.Server.Listener(){

            public Stream.Server.Listener onRequest(Stream.Server stream, HeadersFrame frame) {
                MetaData.Request request = (MetaData.Request)frame.getMetaData();
                stream.demand();
                return new Stream.Server.Listener(){

                    public void onDataAvailable(Stream.Server stream) {
                        Stream.Data data = stream.readData();
                        if (data == null) {
                            stream.demand();
                        } else {
                            ByteBuffer buffer = data.getByteBuffer();
                            System.getLogger("http3").log(System.Logger.Level.INFO, "Consuming buffer {0}", buffer);
                            data.complete();
                            if (!data.isLast()) {
                                stream.demand();
                            }
                        }
                    }
                };
            }
        };
    }

    public void response() {
        Session.Server.Listener sessionListener = new Session.Server.Listener(){

            public Stream.Server.Listener onRequest(Stream.Server stream, HeadersFrame frame) {
                final MetaData.Request request = (MetaData.Request)frame.getMetaData();
                if (frame.isLast()) {
                    this.respond(stream, request);
                    return null;
                }
                stream.demand();
                return new Stream.Server.Listener(){

                    public void onDataAvailable(Stream.Server stream) {
                        Stream.Data data = stream.readData();
                        if (data == null) {
                            stream.demand();
                        } else {
                            data.complete();
                            if (data.isLast()) {
                                this.respond(stream, request);
                            }
                        }
                    }
                };
            }

            private void respond(Stream.Server stream, MetaData.Request request) {
                MetaData.Response response = new MetaData.Response(HttpVersion.HTTP_3, 200, HttpFields.EMPTY);
                if (HttpMethod.GET.is(request.getMethod())) {
                    ByteBuffer resourceBytes = this.getResourceBytes(request);
                    stream.respond(new HeadersFrame((MetaData)response, false)).thenCompose(s -> s.data(new DataFrame(resourceBytes, true)));
                } else {
                    stream.respond(new HeadersFrame((MetaData)response, true));
                }
            }

            private ByteBuffer getResourceBytes(MetaData.Request request) {
                return ByteBuffer.allocate(1024);
            }
        };
    }

    public void reset() {
        final float maxRequestRate = 0.0f;
        Session.Server.Listener sessionListener = new Session.Server.Listener(){

            public Stream.Server.Listener onRequest(Stream.Server stream, HeadersFrame frame) {
                float requestRate = this.calculateRequestRate();
                if (requestRate > maxRequestRate) {
                    stream.reset(HTTP3ErrorCode.REQUEST_REJECTED_ERROR.code(), (Throwable)new RejectedExecutionException());
                    return null;
                }
                MetaData.Request request = (MetaData.Request)frame.getMetaData();
                return new Stream.Server.Listener(){};
            }

            private float calculateRequestRate() {
                return 0.0f;
            }
        };
    }
}

