/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.server;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.DatagramChannelEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.quic.common.QuicConfiguration;
import org.eclipse.jetty.quic.common.QuicSessionContainer;
import org.eclipse.jetty.quic.quiche.PemExporter;
import org.eclipse.jetty.quic.quiche.QuicheConfig;
import org.eclipse.jetty.quic.server.ServerQuicConnection;
import org.eclipse.jetty.server.AbstractNetworkConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;

public class QuicServerConnector
extends AbstractNetworkConnector {
    private final QuicConfiguration quicConfiguration = new QuicConfiguration();
    private final QuicSessionContainer container = new QuicSessionContainer();
    private final ServerDatagramSelectorManager selectorManager = new ServerDatagramSelectorManager(this.getExecutor(), this.getScheduler(), 1);
    private final SslContextFactory.Server sslContextFactory;
    private Path privateKeyPemPath;
    private Path certificateChainPemPath;
    private Path trustedCertificatesPemPath;
    private volatile DatagramChannel datagramChannel;
    private volatile int localPort = -1;
    private int inputBufferSize = 2048;
    private int outputBufferSize = 2048;
    private boolean useInputDirectByteBuffers = true;
    private boolean useOutputDirectByteBuffers = true;

    public QuicServerConnector(Server server, SslContextFactory.Server sslContextFactory, ConnectionFactory ... factories) {
        this(server, null, null, null, sslContextFactory, factories);
    }

    public QuicServerConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool bufferPool, SslContextFactory.Server sslContextFactory, ConnectionFactory ... factories) {
        super(server, executor, scheduler, bufferPool, 0, factories);
        this.addBean((Object)this.selectorManager);
        this.sslContextFactory = sslContextFactory;
        this.addBean(this.sslContextFactory);
        this.addBean(this.quicConfiguration);
        this.addBean(this.container);
        this.quicConfiguration.setSessionRecvWindow(0x400000);
        this.quicConfiguration.setBidirectionalStreamRecvWindow(0x200000);
        this.quicConfiguration.setMaxBidirectionalRemoteStreams(1);
        this.quicConfiguration.setMaxUnidirectionalRemoteStreams(0);
    }

    public QuicConfiguration getQuicConfiguration() {
        return this.quicConfiguration;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public void setInputBufferSize(int inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public void setOutputBufferSize(int outputBufferSize) {
        this.outputBufferSize = outputBufferSize;
    }

    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public boolean isUseOutputDirectByteBuffers() {
        return this.useOutputDirectByteBuffers;
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this.useOutputDirectByteBuffers = useOutputDirectByteBuffers;
    }

    public boolean isOpen() {
        DatagramChannel channel = this.datagramChannel;
        return channel != null && channel.isOpen();
    }

    protected void doStart() throws Exception {
        String keyManagerPassword;
        for (EventListener l : this.getBeans(SelectorManager.SelectorManagerListener.class)) {
            this.selectorManager.addEventListener(l);
        }
        super.doStart();
        this.selectorManager.accept(this.datagramChannel);
        Set aliases = this.sslContextFactory.getAliases();
        if (aliases.isEmpty()) {
            throw new IllegalStateException("Missing or invalid KeyStore: a SslContextFactory configured with a valid, non-empty KeyStore is required");
        }
        String alias = this.sslContextFactory.getCertAlias();
        if (alias == null) {
            alias = (String)aliases.stream().findFirst().orElseThrow();
        }
        char[] password = (keyManagerPassword = this.sslContextFactory.getKeyManagerPassword()) == null ? this.sslContextFactory.getKeyStorePassword().toCharArray() : keyManagerPassword.toCharArray();
        KeyStore keyStore = this.sslContextFactory.getKeyStore();
        Path certificateWorkPath = this.findPemWorkDirectory();
        Path[] keyPair = PemExporter.exportKeyPair((KeyStore)keyStore, (String)alias, (char[])password, (Path)certificateWorkPath);
        this.privateKeyPemPath = keyPair[0];
        this.certificateChainPemPath = keyPair[1];
        KeyStore trustStore = this.sslContextFactory.getTrustStore();
        if (trustStore != null) {
            this.trustedCertificatesPemPath = PemExporter.exportTrustStore((KeyStore)trustStore, (Path)certificateWorkPath);
        }
    }

    private Path findPemWorkDirectory() {
        Path pemWorkDirectory = this.getQuicConfiguration().getPemWorkDirectory();
        if (pemWorkDirectory != null) {
            return pemWorkDirectory;
        }
        String jettyBase = System.getProperty("jetty.base");
        if (jettyBase != null && Files.exists(pemWorkDirectory = Path.of(jettyBase, new String[0]).resolve("work"), new LinkOption[0])) {
            return pemWorkDirectory;
        }
        throw new IllegalStateException("No PEM work directory configured");
    }

    public void open() throws IOException {
        if (this.datagramChannel == null) {
            this.datagramChannel = this.openDatagramChannel();
            this.datagramChannel.configureBlocking(false);
            this.localPort = this.datagramChannel.socket().getLocalPort();
            if (this.localPort <= 0) {
                throw new IOException("DatagramChannel not bound");
            }
            this.addBean(this.datagramChannel);
        }
    }

    protected DatagramChannel openDatagramChannel() throws IOException {
        InetSocketAddress bindAddress = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
        DatagramChannel datagramChannel = DatagramChannel.open();
        try {
            datagramChannel.bind(bindAddress);
            return datagramChannel;
        }
        catch (Throwable e) {
            IO.close((Closeable)datagramChannel);
            throw new IOException("Failed to bind to " + bindAddress, e);
        }
    }

    QuicheConfig newQuicheConfig() {
        QuicheConfig quicheConfig = new QuicheConfig();
        quicheConfig.setPrivKeyPemPath(this.privateKeyPemPath.toString());
        quicheConfig.setCertChainPemPath(this.certificateChainPemPath.toString());
        quicheConfig.setTrustedCertsPemPath(this.trustedCertificatesPemPath == null ? null : this.trustedCertificatesPemPath.toString());
        quicheConfig.setVerifyPeer(Boolean.valueOf(this.sslContextFactory.getNeedClientAuth() || this.sslContextFactory.getWantClientAuth()));
        quicheConfig.setMaxIdleTimeout(Long.valueOf(0L));
        quicheConfig.setInitialMaxData(Long.valueOf(this.quicConfiguration.getSessionRecvWindow()));
        quicheConfig.setInitialMaxStreamDataBidiLocal(Long.valueOf(this.quicConfiguration.getBidirectionalStreamRecvWindow()));
        quicheConfig.setInitialMaxStreamDataBidiRemote(Long.valueOf(this.quicConfiguration.getBidirectionalStreamRecvWindow()));
        quicheConfig.setInitialMaxStreamDataUni(Long.valueOf(this.quicConfiguration.getUnidirectionalStreamRecvWindow()));
        quicheConfig.setInitialMaxStreamsUni(Long.valueOf(this.quicConfiguration.getMaxUnidirectionalRemoteStreams()));
        quicheConfig.setInitialMaxStreamsBidi(Long.valueOf(this.quicConfiguration.getMaxBidirectionalRemoteStreams()));
        quicheConfig.setCongestionControl(QuicheConfig.CongestionControl.CUBIC);
        List protocols = this.getProtocols();
        protocols.add(0, "http/0.9");
        quicheConfig.setApplicationProtos((String[])protocols.toArray(String[]::new));
        return quicheConfig;
    }

    public void setIdleTimeout(long idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        this.selectorManager.setIdleTimeout(idleTimeout);
    }

    protected void doStop() throws Exception {
        this.deleteFile(this.privateKeyPemPath);
        this.privateKeyPemPath = null;
        this.deleteFile(this.certificateChainPemPath);
        this.certificateChainPemPath = null;
        this.deleteFile(this.trustedCertificatesPemPath);
        this.trustedCertificatesPemPath = null;
        super.doStop();
        this.removeBean(this.datagramChannel);
        this.datagramChannel = null;
        this.localPort = -2;
        for (EventListener l : this.getBeans(EventListener.class)) {
            this.selectorManager.removeEventListener(l);
        }
    }

    private void deleteFile(Path file) {
        block3: {
            try {
                if (file != null) {
                    Files.delete(file);
                }
            }
            catch (IOException x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("could not delete {}", (Object)file, (Object)x);
            }
        }
    }

    public CompletableFuture<Void> shutdown() {
        return this.container.shutdown();
    }

    public Object getTransport() {
        return this.datagramChannel;
    }

    protected void accept(int acceptorID) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getSimpleName() + " has no accept mechanism");
    }

    private class ServerDatagramSelectorManager
    extends SelectorManager {
        protected ServerDatagramSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
            super(executor, scheduler, selectors);
        }

        protected EndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey selectionKey) {
            DatagramChannelEndPoint endPoint = new DatagramChannelEndPoint((DatagramChannel)channel, selector, selectionKey, this.getScheduler());
            endPoint.setIdleTimeout(QuicServerConnector.this.getIdleTimeout());
            return endPoint;
        }

        public Connection newConnection(SelectableChannel channel, EndPoint endpoint, Object attachment) {
            ServerQuicConnection connection = new ServerQuicConnection(QuicServerConnector.this, endpoint);
            connection.addEventListener((EventListener)QuicServerConnector.this.container);
            connection.setInputBufferSize(QuicServerConnector.this.getInputBufferSize());
            connection.setOutputBufferSize(QuicServerConnector.this.getOutputBufferSize());
            connection.setUseInputDirectByteBuffers(QuicServerConnector.this.isUseInputDirectByteBuffers());
            connection.setUseOutputDirectByteBuffers(QuicServerConnector.this.isUseOutputDirectByteBuffers());
            return connection;
        }

        protected void endPointOpened(EndPoint endpoint) {
            super.endPointOpened(endpoint);
            QuicServerConnector.this.onEndPointOpened(endpoint);
        }

        protected void endPointClosed(EndPoint endpoint) {
            QuicServerConnector.this.onEndPointClosed(endpoint);
            super.endPointClosed(endpoint);
        }

        private void setIdleTimeout(long idleTimeout) {
            QuicServerConnector.this.getConnectedEndPoints().forEach(endPoint -> endPoint.setIdleTimeout(idleTimeout));
        }
    }
}

