/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.server.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.internal.HTTP3ErrorCode;
import org.eclipse.jetty.http3.server.internal.HTTP3StreamServer;
import org.eclipse.jetty.http3.server.internal.HttpChannelOverHTTP3;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTransportOverHTTP3
implements HttpTransport {
    private static final Logger LOG = LoggerFactory.getLogger(HttpTransportOverHTTP3.class);
    private final AtomicBoolean commit = new AtomicBoolean();
    private final TransportCallback transportCallback = new TransportCallback();
    private final HTTP3StreamServer stream;
    private MetaData.Response metaData;

    public HttpTransportOverHTTP3(HTTP3StreamServer stream) {
        this.stream = stream;
    }

    public void send(MetaData.Request request, MetaData.Response response, ByteBuffer content, boolean lastContent, Callback callback) {
        if (response != null) {
            this.sendHeaders(request, response, content, lastContent, callback);
        } else {
            this.sendContent(request, content, lastContent, callback);
        }
    }

    private void sendHeaders(MetaData.Request request, MetaData.Response response, ByteBuffer content, boolean lastContent, Callback callback) {
        HeadersFrame headersFrame;
        this.metaData = response;
        DataFrame dataFrame = null;
        HeadersFrame trailersFrame = null;
        boolean isHeadRequest = HttpMethod.HEAD.is(request.getMethod());
        boolean hasContent = BufferUtil.hasContent((ByteBuffer)content) && !isHeadRequest;
        int status = response.getStatus();
        if (HttpStatus.isInterim((int)status)) {
            if (hasContent) {
                callback.failed((Throwable)new IllegalStateException("Interim response cannot have content"));
                return;
            }
            headersFrame = new HeadersFrame((MetaData)this.metaData, false);
        } else if (this.commit.compareAndSet(false, true)) {
            if (lastContent) {
                long realContentLength = BufferUtil.length((ByteBuffer)content);
                long contentLength = response.getContentLength();
                if (contentLength < 0L) {
                    this.metaData = new MetaData.Response(response.getHttpVersion(), response.getStatus(), response.getReason(), response.getFields(), realContentLength, response.getTrailerSupplier());
                } else if (hasContent && contentLength != realContentLength) {
                    callback.failed((Throwable)new BadMessageException(500, String.format("Incorrect Content-Length %d!=%d", contentLength, realContentLength)));
                    return;
                }
            }
            if (hasContent) {
                headersFrame = new HeadersFrame((MetaData)this.metaData, false);
                if (lastContent) {
                    HttpFields trailers = this.retrieveTrailers();
                    if (trailers == null) {
                        dataFrame = new DataFrame(content, true);
                    } else {
                        dataFrame = new DataFrame(content, false);
                        trailersFrame = new HeadersFrame(new MetaData(HttpVersion.HTTP_3, trailers), true);
                    }
                } else {
                    dataFrame = new DataFrame(content, false);
                }
            } else if (lastContent) {
                if (this.isTunnel(request, this.metaData)) {
                    headersFrame = new HeadersFrame((MetaData)this.metaData, false);
                } else {
                    HttpFields trailers = this.retrieveTrailers();
                    if (trailers == null) {
                        headersFrame = new HeadersFrame((MetaData)this.metaData, true);
                    } else {
                        headersFrame = new HeadersFrame((MetaData)this.metaData, false);
                        trailersFrame = new HeadersFrame(new MetaData(HttpVersion.HTTP_3, trailers), true);
                    }
                }
            } else {
                headersFrame = new HeadersFrame((MetaData)this.metaData, false);
            }
        } else {
            callback.failed((Throwable)new IllegalStateException("committed"));
            return;
        }
        HeadersFrame hf = headersFrame;
        DataFrame df = dataFrame;
        HeadersFrame tf = trailersFrame;
        this.transportCallback.send(callback, true, c -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP3 Response #{}/{}:{}{} {}{}{}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), System.lineSeparator(), HttpVersion.HTTP_3, this.metaData.getStatus(), System.lineSeparator(), this.metaData.getFields()});
            }
            CompletionStage<Object> cf = this.stream.respond(hf);
            if (df != null) {
                cf = cf.thenCompose(s -> s.data(df));
            }
            if (tf != null) {
                cf = cf.thenCompose(s -> s.trailer(tf));
            }
            c.completeWith(cf);
        });
    }

    private void sendContent(MetaData.Request request, ByteBuffer content, boolean lastContent, Callback callback) {
        boolean hasContent;
        boolean isHeadRequest = HttpMethod.HEAD.is(request.getMethod());
        boolean bl = hasContent = BufferUtil.hasContent((ByteBuffer)content) && !isHeadRequest;
        if (hasContent || lastContent && !this.isTunnel(request, this.metaData)) {
            if (lastContent) {
                HttpFields trailers = this.retrieveTrailers();
                if (trailers == null) {
                    this.transportCallback.send(callback, false, c -> this.sendDataFrame(content, true, true, (Callback)c));
                } else {
                    SendTrailers sendTrailers = new SendTrailers(callback, trailers);
                    if (hasContent) {
                        this.transportCallback.send((Callback)sendTrailers, false, c -> this.sendDataFrame(content, true, false, (Callback)c));
                    } else {
                        sendTrailers.succeeded();
                    }
                }
            } else {
                this.transportCallback.send(callback, false, c -> this.sendDataFrame(content, false, false, (Callback)c));
            }
        } else {
            callback.succeeded();
        }
    }

    private HttpFields retrieveTrailers() {
        Supplier supplier = this.metaData.getTrailerSupplier();
        if (supplier == null) {
            return null;
        }
        HttpFields trailers = (HttpFields)supplier.get();
        if (trailers == null) {
            return null;
        }
        return trailers.size() == 0 ? null : trailers;
    }

    private boolean isTunnel(MetaData.Request request, MetaData.Response response) {
        return MetaData.isTunnel((String)request.getMethod(), (int)response.getStatus());
    }

    public boolean isPushSupported() {
        return false;
    }

    public void push(MetaData.Request request) {
        throw new UnsupportedOperationException();
    }

    public void onCompleted() {
        Object attachment = this.stream.getAttachment();
        if (attachment instanceof HttpChannelOverHTTP3) {
            if (!this.stream.isClosed()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("HTTP3 Response #{}: unconsumed request content, resetting stream", (Object)this.stream.getId());
                }
                this.stream.reset(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), new IOException("unconsumed content"));
            }
            HttpChannelOverHTTP3 channel = (HttpChannelOverHTTP3)((Object)attachment);
            channel.consumeInput();
        }
    }

    boolean onIdleTimeout(Throwable failure) {
        return this.transportCallback.idleTimeout(failure);
    }

    void onFailure(Throwable failure) {
        this.transportCallback.abort(failure);
    }

    public void abort(Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP3 Response #{}/{} aborted", (Object)this.stream.getId(), (Object)Integer.toHexString(this.stream.getSession().hashCode()));
        }
        this.stream.reset(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), failure);
    }

    private void sendDataFrame(ByteBuffer content, boolean lastContent, boolean endStream, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP3 Response #{}/{}: {} content bytes{}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), content.remaining(), lastContent ? " (last chunk)" : ""});
        }
        DataFrame frame = new DataFrame(content, endStream);
        callback.completeWith(this.stream.data(frame));
    }

    private void sendTrailerFrame(MetaData metaData, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP3 Response #{}/{}: trailer", (Object)this.stream.getId(), (Object)Integer.toHexString(this.stream.getSession().hashCode()));
        }
        HeadersFrame frame = new HeadersFrame(metaData, true);
        callback.completeWith(this.stream.trailer(frame));
    }

    private class TransportCallback
    implements Callback {
        private final AutoLock _lock = new AutoLock();
        private State _state = State.IDLE;
        private Callback _callback;
        private boolean _commit;
        private Throwable _failure;

        private TransportCallback() {
        }

        private void reset(Throwable failure) {
            assert (this._lock.isHeldByCurrentThread());
            this._state = failure != null ? State.FAILED : State.IDLE;
            this._callback = null;
            this._commit = false;
            this._failure = failure;
        }

        private void send(Callback callback, boolean commit, Consumer<Callback> sendFrame) {
            Throwable failure = this.sending(callback, commit);
            if (failure == null) {
                sendFrame.accept(this);
            } else {
                callback.failed(failure);
            }
        }

        private void abort(Throwable failure) {
            this.failed(failure);
        }

        private Throwable sending(Callback callback, boolean commit) {
            try (AutoLock l = this._lock.lock();){
                switch (this._state) {
                    case IDLE: {
                        this._state = State.SENDING;
                        this._callback = callback;
                        this._commit = commit;
                        Throwable throwable = null;
                        return throwable;
                    }
                    case FAILED: {
                        Throwable throwable = this._failure;
                        return throwable;
                    }
                }
                IllegalStateException illegalStateException = new IllegalStateException("Invalid transport state: " + this._state);
                return illegalStateException;
            }
        }

        public void succeeded() {
            boolean commit;
            Callback callback;
            try (AutoLock l = this._lock.lock();){
                if (this._state != State.SENDING) {
                    return;
                }
                callback = this._callback;
                commit = this._commit;
                this.reset(null);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP3 Response #{}/{} {} success", new Object[]{HttpTransportOverHTTP3.this.stream.getId(), Integer.toHexString(HttpTransportOverHTTP3.this.stream.getSession().hashCode()), commit ? "commit" : "flush"});
            }
            callback.succeeded();
        }

        public void failed(Throwable failure) {
            boolean commit;
            Callback callback;
            try (AutoLock l = this._lock.lock();){
                if (this._state != State.SENDING) {
                    this.reset(failure);
                    return;
                }
                callback = this._callback;
                commit = this._commit;
                this.reset(failure);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP3 Response #{}/{} {} failure", new Object[]{HttpTransportOverHTTP3.this.stream.getId(), Integer.toHexString(HttpTransportOverHTTP3.this.stream.getSession().hashCode()), commit ? "commit" : "flush", failure});
            }
            callback.failed(failure);
        }

        private boolean idleTimeout(Throwable failure) {
            boolean timeout;
            Callback callback = null;
            try (AutoLock l = this._lock.lock();){
                if (this._state == State.SENDING) {
                    callback = this._callback;
                    this.reset(failure);
                }
            }
            boolean bl = timeout = callback != null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP3 Response #{}/{} idle timeout {}", new Object[]{HttpTransportOverHTTP3.this.stream.getId(), Integer.toHexString(HttpTransportOverHTTP3.this.stream.getSession().hashCode()), timeout ? "expired" : "ignored", failure});
            }
            if (timeout) {
                callback.failed(failure);
            }
            return timeout;
        }

        public Invocable.InvocationType getInvocationType() {
            Callback callback;
            try (AutoLock l = this._lock.lock();){
                callback = this._callback;
            }
            return callback != null ? callback.getInvocationType() : super.getInvocationType();
        }
    }

    private class SendTrailers
    extends Callback.Nested {
        private final HttpFields trailers;

        private SendTrailers(Callback callback, HttpFields trailers) {
            super(callback);
            this.trailers = trailers;
        }

        public void succeeded() {
            HttpTransportOverHTTP3.this.transportCallback.send(this.getCallback(), false, c -> HttpTransportOverHTTP3.this.sendTrailerFrame(new MetaData(HttpVersion.HTTP_3, this.trailers), (Callback)c));
        }
    }

    private static enum State {
        IDLE,
        SENDING,
        FAILED;

    }
}

