/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.jna;

import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.quic.quiche.jna.bool_pointer;
import org.eclipse.jetty.quic.quiche.jna.char_pointer;
import org.eclipse.jetty.quic.quiche.jna.int64_t;
import org.eclipse.jetty.quic.quiche.jna.size_t;
import org.eclipse.jetty.quic.quiche.jna.size_t_pointer;
import org.eclipse.jetty.quic.quiche.jna.sockaddr;
import org.eclipse.jetty.quic.quiche.jna.sockaddr_storage;
import org.eclipse.jetty.quic.quiche.jna.ssize_t;
import org.eclipse.jetty.quic.quiche.jna.timespec;
import org.eclipse.jetty.quic.quiche.jna.uint32_t;
import org.eclipse.jetty.quic.quiche.jna.uint32_t_pointer;
import org.eclipse.jetty.quic.quiche.jna.uint64_t;
import org.eclipse.jetty.quic.quiche.jna.uint64_t_pointer;
import org.eclipse.jetty.quic.quiche.jna.uint8_t;
import org.eclipse.jetty.quic.quiche.jna.uint8_t_pointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LibQuiche
extends Library {
    public static final String EXPECTED_QUICHE_VERSION = "0.18.0";
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final LibQuiche INSTANCE = (LibQuiche)Native.load((String)"quiche", LibQuiche.class, Map.of("string-encoding", CHARSET.name()));

    public String quiche_version();

    public quiche_config quiche_config_new(uint32_t var1);

    public void quiche_config_set_cc_algorithm(quiche_config var1, int var2);

    public int quiche_config_load_cert_chain_from_pem_file(quiche_config var1, String var2);

    public int quiche_config_load_priv_key_from_pem_file(quiche_config var1, String var2);

    public void quiche_config_verify_peer(quiche_config var1, boolean var2);

    public int quiche_config_load_verify_locations_from_file(quiche_config var1, String var2);

    public int quiche_config_set_application_protos(quiche_config var1, byte[] var2, size_t var3);

    public void quiche_config_set_max_idle_timeout(quiche_config var1, uint64_t var2);

    public void quiche_config_set_max_send_udp_payload_size(quiche_config var1, size_t var2);

    public void quiche_config_set_initial_max_data(quiche_config var1, uint64_t var2);

    public void quiche_config_set_initial_max_stream_data_bidi_local(quiche_config var1, uint64_t var2);

    public void quiche_config_set_initial_max_stream_data_bidi_remote(quiche_config var1, uint64_t var2);

    public void quiche_config_set_initial_max_stream_data_uni(quiche_config var1, uint64_t var2);

    public void quiche_config_set_initial_max_streams_bidi(quiche_config var1, uint64_t var2);

    public void quiche_config_set_initial_max_streams_uni(quiche_config var1, uint64_t var2);

    public void quiche_config_set_ack_delay_exponent(quiche_config var1, uint64_t var2);

    public void quiche_config_set_max_ack_delay(quiche_config var1, uint64_t var2);

    public void quiche_config_set_disable_active_migration(quiche_config var1, boolean var2);

    public void quiche_config_set_max_connection_window(quiche_config var1, uint64_t var2);

    public void quiche_config_set_max_stream_window(quiche_config var1, uint64_t var2);

    public void quiche_config_set_active_connection_id_limit(quiche_config var1, uint64_t var2);

    public void quiche_config_set_stateless_reset_token(quiche_config var1, byte[] var2);

    public void quiche_config_free(quiche_config var1);

    public int quiche_enable_debug_logging(LoggingCallback var1, Pointer var2);

    public quiche_conn quiche_connect(String var1, byte[] var2, size_t var3, sockaddr var4, size_t var5, sockaddr var6, size_t var7, quiche_config var8);

    public int quiche_header_info(ByteBuffer var1, size_t var2, size_t var3, uint32_t_pointer var4, uint8_t_pointer var5, byte[] var6, size_t_pointer var7, byte[] var8, size_t_pointer var9, byte[] var10, size_t_pointer var11);

    public boolean quiche_version_is_supported(uint32_t var1);

    public boolean quiche_conn_set_qlog_path(quiche_conn var1, String var2, String var3, String var4);

    public ssize_t quiche_negotiate_version(byte[] var1, size_t var2, byte[] var3, size_t var4, ByteBuffer var5, size_t var6);

    public ssize_t quiche_retry(byte[] var1, size_t var2, byte[] var3, size_t var4, byte[] var5, size_t var6, byte[] var7, size_t var8, uint32_t var9, ByteBuffer var10, size_t var11);

    public quiche_conn quiche_accept(byte[] var1, size_t var2, byte[] var3, size_t var4, sockaddr var5, size_t var6, sockaddr var7, size_t var8, quiche_config var9);

    public uint64_t quiche_conn_timeout_as_millis(quiche_conn var1);

    public void quiche_conn_on_timeout(quiche_conn var1);

    public void quiche_conn_stats(quiche_conn var1, quiche_stats var2);

    public int quiche_conn_path_stats(quiche_conn var1, size_t var2, quiche_path_stats var3);

    public boolean quiche_conn_is_server(quiche_conn var1);

    public ssize_t quiche_conn_send_ack_eliciting(quiche_conn var1);

    public ssize_t quiche_conn_send_ack_eliciting_on_path(quiche_conn var1, sockaddr var2, size_t var3, sockaddr var4, size_t var5);

    public ssize_t quiche_conn_send(quiche_conn var1, ByteBuffer var2, size_t var3, quiche_send_info var4);

    public size_t quiche_conn_send_quantum(quiche_conn var1);

    public ssize_t quiche_conn_recv(quiche_conn var1, ByteBuffer var2, size_t var3, quiche_recv_info var4);

    public void quiche_conn_application_proto(quiche_conn var1, char_pointer var2, size_t_pointer var3);

    public boolean quiche_conn_is_established(quiche_conn var1);

    public boolean quiche_conn_is_in_early_data(quiche_conn var1);

    public boolean quiche_conn_is_draining(quiche_conn var1);

    public boolean quiche_conn_is_closed(quiche_conn var1);

    public boolean quiche_conn_is_timed_out(quiche_conn var1);

    public void quiche_conn_peer_cert(quiche_conn var1, char_pointer var2, size_t_pointer var3);

    public boolean quiche_conn_peer_error(quiche_conn var1, bool_pointer var2, uint64_t_pointer var3, char_pointer var4, size_t_pointer var5);

    public boolean quiche_conn_local_error(quiche_conn var1, bool_pointer var2, uint64_t_pointer var3, char_pointer var4, size_t_pointer var5);

    public int quiche_conn_close(quiche_conn var1, boolean var2, uint64_t var3, String var4, size_t var5);

    public int quiche_conn_stream_priority(quiche_conn var1, uint64_t var2, uint8_t var3, boolean var4);

    public int quiche_conn_stream_shutdown(quiche_conn var1, uint64_t var2, int var3, uint64_t var4);

    public ssize_t quiche_conn_stream_capacity(quiche_conn var1, uint64_t var2);

    public boolean quiche_conn_stream_readable(quiche_conn var1, uint64_t var2);

    public int64_t quiche_conn_stream_readable_next(quiche_conn var1);

    public int quiche_conn_stream_writable(quiche_conn var1, uint64_t var2, size_t var3);

    public int64_t quiche_conn_stream_writable_next(quiche_conn var1);

    public boolean quiche_conn_stream_finished(quiche_conn var1, uint64_t var2);

    public quiche_stream_iter quiche_conn_readable(quiche_conn var1);

    public quiche_stream_iter quiche_conn_writable(quiche_conn var1);

    public boolean quiche_stream_iter_next(quiche_stream_iter var1, uint64_t_pointer var2);

    public void quiche_stream_iter_free(quiche_stream_iter var1);

    public ssize_t quiche_conn_stream_recv(quiche_conn var1, uint64_t var2, ByteBuffer var3, size_t var4, bool_pointer var5);

    public ssize_t quiche_conn_stream_send(quiche_conn var1, uint64_t var2, ByteBuffer var3, size_t var4, boolean var5);

    public void quiche_conn_free(quiche_conn var1);

    public static interface quiche_shutdown {
        public static final int QUICHE_SHUTDOWN_READ = 0;
        public static final int QUICHE_SHUTDOWN_WRITE = 1;
    }

    @Structure.FieldOrder(value={"dummy"})
    public static class quiche_stream_iter
    extends Structure {
        public byte dummy;
    }

    @Structure.FieldOrder(value={"from", "from_len", "to", "to_len"})
    public static class quiche_recv_info
    extends Structure {
        public sockaddr.ByReference from;
        public size_t from_len;
        public sockaddr.ByReference to;
        public size_t to_len;
    }

    @Structure.FieldOrder(value={"from", "from_len", "to", "to_len", "at"})
    public static class quiche_send_info
    extends Structure {
        public sockaddr_storage from;
        public size_t from_len;
        public sockaddr_storage to;
        public size_t to_len;
        public timespec at;
    }

    public static interface packet_type {
        public static final byte INITIAL = 1;
        public static final byte RETRY = 2;
        public static final byte HANDSHAKE = 3;
        public static final byte ZERO_RTT = 4;
        public static final byte SHORT = 5;
        public static final byte VERSION_NEGOTIATION = 6;

        public static String typeToString(byte type) {
            if (type == 1) {
                return "INITIAL";
            }
            if (type == 2) {
                return "RETRY";
            }
            if (type == 3) {
                return "HANDSHAKE";
            }
            if (type == 4) {
                return "ZERO_RTT";
            }
            if (type == 5) {
                return "SHORT";
            }
            if (type == 6) {
                return "VERSION_NEGOTIATION";
            }
            return "?? " + type;
        }
    }

    public static interface LoggingCallback
    extends Callback {
        public void log(String var1, Pointer var2);
    }

    @Structure.FieldOrder(value={"local_addr", "local_addr_len", "peer_addr", "peer_addr_len", "validation_state", "active", "recv", "sent", "lost", "retrans", "rtt", "cwnd", "sent_bytes", "recv_bytes", "lost_bytes", "stream_retrans_bytes", "pmtu", "delivery_rate"})
    public static class quiche_path_stats
    extends Structure {
        public sockaddr_storage local_addr;
        public size_t local_addr_len;
        public sockaddr_storage peer_addr;
        public size_t peer_addr_len;
        public ssize_t validation_state;
        public boolean active;
        public size_t recv;
        public size_t sent;
        public size_t lost;
        public size_t retrans;
        public uint64_t rtt;
        public size_t cwnd;
        public uint64_t sent_bytes;
        public uint64_t recv_bytes;
        public uint64_t lost_bytes;
        public uint64_t stream_retrans_bytes;
        public size_t pmtu;
        public uint64_t delivery_rate;
    }

    @Structure.FieldOrder(value={"recv", "sent", "lost", "retrans", "sent_bytes", "recv_bytes", "lost_bytes", "stream_retrans_bytes", "paths_count", "peer_max_idle_timeout", "peer_max_udp_payload_size", "peer_initial_max_data", "peer_initial_max_stream_data_bidi_local", "peer_initial_max_stream_data_bidi_remote", "peer_initial_max_stream_data_uni", "peer_initial_max_streams_bidi", "peer_initial_max_streams_uni", "peer_ack_delay_exponent", "peer_max_ack_delay", "peer_disable_active_migration", "peer_active_conn_id_limit", "peer_max_datagram_frame_size"})
    public static class quiche_stats
    extends Structure {
        public size_t recv;
        public size_t sent;
        public size_t lost;
        public size_t retrans;
        public uint64_t sent_bytes;
        public uint64_t recv_bytes;
        public uint64_t lost_bytes;
        public uint64_t stream_retrans_bytes;
        public size_t paths_count;
        public uint64_t peer_max_idle_timeout;
        public uint64_t peer_max_udp_payload_size;
        public uint64_t peer_initial_max_data;
        public uint64_t peer_initial_max_stream_data_bidi_local;
        public uint64_t peer_initial_max_stream_data_bidi_remote;
        public uint64_t peer_initial_max_stream_data_uni;
        public uint64_t peer_initial_max_streams_bidi;
        public uint64_t peer_initial_max_streams_uni;
        public uint64_t peer_ack_delay_exponent;
        public uint64_t peer_max_ack_delay;
        public boolean peer_disable_active_migration;
        public uint64_t peer_active_conn_id_limit;
        public ssize_t peer_max_datagram_frame_size;
    }

    @Structure.FieldOrder(value={"dummy"})
    public static class quiche_conn
    extends Structure {
        public byte dummy;
    }

    @Structure.FieldOrder(value={"dummy"})
    public static class quiche_config
    extends Structure {
        public byte dummy;
    }

    public static class Logging {
        private static final Logger LIB_QUICHE_LOG = LoggerFactory.getLogger(LibQuiche.class);
        private static final LoggingCallback LIB_QUICHE_LOGGING_CALLBACK = (msg, argp) -> LIB_QUICHE_LOG.debug(msg);
        private static final AtomicBoolean LOGGING_ENABLED = new AtomicBoolean();

        public static void enable() {
            String quicheVersion = INSTANCE.quiche_version();
            if (!LibQuiche.EXPECTED_QUICHE_VERSION.equals(quicheVersion)) {
                throw new IllegalStateException("native quiche library version [" + quicheVersion + "] does not match expected version [0.18.0]");
            }
            if (LIB_QUICHE_LOG.isDebugEnabled() && LOGGING_ENABLED.compareAndSet(false, true)) {
                INSTANCE.quiche_enable_debug_logging(LIB_QUICHE_LOGGING_CALLBACK, null);
                LIB_QUICHE_LOG.debug("quiche version {}", (Object)quicheVersion);
            }
        }
    }
}

