/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jetty.demos.ExampleUtil;
import org.eclipse.jetty.demos.HelloSessionServlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.session.DefaultSessionCache;
import org.eclipse.jetty.server.session.NullSessionDataStore;
import org.eclipse.jetty.server.session.SessionCache;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;

public class OneServletContextWithSession {
    public static Server createServer(int port, Resource baseResource) {
        Server server = new Server(port);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.setBaseResource(baseResource);
        server.setHandler((Handler)context);
        SessionHandler sessions = context.getSessionHandler();
        DefaultSessionCache cache = new DefaultSessionCache(sessions);
        cache.setSessionDataStore((SessionDataStore)new NullSessionDataStore());
        sessions.setSessionCache((SessionCache)cache);
        context.addServlet(HelloSessionServlet.class, "/");
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Path dir = Paths.get(System.getProperty("user.dir"), new String[0]);
        PathResource baseResource = new PathResource(dir);
        Server server = OneServletContextWithSession.createServer(port, (Resource)baseResource);
        server.start();
        server.dumpStdErr();
        server.join();
    }
}

