/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jetty.demos.ExampleUtil;
import org.eclipse.jetty.demos.HelloHandler;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class ManyConnectors {
    public static Server createServer(int plainPort, int securePort) throws Exception {
        Path keystorePath = Paths.get("src/main/resources/etc/keystore.p12", new String[0]).toAbsolutePath();
        if (!Files.exists(keystorePath, new LinkOption[0])) {
            throw new FileNotFoundException(keystorePath.toString());
        }
        Server server = new Server();
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        httpConfig.setSecurePort(securePort);
        httpConfig.setOutputBufferSize(32768);
        ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        http.setPort(plainPort);
        http.setIdleTimeout(30000L);
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystorePath.toString());
        sslContextFactory.setKeyStorePassword("storepwd");
        HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setStsMaxAge(2000L);
        src.setStsIncludeSubDomains(true);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)src);
        ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
        https.setPort(securePort);
        https.setIdleTimeout(500000L);
        server.setConnectors(new Connector[]{http, https});
        server.setHandler((Handler)new HelloHandler());
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        int securePort = ExampleUtil.getPort(args, "jetty.https.port", 8443);
        Server server = ManyConnectors.createServer(port, securePort);
        server.start();
        server.dumpStdErr();
        server.join();
    }
}

