/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.jasper;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspFactory;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.osgi.boot.JettyBootstrapActivator;
import org.eclipse.jetty.osgi.boot.jasper.JSTLBundleDiscoverer;
import org.eclipse.jetty.osgi.boot.utils.BundleFileLocatorHelper;
import org.eclipse.jetty.osgi.boot.utils.TldBundleDiscoverer;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerTldBundleDiscoverer
implements TldBundleDiscoverer {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerTldBundleDiscoverer.class);
    private static String DEFAULT_JSP_FACTORY_IMPL_CLASS = "org.apache.jasper.runtime.JspFactoryImpl";
    private static String DEFAULT_JSTL_BUNDLE_CLASS = "org.apache.taglibs.standard.tag.rt.core.WhenTag";
    private Bundle jstlBundle = null;

    public URL[] getUrlsForBundlesWithTlds(DeploymentManager deploymentManager, BundleFileLocatorHelper locatorHelper) throws Exception {
        Pattern pattern;
        if (!this.isJspAvailable()) {
            return new URL[0];
        }
        if (this.jstlBundle == null) {
            this.jstlBundle = this.findJstlBundle();
        }
        Bundle[] bundles = FrameworkUtil.getBundle(ContainerTldBundleDiscoverer.class).getBundleContext().getBundles();
        HashSet<URL> urls = new HashSet<URL>();
        String tmp = System.getProperty("org.eclipse.jetty.osgi.tldbundles");
        ArrayList<String> sysNames = new ArrayList<String>();
        if (tmp != null) {
            StringTokenizer tokenizer = new StringTokenizer(tmp, ", \n\r\t", false);
            while (tokenizer.hasMoreTokens()) {
                sysNames.add(tokenizer.nextToken());
            }
        }
        Pattern pattern2 = pattern = (tmp = (String)deploymentManager.getContextAttribute("org.eclipse.jetty.server.webapp.containerIncludeBundlePattern")) == null ? null : Pattern.compile(tmp);
        if (this.jstlBundle != null) {
            if (pattern == null) {
                pattern = Pattern.compile(this.jstlBundle.getSymbolicName());
                deploymentManager.setContextAttribute("org.eclipse.jetty.server.webapp.containerIncludeBundlePattern", (Object)this.jstlBundle.getSymbolicName());
            } else if (!pattern.matcher(this.jstlBundle.getSymbolicName()).matches()) {
                String s = tmp + "|" + this.jstlBundle.getSymbolicName();
                pattern = Pattern.compile(s);
                deploymentManager.setContextAttribute("org.eclipse.jetty.server.webapp.containerIncludeBundlePattern", (Object)s);
            }
        }
        for (Bundle bundle : bundles) {
            if (sysNames.contains(bundle.getSymbolicName())) {
                this.convertBundleLocationToURL(locatorHelper, bundle, urls);
                continue;
            }
            if (pattern == null || !pattern.matcher(bundle.getSymbolicName()).matches()) continue;
            this.convertBundleLocationToURL(locatorHelper, bundle, urls);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public boolean isJspAvailable() {
        try {
            this.getClass().getClassLoader().loadClass("org.apache.jasper.servlet.JspServlet");
        }
        catch (Exception e) {
            LOG.warn("Unable to locate the JspServlet: jsp support unavailable.", (Throwable)e);
            return false;
        }
        return true;
    }

    public void fixJspFactory() {
        try {
            Class<ServletContext> servletContextClass = ServletContext.class;
            JspFactory fact = JspFactory.getDefaultFactory();
            if (fact == null) {
                fact = (JspFactory)JettyBootstrapActivator.class.getClassLoader().loadClass(DEFAULT_JSP_FACTORY_IMPL_CLASS).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                JspFactory.setDefaultFactory((JspFactory)fact);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to set the JspFactory: jsp support incomplete.", (Throwable)e);
        }
    }

    public Bundle findJstlBundle() {
        Class<?> jstlClass = null;
        try {
            jstlClass = JSTLBundleDiscoverer.class.getClassLoader().loadClass(DEFAULT_JSTL_BUNDLE_CLASS);
        }
        catch (ClassNotFoundException e) {
            LOG.info("jstl not on classpath", (Throwable)e);
        }
        if (jstlClass != null) {
            return FrameworkUtil.getBundle(jstlClass);
        }
        return null;
    }

    private void convertBundleLocationToURL(BundleFileLocatorHelper locatorHelper, Bundle bundle, Set<URL> urls) throws Exception {
        File jasperLocation = locatorHelper.getBundleInstallLocation(bundle);
        if (jasperLocation.isDirectory()) {
            for (File f : jasperLocation.listFiles()) {
                if (f.getName().endsWith(".jar") && f.isFile()) {
                    urls.add(f.toURI().toURL());
                    continue;
                }
                if (!f.isDirectory() || !f.getName().equals("lib")) continue;
                for (File f2 : jasperLocation.listFiles()) {
                    if (!f2.getName().endsWith(".jar") || !f2.isFile()) continue;
                    urls.add(f2.toURI().toURL());
                }
            }
            urls.add(jasperLocation.toURI().toURL());
        } else {
            urls.add(jasperLocation.toURI().toURL());
        }
    }
}

