/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.cdi;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.cdi.CdiServletContainerInitializer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.Decorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdiSpiDecorator
implements Decorator {
    private static final Logger LOG = LoggerFactory.getLogger(CdiServletContainerInitializer.class);
    public static final String MODE = "CdiSpiDecorator";
    private final ServletContextHandler _context;
    private final Map<Object, Decorated> _decorated = new HashMap<Object, Decorated>();
    private final MethodHandle _current;
    private final MethodHandle _getBeanManager;
    private final MethodHandle _createAnnotatedType;
    private final MethodHandle _createInjectionTarget;
    private final MethodHandle _createCreationalContext;
    private final MethodHandle _inject;
    private final MethodHandle _dispose;
    private final MethodHandle _release;
    private final Set<String> _undecorated = new HashSet<String>(Collections.singletonList("org.jboss.weld.environment.servlet.Listener"));

    public CdiSpiDecorator(ServletContextHandler context) throws UnsupportedOperationException {
        this._context = context;
        context.setAttribute("org.eclipse.jetty.cdi", (Object)MODE);
        ClassLoader classLoader = this._context.getClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            Class<?> cdiClass = classLoader.loadClass("jakarta.enterprise.inject.spi.CDI");
            Class<?> beanManagerClass = classLoader.loadClass("jakarta.enterprise.inject.spi.BeanManager");
            Class<?> annotatedTypeClass = classLoader.loadClass("jakarta.enterprise.inject.spi.AnnotatedType");
            Class<?> injectionTargetClass = classLoader.loadClass("jakarta.enterprise.inject.spi.InjectionTarget");
            Class<?> creationalContextClass = classLoader.loadClass("jakarta.enterprise.context.spi.CreationalContext");
            Class<?> contextualClass = classLoader.loadClass("jakarta.enterprise.context.spi.Contextual");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            this._current = lookup.findStatic(cdiClass, "current", MethodType.methodType(cdiClass));
            this._getBeanManager = lookup.findVirtual(cdiClass, "getBeanManager", MethodType.methodType(beanManagerClass));
            this._createAnnotatedType = lookup.findVirtual(beanManagerClass, "createAnnotatedType", MethodType.methodType(annotatedTypeClass, Class.class));
            this._createInjectionTarget = lookup.findVirtual(beanManagerClass, "createInjectionTarget", MethodType.methodType(injectionTargetClass, annotatedTypeClass));
            this._createCreationalContext = lookup.findVirtual(beanManagerClass, "createCreationalContext", MethodType.methodType(creationalContextClass, contextualClass));
            this._inject = lookup.findVirtual(injectionTargetClass, "inject", MethodType.methodType(Void.TYPE, Object.class, creationalContextClass));
            this._dispose = lookup.findVirtual(injectionTargetClass, "dispose", MethodType.methodType(Void.TYPE, Object.class));
            this._release = lookup.findVirtual(creationalContextClass, "release", MethodType.methodType(Void.TYPE));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    protected boolean isDecoratable(Class<?> clazz) {
        if (Object.class == clazz) {
            return true;
        }
        if (this.getUndecoratable().contains(clazz.getName())) {
            return false;
        }
        return this.isDecoratable(clazz.getSuperclass());
    }

    public Set<String> getUndecoratable() {
        return this._undecorated;
    }

    public void setUndecoratable(Set<String> classnames) {
        this._undecorated.clear();
        if (classnames != null) {
            this._undecorated.addAll(classnames);
        }
    }

    public void addUndecoratable(String ... classname) {
        this._undecorated.addAll(Arrays.asList(new String[0]));
    }

    public <T> T decorate(T o) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("decorate {} in {}", o, (Object)this._context);
            }
            if (this.isDecoratable(o.getClass())) {
                this._decorated.put(o, new Decorated(o));
            }
        }
        catch (Throwable th) {
            LOG.warn("Unable to decorate {}", o, (Object)th);
        }
        return o;
    }

    public void destroy(Object o) {
        try {
            Decorated decorated = this._decorated.remove(o);
            if (decorated != null) {
                decorated.destroy(o);
            }
        }
        catch (Throwable th) {
            LOG.warn("Unable to destroy {}", o, (Object)th);
        }
    }

    private class Decorated {
        private final Object _injectionTarget;
        private final Object _creationalContext;

        Decorated(Object o) throws Throwable {
            Object manager = CdiSpiDecorator.this._getBeanManager.invoke(CdiSpiDecorator.this._current.invoke());
            Object annotatedType = CdiSpiDecorator.this._createAnnotatedType.invoke(manager, o.getClass());
            this._creationalContext = CdiSpiDecorator.this._createCreationalContext.invoke(manager, null);
            this._injectionTarget = CdiSpiDecorator.this._createInjectionTarget.invoke(manager, annotatedType);
            CdiSpiDecorator.this._inject.invoke(this._injectionTarget, o, this._creationalContext);
        }

        public void destroy(Object o) throws Throwable {
            CdiSpiDecorator.this._dispose.invoke(this._injectionTarget, o);
            CdiSpiDecorator.this._release.invoke(this._creationalContext);
        }
    }
}

