/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.docs.programming.server.websocket;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpoint;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.util.List;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.jakarta.server.config.JakartaWebSocketServletContainerInitializer;
import org.eclipse.jetty.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.websocket.server.JettyWebSocketServerContainer;
import org.eclipse.jetty.websocket.server.JettyWebSocketServlet;
import org.eclipse.jetty.websocket.server.JettyWebSocketServletFactory;
import org.eclipse.jetty.websocket.server.config.JettyWebSocketServletContainerInitializer;

public class WebSocketServerDocs {
    public void standardContainerWebAppContext() throws Exception {
        Server server = new Server(8080);
        WebAppContext handler = new WebAppContext("/path/to/webapp", "/ctx");
        server.setHandler((Handler)handler);
        server.start();
    }

    public void standardContainerServletContextHandler() throws Exception {
        Server server = new Server(8080);
        ServletContextHandler handler = new ServletContextHandler((HandlerContainer)server, "/ctx");
        server.setHandler((Handler)handler);
        JakartaWebSocketServletContainerInitializer.configure((ServletContextHandler)handler, null);
        server.start();
    }

    public void standardEndpointsInitialization() throws Exception {
        Server server = new Server(8080);
        ServletContextHandler handler = new ServletContextHandler((HandlerContainer)server, "/ctx");
        server.setHandler((Handler)handler);
        JakartaWebSocketServletContainerInitializer.configure((ServletContextHandler)handler, null);
        handler.addServlet(MyJavaxWebSocketInitializerServlet.class, "/*");
        server.start();
    }

    public void standardContainerAndEndpoints() throws Exception {
        Server server = new Server(8080);
        ServletContextHandler handler = new ServletContextHandler((HandlerContainer)server, "/ctx");
        server.setHandler((Handler)handler);
        JakartaWebSocketServletContainerInitializer.configure((ServletContextHandler)handler, (servletContext, container) -> {
            container.setDefaultMaxTextMessageBufferSize(131072);
            container.addEndpoint(MyJavaxWebSocketEndPoint.class);
            container.addEndpoint(ServerEndpointConfig.Builder.create(MyJavaxWebSocketEndPoint.class, (String)"/ws").subprotocols(List.of("my-ws-protocol")).build());
        });
        server.start();
    }

    public void jettyContainerServletContextHandler() throws Exception {
        Server server = new Server(8080);
        ServletContextHandler handler = new ServletContextHandler((HandlerContainer)server, "/ctx");
        server.setHandler((Handler)handler);
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)handler, null);
        server.start();
    }

    public void jettyEndpointsInitialization() throws Exception {
        Server server = new Server(8080);
        ServletContextHandler handler = new ServletContextHandler((HandlerContainer)server, "/ctx");
        server.setHandler((Handler)handler);
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)handler, null);
        handler.addServlet(MyJettyWebSocketInitializerServlet.class, "/*");
        server.start();
    }

    public void jettyContainerAndEndpoints() throws Exception {
        Server server = new Server(8080);
        ServletContextHandler handler = new ServletContextHandler((HandlerContainer)server, "/ctx");
        server.setHandler((Handler)handler);
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)handler, (servletContext, container) -> {
            container.setMaxTextMessageSize(131072L);
            container.addMapping("/ws/myURI", MyJettyWebSocketEndPoint.class);
            container.addMapping("/ws/myOtherURI", (upgradeRequest, upgradeResponse) -> {
                upgradeResponse.setAcceptedSubProtocol("my-ws-protocol");
                return new MyOtherJettyWebSocketEndPoint();
            });
        });
        server.start();
    }

    private boolean requiresWebSocketUpgrade(HttpServletRequest request) {
        return false;
    }

    public void jettyWebSocketServletMain() throws Exception {
        Server server = new Server(8080);
        ServletContextHandler handler = new ServletContextHandler((HandlerContainer)server, "/ctx");
        server.setHandler((Handler)handler);
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)handler, null);
        handler.addServlet(MyJettyWebSocketServlet.class, "/ws/*");
        server.start();
    }

    public class MyJavaxWebSocketInitializerServlet
    extends HttpServlet {
        public void init() throws ServletException {
            try {
                ServerContainer container = (ServerContainer)this.getServletContext().getAttribute(ServerContainer.class.getName());
                container.setDefaultMaxTextMessageBufferSize(131072);
                container.addEndpoint(MyJavaxWebSocketEndPoint.class);
                container.addEndpoint(ServerEndpointConfig.Builder.create(MyJavaxWebSocketEndPoint.class, (String)"/ws").subprotocols(List.of("my-ws-protocol")).build());
            }
            catch (DeploymentException x) {
                throw new ServletException((Throwable)x);
            }
        }
    }

    public class MyJettyWebSocketInitializerServlet
    extends HttpServlet {
        public void init() throws ServletException {
            JettyWebSocketServerContainer container = JettyWebSocketServerContainer.getContainer((ServletContext)this.getServletContext());
            container.setMaxTextMessageSize(131072L);
            container.addMapping("/ws/myURI", MyJettyWebSocketEndPoint.class);
            container.addMapping("/ws/myOtherURI", (upgradeRequest, upgradeResponse) -> new MyOtherJettyWebSocketEndPoint());
        }
    }

    public class MyJettyWebSocketServlet
    extends JettyWebSocketServlet {
        protected void configure(JettyWebSocketServletFactory factory) {
            factory.setMaxTextMessageSize(0x100000L);
            factory.addMapping("/ws/someURI", (upgradeRequest, upgradeResponse) -> new MyJettyWebSocketEndPoint());
        }
    }

    @WebSocket
    private static class MyJettyWebSocketEndPoint {
        private MyJettyWebSocketEndPoint() {
        }
    }

    @WebSocket
    private static class MyOtherJettyWebSocketEndPoint {
        private MyOtherJettyWebSocketEndPoint() {
        }
    }

    @ServerEndpoint(value="/ws")
    private static class MyJavaxWebSocketEndPoint {
        private MyJavaxWebSocketEndPoint() {
        }
    }

    public class ProgrammaticWebSocketUpgradeServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            if (WebSocketServerDocs.this.requiresWebSocketUpgrade(request)) {
                JettyWebSocketServerContainer container = JettyWebSocketServerContainer.getContainer((ServletContext)this.getServletContext());
                JettyWebSocketCreator creator = (upgradeRequest, upgradeResponse) -> new MyJettyWebSocketEndPoint();
                container.upgrade(creator, request, response);
            }
        }
    }
}

