/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.start.StartLog;

public class CommandLineBuilder {
    private List<String> args = new ArrayList<String>();

    public static File findExecutable(File root, String path) {
        String npath = path.replace('/', File.separatorChar);
        File exe = new File(root, npath);
        if (!exe.exists()) {
            return null;
        }
        return exe;
    }

    public static String findJavaBin() {
        File javaHome = new File(System.getProperty("java.home"));
        if (!javaHome.exists()) {
            return null;
        }
        File javabin = CommandLineBuilder.findExecutable(javaHome, "bin/java");
        if (javabin != null) {
            return javabin.getAbsolutePath();
        }
        javabin = CommandLineBuilder.findExecutable(javaHome, "bin/java.exe");
        if (javabin != null) {
            return javabin.getAbsolutePath();
        }
        return "java";
    }

    @Deprecated
    public static String quote(String arg) {
        return "'" + arg + "'";
    }

    public CommandLineBuilder() {
    }

    public CommandLineBuilder(String bin) {
        this();
        this.args.add(bin);
    }

    public void addArg(String arg) {
        if (arg != null) {
            this.args.add(arg);
        }
    }

    public void addEqualsArg(String name, String value) {
        if (value != null && value.length() > 0) {
            this.args.add(name + "=" + value);
        } else {
            this.args.add(name);
        }
    }

    public void addRawArg(String arg) {
        if (arg != null) {
            this.args.add(arg);
        }
    }

    public List<String> getArgs() {
        return this.args;
    }

    public String toString() {
        return this.toString(" ");
    }

    public String toString(String delim) {
        StringBuilder buf = new StringBuilder();
        for (String arg : this.args) {
            if (buf.length() > 0) {
                buf.append(delim);
            }
            buf.append(arg);
        }
        return buf.toString();
    }

    public String toQuotedString() {
        StringBuilder buf = new StringBuilder();
        for (String arg : this.args) {
            boolean needsQuotes;
            if (buf.length() > 0) {
                buf.append(' ');
            }
            if (needsQuotes = arg.contains(" ")) {
                buf.append("'");
            }
            buf.append(arg);
            if (!needsQuotes) continue;
            buf.append("'");
        }
        return buf.toString();
    }

    public void debug() {
        if (!StartLog.isDebugEnabled()) {
            return;
        }
        int len = this.args.size();
        StartLog.debug("Command Line: %,d entries", this.args.size());
        for (int i = 0; i < len; ++i) {
            StartLog.debug(" [%d]: \"%s\"", i, this.args.get(i));
        }
    }
}

