/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.internal;

import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http3.qpack.QpackException;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstructionStreamConnection
extends AbstractConnection
implements Connection.UpgradeTo {
    private static final Logger LOG = LoggerFactory.getLogger(InstructionStreamConnection.class);
    private final ByteBufferPool byteBufferPool;
    private boolean useInputDirectByteBuffers = true;
    private ByteBuffer buffer;

    public InstructionStreamConnection(EndPoint endPoint, Executor executor, ByteBufferPool byteBufferPool) {
        super(endPoint, executor);
        this.byteBufferPool = byteBufferPool;
    }

    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public void onUpgradeTo(ByteBuffer upgrade) {
        int capacity = Math.max(upgrade.remaining(), this.getInputBufferSize());
        this.buffer = this.byteBufferPool.acquire(capacity, this.isUseInputDirectByteBuffers());
        int position = BufferUtil.flipToFill((ByteBuffer)this.buffer);
        this.buffer.put(upgrade);
        BufferUtil.flipToFlush((ByteBuffer)this.buffer, (int)position);
    }

    public void onOpen() {
        super.onOpen();
        if (BufferUtil.hasContent((ByteBuffer)this.buffer)) {
            this.onFillable();
        } else {
            this.fillInterested();
        }
    }

    public void onFillable() {
        block6: {
            try {
                int filled;
                if (this.buffer == null) {
                    this.buffer = this.byteBufferPool.acquire(this.getInputBufferSize(), this.isUseInputDirectByteBuffers());
                }
                do {
                    this.parseInstruction(this.buffer);
                    filled = this.getEndPoint().fill(this.buffer);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("filled {} on {}", (Object)filled, (Object)this);
                    }
                    if (filled != 0) continue;
                    this.byteBufferPool.release(this.buffer);
                    this.buffer = null;
                    this.fillInterested();
                    break block6;
                } while (filled >= 0);
                this.byteBufferPool.release(this.buffer);
                this.buffer = null;
                this.getEndPoint().close();
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("could not process decoder stream {}", (Object)this.getEndPoint(), (Object)x);
                }
                this.byteBufferPool.release(this.buffer);
                this.buffer = null;
                this.getEndPoint().close(x);
            }
        }
    }

    protected abstract void parseInstruction(ByteBuffer var1) throws QpackException;
}

