/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import org.eclipse.jetty.quickstart.QuickStartConfiguration;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenQuickStartConfiguration
extends QuickStartConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(QuickStartConfiguration.class);

    public Class<? extends Configuration> replaces() {
        return QuickStartConfiguration.class;
    }

    public void deconfigure(WebAppContext context) throws Exception {
        if (!context.isPersistTempDirectory()) {
            Resource originalBases = (Resource)context.getAttribute("org.eclipse.jetty.resources.originalBases");
            String originalBaseStr = originalBases.toString();
            Resource res = context.getBaseResource();
            if (res instanceof ResourceCollection) {
                for (Resource r : ((ResourceCollection)res).getResources()) {
                    if (originalBaseStr.contains(r.toString())) continue;
                    IO.delete((File)r.getFile());
                }
            }
        }
        super.deconfigure(context);
    }
}

