/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.demos.ExampleUtil;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.LoggerFactory;

public class Http2Server {
    static Servlet servlet = new HttpServlet(){
        private static final long serialVersionUID = 1L;

        protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
            HttpSession session;
            String code = request.getParameter("code");
            if (code != null) {
                response.setStatus(Integer.parseInt(code));
            }
            if ((session = request.getSession(true)).isNew()) {
                response.addCookie(new Cookie("bigcookie", "This is a test cookies that was created on " + new Date() + " and is used by the jetty http/2 test servlet."));
            }
            response.setHeader("Custom", "Value");
            response.setContentType("text/plain");
            String content = "Hello from Jetty using " + request.getProtocol() + "\n";
            content = content + "uri=" + request.getRequestURI() + "\n";
            content = content + "session=" + session.getId() + (session.isNew() ? "(New)\n" : "\n");
            content = content + "date=" + new Date() + "\n";
            content = content + Optional.ofNullable(request.getCookies()).stream().flatMap(Arrays::stream).map(cookie -> String.format("cookie %s=%s", cookie.getName(), cookie.getValue())).collect(Collectors.joining(System.lineSeparator()));
            response.setContentLength(content.length());
            response.getOutputStream().print(content);
        }
    };

    public static void main(String ... args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        int securePort = ExampleUtil.getPort(args, "jetty.https.port", 8443);
        Server server = new Server();
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        server.addBean((Object)mbContainer);
        server.addBean((Object)LoggerFactory.getILoggerFactory());
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/", 1);
        Path docroot = Paths.get("src/main/resources/docroot", new String[0]);
        if (!Files.exists(docroot, new LinkOption[0])) {
            throw new FileNotFoundException(docroot.toString());
        }
        context.setBaseResource((Resource)new PathResource(docroot));
        context.addFilter(PushedTilesFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        context.addServlet(new ServletHolder(servlet), "/test/*");
        context.addServlet(DefaultServlet.class, "/").setInitParameter("maxCacheSize", "81920");
        server.setHandler((Handler)context);
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        httpConfig.setSecurePort(securePort);
        httpConfig.setSendXPoweredBy(true);
        httpConfig.setSendServerVersion(true);
        ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig), new HTTP2CServerConnectionFactory(httpConfig)});
        http.setPort(port);
        server.addConnector((Connector)http);
        Path keystorePath = Paths.get("src/main/resources/etc/keystore.p12", new String[0]).toAbsolutePath();
        if (!Files.exists(keystorePath, new LinkOption[0])) {
            throw new FileNotFoundException(keystorePath.toString());
        }
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystorePath.toString());
        sslContextFactory.setKeyStorePassword("storepwd");
        sslContextFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
        HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        HTTP2ServerConnectionFactory h2 = new HTTP2ServerConnectionFactory(httpsConfig);
        ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
        alpn.setDefaultProtocol(http.getDefaultProtocol());
        SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, alpn.getProtocol());
        ServerConnector http2Connector = new ServerConnector(server, new ConnectionFactory[]{ssl, alpn, h2, new HttpConnectionFactory(httpsConfig)});
        http2Connector.setPort(securePort);
        server.addConnector((Connector)http2Connector);
        server.start();
        server.join();
    }

    public static class PushedTilesFilter
    implements Filter {
        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            Request baseRequest = Request.getBaseRequest((ServletRequest)request);
            if (baseRequest.isPush() && baseRequest.getRequestURI().contains("tiles")) {
                String uri = baseRequest.getRequestURI().replace("tiles", "pushed").substring(baseRequest.getContextPath().length());
                request.getRequestDispatcher(uri).forward(request, response);
                return;
            }
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }
}

