/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.docs;

import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.ast.Document;
import org.asciidoctor.extension.IncludeProcessor;
import org.asciidoctor.extension.PreprocessorReader;
import org.asciidoctor.jruby.extension.spi.ExtensionRegistry;
import org.xml.sax.InputSource;

public class JavadocIncludeExtension
implements ExtensionRegistry {
    public void register(Asciidoctor asciidoctor) {
        asciidoctor.javaExtensionRegistry().includeProcessor(JavadocIncludeProcessor.class);
    }

    public static class JavadocIncludeProcessor
    extends IncludeProcessor {
        private static final Pattern JAVADOC_INITIAL_ASTERISK = Pattern.compile("^\\s*\\*\\s*(.*)$");
        private static final Pattern JAVADOC_INLINE_CODE = Pattern.compile("\\{@code ([^\\}]+)\\}");

        public boolean handles(String target) {
            return "javadoc".equals(target);
        }

        public void process(Document document, PreprocessorReader reader, String target, Map<String, Object> attributes) {
            try {
                Path jettyDocsPath = Path.of((String)document.getAttribute((Object)"project-basedir"), new String[0]);
                Path jettyRoot = jettyDocsPath.resolve("../..").normalize();
                String file = (String)attributes.get("file");
                if (file == null) {
                    throw new IllegalArgumentException("Missing 'file' attribute");
                }
                Path filePath = jettyRoot.resolve(file.trim());
                String xsl = (String)attributes.get("xsl");
                if (xsl == null) {
                    throw new IllegalArgumentException("Missing 'xsl' attribute");
                }
                Path xslPath = jettyDocsPath.resolve(xsl.trim());
                ArrayList<Tag> tagList = new ArrayList<Tag>();
                String tags = (String)attributes.get("tags");
                if (tags != null) {
                    for (String tag2 : tags.split(",")) {
                        boolean exclude = (tag2 = tag2.trim()).startsWith("!");
                        if (exclude) {
                            tag2 = tag2.substring(1);
                        }
                        if (tag2.isEmpty()) {
                            throw new IllegalArgumentException("Invalid tag in 'tags' attribute: " + tags);
                        }
                        tagList.add(new Tag(tag2, exclude));
                    }
                }
                String replace = (String)attributes.get("replace");
                ArrayList<String> contentLines = new ArrayList<String>();
                contentLines.add("<root>");
                Iterator lines = Files.lines(filePath, StandardCharsets.UTF_8).iterator();
                ArrayDeque<Tag> tagStack = new ArrayDeque<Tag>();
                while (lines.hasNext()) {
                    boolean keepLine;
                    String line = (String)lines.next();
                    Matcher matcher = JAVADOC_INITIAL_ASTERISK.matcher(line);
                    if (matcher.matches()) {
                        line = matcher.group(1);
                    }
                    line = JAVADOC_INLINE_CODE.matcher(line).replaceAll("<code>$1</code>");
                    boolean bl = keepLine = tagList.isEmpty() || tagList.stream().allMatch(tag -> tag.exclude);
                    if (tagStack.isEmpty()) {
                        for (Tag tag3 : tagList) {
                            if (!line.contains("tag::" + tag3.name)) continue;
                            tagStack.push(tag3);
                        }
                    } else {
                        Tag currentTag = (Tag)tagStack.peek();
                        boolean bl2 = keepLine = !currentTag.exclude;
                        if (line.contains("end::" + currentTag.name)) {
                            tagStack.pop();
                            keepLine = false;
                        }
                    }
                    if (!keepLine) continue;
                    if (replace == null) {
                        contentLines.add(line);
                        continue;
                    }
                    contentLines.addAll(this.replace(line, replace));
                }
                contentLines.add("</root>");
                String content = String.join((CharSequence)"\n", contentLines);
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                org.w3c.dom.Document xml = builder.parse(new InputSource(new StringReader(content)));
                Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xslPath.toFile()));
                StringWriter output = new StringWriter(content.length());
                transformer.transform(new DOMSource(xml), new StreamResult(output));
                String asciidoc = output.toString();
                asciidoc = Arrays.stream(asciidoc.split("\n")).map(String::stripLeading).collect(Collectors.joining("\n"));
                reader.pushInclude(asciidoc, "javadoc", target, 1, attributes);
            }
            catch (Throwable x) {
                reader.pushInclude(x.toString(), "javadoc", target, 1, attributes);
                x.printStackTrace();
            }
        }

        private List<String> replace(String line, String replace) {
            String[] parts = replace.split(",");
            String regExp = parts[0];
            String replacement = parts[1].replace("\\n", "\n");
            return List.of(line.replaceAll(regExp, replacement).split("\n"));
        }

        private static class Tag {
            private final String name;
            private final boolean exclude;

            private Tag(String name, boolean exclude) {
                this.name = name;
                this.exclude = exclude;
            }
        }
    }
}

