/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.demos.ExampleUtil;
import org.eclipse.jetty.demos.JettyDemos;
import org.eclipse.jetty.deploy.AppLifeCycle;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.ConfigurationManager;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.PropertiesConfigurationManager;
import org.eclipse.jetty.deploy.bindings.DebugListenerBinding;
import org.eclipse.jetty.deploy.providers.WebAppProvider;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.rewrite.handler.ValidUrlRule;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.server.AsyncRequestLogWriter;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.DebugListener;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LowResourceMonitor;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.Configurations;

public class LikeJettyXml {
    public static Server createServer(int port, int securePort, boolean addDebugListener) throws Exception {
        Path configDir = Paths.get("src/main/resources/demo", new String[0]).toAbsolutePath();
        Path runtimeDir = Paths.get("target/embedded/" + LikeJettyXml.class.getSimpleName(), new String[0]).toAbsolutePath();
        LikeJettyXml.mkdir(runtimeDir);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(500);
        Server server = new Server((ThreadPool)threadPool);
        server.addBean((Object)new ScheduledExecutorScheduler(null, false));
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        httpConfig.setSecurePort(securePort);
        httpConfig.setOutputBufferSize(32768);
        httpConfig.setRequestHeaderSize(8192);
        httpConfig.setResponseHeaderSize(8192);
        httpConfig.setSendServerVersion(true);
        httpConfig.setSendDateHeader(false);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)new HandlerList(new Handler[]{contexts, new DefaultHandler()}));
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        server.addBean((Object)mbContainer);
        ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        http.setPort(port);
        http.setIdleTimeout(30000L);
        server.addConnector((Connector)http);
        Path keystorePath = Paths.get("src/main/resources/etc/keystore.p12", new String[0]).toAbsolutePath();
        if (!Files.exists(keystorePath, new LinkOption[0])) {
            throw new FileNotFoundException(keystorePath.toString());
        }
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystorePath.toString());
        sslContextFactory.setKeyStorePassword("storepwd");
        sslContextFactory.setTrustStorePath(keystorePath.toString());
        sslContextFactory.setTrustStorePassword("storepwd");
        HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
        sslConnector.setPort(securePort);
        server.addConnector((Connector)sslConnector);
        DeploymentManager deployer = new DeploymentManager();
        if (addDebugListener) {
            DebugListener debug = new DebugListener((OutputStream)System.err, true, true, true);
            server.addBean((Object)debug);
            deployer.addLifeCycleBinding((AppLifeCycle.Binding)new DebugListenerBinding(debug));
        }
        deployer.setContexts(contexts);
        deployer.setContextAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/jetty-jakarta-servlet-api-[^/]*\\.jar$|.*/jakarta.servlet.jsp.jstl-.*\\.jar$|.*/[^/]*taglibs.*\\.jar$");
        Path webappsDir = runtimeDir.resolve("webapps");
        LikeJettyXml.mkdir(webappsDir);
        Path testWebapp = webappsDir.resolve("test.war");
        if (!Files.exists(testWebapp, new LinkOption[0])) {
            Path testWebappSrc = JettyDemos.find("demo-simple-webapp/target/demo-simple-webapp-@VER@.war");
            Files.copy(testWebappSrc, testWebapp, new CopyOption[0]);
        }
        WebAppProvider webAppProvider = new WebAppProvider();
        webAppProvider.setMonitoredDirName(webappsDir.toString());
        webAppProvider.setDefaultsDescriptor(configDir.resolve("webdefault.xml").toString());
        webAppProvider.setScanInterval(1);
        webAppProvider.setExtractWars(true);
        webAppProvider.setConfigurationManager((ConfigurationManager)new PropertiesConfigurationManager());
        deployer.addAppProvider((AppProvider)webAppProvider);
        server.addBean((Object)deployer);
        Configurations.setServerDefault((Server)server).add(new Configuration[]{new EnvConfiguration(), new PlusConfiguration(), new AnnotationConfiguration()});
        StatisticsHandler stats = new StatisticsHandler();
        stats.setHandler(server.getHandler());
        server.setHandler((Handler)stats);
        server.addBeanToAllConnectors((Object)new ConnectionStatistics());
        RewriteHandler rewrite = new RewriteHandler();
        rewrite.setHandler(server.getHandler());
        server.setHandler((Handler)rewrite);
        rewrite.addRule((Rule)new ValidUrlRule());
        Path logsDir = runtimeDir.resolve("logs");
        LikeJettyXml.mkdir(logsDir);
        AsyncRequestLogWriter logWriter = new AsyncRequestLogWriter(logsDir.resolve("yyyy_mm_dd.request.log").toString());
        logWriter.setFilenameDateFormat("yyyy_MM_dd");
        logWriter.setRetainDays(90);
        logWriter.setTimeZone("GMT");
        CustomRequestLog requestLog = new CustomRequestLog((RequestLog.Writer)logWriter, "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\" \"%C\"");
        server.setRequestLog((RequestLog)requestLog);
        LowResourceMonitor lowResourcesMonitor = new LowResourceMonitor(server);
        lowResourcesMonitor.setPeriod(1000);
        lowResourcesMonitor.setLowResourcesIdleTimeout(200);
        lowResourcesMonitor.setMonitorThreads(true);
        lowResourcesMonitor.setMaxMemory(0L);
        lowResourcesMonitor.setMaxLowResourcesTime(5000);
        server.addBean((Object)lowResourcesMonitor);
        HashLoginService login = new HashLoginService();
        login.setName("Test Realm");
        login.setConfig(configDir.resolve("demo-realm.properties").toString());
        login.setHotReload(false);
        server.addBean((Object)login);
        return server;
    }

    private static void mkdir(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.createDirectories(path, new FileAttribute[0]);
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        int securePort = ExampleUtil.getPort(args, "jetty.https.port", 8443);
        Server server = LikeJettyXml.createServer(port, securePort, true);
        server.setDumpAfterStart(true);
        server.setDumpBeforeStop(false);
        server.setStopAtShutdown(true);
        server.start();
        server.join();
    }
}

