/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

public class Version
implements Comparable<Version> {
    private String string = null;
    private String shortString = null;
    private int legacyMajor = 0;
    private int major = -1;
    private int revision = -1;
    private int update = -1;
    private String updateString = null;
    private String suffix = "";

    public Version(String versionString) {
        this.parse(versionString);
    }

    @Override
    public int compareTo(Version other) {
        if (other == null) {
            throw new NullPointerException("other version is null");
        }
        if (this.legacyMajor < other.legacyMajor) {
            return -1;
        }
        if (this.legacyMajor > other.legacyMajor) {
            return 1;
        }
        if (this.major < other.major) {
            return -1;
        }
        if (this.major > other.major) {
            return 1;
        }
        if (this.revision < other.revision) {
            return -1;
        }
        if (this.revision > other.revision) {
            return 1;
        }
        if (this.update < other.update) {
            return -1;
        }
        if (this.update > other.update) {
            return 1;
        }
        return 0;
    }

    public int getLegacyMajor() {
        return this.legacyMajor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getRevision() {
        return this.revision;
    }

    public int getUpdate() {
        return this.update;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean isNewerThan(Version other) {
        return this.compareTo(other) == 1;
    }

    public boolean isNewerThanOrEqualTo(Version other) {
        int comp = this.compareTo(other);
        return comp == 0 || comp == 1;
    }

    public boolean isOlderThan(Version other) {
        return this.compareTo(other) == -1;
    }

    public boolean isOlderThanOrEqualTo(Version other) {
        int comp = this.compareTo(other);
        return comp == 0 || comp == -1;
    }

    public boolean isInRange(Version low, Version high) {
        return this.compareTo(low) >= 0 && this.compareTo(high) <= 0;
    }

    private void parse(String versionStr) {
        this.string = versionStr;
        this.legacyMajor = 0;
        this.major = -1;
        this.revision = -1;
        this.update = -1;
        this.suffix = "";
        ParseState state = ParseState.LEGACY;
        int len = versionStr.length();
        int val = 0;
        block6: for (int offset = 0; offset < len; ++offset) {
            boolean isSeparator;
            char c = versionStr.charAt(offset);
            if (c == '-') {
                this.shortString = versionStr.substring(0, offset);
            }
            boolean bl = isSeparator = !Character.isLetterOrDigit(c);
            if (isSeparator) {
                val = 0;
            } else if (Character.isDigit(c)) {
                val = val * 10 + (c - 48);
            } else if (Character.isLetter(c)) {
                this.suffix = versionStr.substring(offset);
                break;
            }
            switch (state.ordinal()) {
                case 0: {
                    if (isSeparator) {
                        state = ParseState.MAJOR;
                        continue block6;
                    }
                    this.legacyMajor = val;
                    continue block6;
                }
                case 1: {
                    if (isSeparator) {
                        state = ParseState.REVISION;
                        continue block6;
                    }
                    this.major = val;
                    continue block6;
                }
                case 2: {
                    if (isSeparator) {
                        state = ParseState.UPDATE;
                        continue block6;
                    }
                    this.revision = val;
                    continue block6;
                }
                case 3: {
                    if (isSeparator) continue block6;
                    this.update = val;
                    continue block6;
                }
                default: {
                    throw new IllegalStateException(state.toString());
                }
            }
        }
        if (this.shortString == null) {
            this.shortString = versionStr;
        }
    }

    public String toString() {
        return this.string;
    }

    public String toShortString() {
        return this.shortString;
    }

    private static enum ParseState {
        LEGACY,
        MAJOR,
        REVISION,
        UPDATE;

    }
}

