/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.image.attributes.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.commonmark.ext.image.attributes.ImageAttributes;
import org.commonmark.node.Image;
import org.commonmark.node.Node;
import org.commonmark.node.Text;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.commonmark.parser.delimiter.DelimiterRun;

public class ImageAttributesDelimiterProcessor
implements DelimiterProcessor {
    private static final Set<String> SUPPORTED_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("width", "height")));

    public char getOpeningCharacter() {
        return '{';
    }

    public char getClosingCharacter() {
        return '}';
    }

    public int getMinLength() {
        return 1;
    }

    public int getDelimiterUse(DelimiterRun opener, DelimiterRun closer) {
        return 1;
    }

    public void process(Text opener, Text closer, int delimiterCount) {
        if (opener.getPrevious() instanceof Image) {
            boolean canApply = true;
            ArrayList<Node> toUnlink = new ArrayList<Node>();
            LinkedHashMap<String, String> attributesMap = new LinkedHashMap<String, String>();
            Node tmp = opener.getNext();
            while (tmp != null && tmp != closer) {
                Node next = tmp.getNext();
                if (!(tmp instanceof Text)) {
                    canApply = false;
                    break;
                }
                String attributes = ((Text)tmp).getLiteral();
                for (String s : attributes.split("\\s+")) {
                    String[] attribute = s.split("=");
                    if (attribute.length <= 1 || !SUPPORTED_ATTRIBUTES.contains(attribute[0].toLowerCase())) {
                        canApply = false;
                        break;
                    }
                    attributesMap.put(attribute[0], attribute[1]);
                    toUnlink.add(tmp);
                }
                tmp = next;
            }
            if (canApply) {
                for (Node node : toUnlink) {
                    node.unlink();
                }
                if (attributesMap.size() > 0) {
                    ImageAttributes imageAttributes = new ImageAttributes(attributesMap);
                    Node nodeToStyle = opener.getPrevious();
                    nodeToStyle.appendChild((Node)imageAttributes);
                }
                return;
            }
        }
        if (opener.getPrevious() == null) {
            opener.getParent().prependChild((Node)new Text("" + this.getOpeningCharacter()));
        } else {
            opener.getPrevious().insertAfter((Node)new Text("" + this.getOpeningCharacter()));
        }
        closer.getParent().appendChild((Node)new Text("" + this.getClosingCharacter()));
    }
}

