/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.sites;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.Link;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="atom", nsUri="http://www.w3.org/2005/Atom", localName="link")
public class SitesLink
extends Link {
    static final String XML_NAME = "link";
    private static final String COUNT = "thr:count";
    private static final String UPDATED = "thr:updated";
    private Integer count = null;
    private DateTime updated = null;

    public SitesLink() {
    }

    public SitesLink(Integer count, String href, String hrefLang, Long length, String rel, String title, String titleLang, String type, DateTime updated) {
        this.setCount(count);
        this.setUpdated(updated);
        this.setImmutable(true);
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.throwExceptionIfImmutable();
        this.count = count;
    }

    public boolean hasCount() {
        return this.getCount() != null;
    }

    public DateTime getUpdated() {
        return this.updated;
    }

    public void setUpdated(DateTime updated) {
        this.throwExceptionIfImmutable();
        this.updated = updated;
    }

    public boolean hasUpdated() {
        return this.getUpdated() != null;
    }

    protected void validate() {
        if (this.count != null && this.count < 0) {
            throw new IllegalStateException("thr:count attribute must be non-negative: " + this.count);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(SitesLink.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(COUNT, this.count);
        generator.put(UPDATED, this.updated);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.count = helper.consumeInteger("count", false);
        this.updated = helper.consumeDateTime("updated", false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        SitesLink other = (SitesLink)obj;
        return SitesLink.eq(this.count, other.count) && SitesLink.eq(this.updated, other.updated);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.count != null) {
            result = 37 * result + this.count.hashCode();
        }
        if (this.updated != null) {
            result = 37 * result + this.updated.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{SitesLink count=" + this.count + " updated=" + this.updated + " " + super.toString() + "}";
    }

    public static final class Type {
        public static final String APPLICATION_XHTML_XML = "application/xhtml+xml";
    }

    public static final class Rel {
        public static final String ATTACHMENTS = "http://schemas.google.com/sites/2008#attachments";
        public static final String CURRENT = "http://schemas.google.com/sites/2008#current";
        public static final String INVITE = "http://schemas.google.com/sites/2008#invite";
        public static final String PARENT = "http://schemas.google.com/sites/2008#parent";
        public static final String REPLIES = "replies";
        public static final String REVISION = "http://schemas.google.com/sites/2008#revision";
        public static final String SOURCE = "http://schemas.google.com/sites/2008#source";
        public static final String TEMPLATE = "http://schemas.google.com/sites/2008#template";
        public static final String WEBADDRESSMAPPING = "http://schemas.google.com/sites/2008#webAddressMapping";
    }
}

