/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.webmastertools;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.webmastertools.CrawlIssueCrawlType;
import com.google.gdata.data.webmastertools.CrawlIssueDateDetected;
import com.google.gdata.data.webmastertools.CrawlIssueDetail;
import com.google.gdata.data.webmastertools.CrawlIssueIssueType;
import com.google.gdata.data.webmastertools.CrawlIssueLinkedFromUrl;
import com.google.gdata.data.webmastertools.CrawlIssueUrl;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://schemas.google.com/webmasters/tools/2007#crawl_issue_entry")
public class CrawlIssueEntry
extends BaseEntry<CrawlIssueEntry> {
    public static final String KIND = "http://schemas.google.com/webmasters/tools/2007#crawl_issue_entry";
    public static final Category CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/webmasters/tools/2007#crawl_issue_entry");

    public CrawlIssueEntry() {
        this.getCategories().add(CATEGORY);
    }

    public CrawlIssueEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(CrawlIssueEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(CrawlIssueEntry.class, CrawlIssueCrawlType.getDefaultDescription(true, false));
        extProfile.declare(CrawlIssueEntry.class, CrawlIssueDateDetected.class);
        extProfile.declare(CrawlIssueEntry.class, CrawlIssueDetail.class);
        extProfile.declare(CrawlIssueEntry.class, CrawlIssueIssueType.getDefaultDescription(true, false));
        extProfile.declare(CrawlIssueEntry.class, CrawlIssueLinkedFromUrl.getDefaultDescription(false, true));
        extProfile.declare(CrawlIssueEntry.class, CrawlIssueUrl.getDefaultDescription(true, false));
    }

    public CrawlIssueCrawlType getCrawlType() {
        return this.getExtension(CrawlIssueCrawlType.class);
    }

    public void setCrawlType(CrawlIssueCrawlType crawlType) {
        if (crawlType == null) {
            this.removeExtension(CrawlIssueCrawlType.class);
        } else {
            this.setExtension(crawlType);
        }
    }

    public boolean hasCrawlType() {
        return this.hasExtension(CrawlIssueCrawlType.class);
    }

    public CrawlIssueDateDetected getDateDetected() {
        return this.getExtension(CrawlIssueDateDetected.class);
    }

    public void setDateDetected(CrawlIssueDateDetected dateDetected) {
        if (dateDetected == null) {
            this.removeExtension(CrawlIssueDateDetected.class);
        } else {
            this.setExtension(dateDetected);
        }
    }

    public boolean hasDateDetected() {
        return this.hasExtension(CrawlIssueDateDetected.class);
    }

    public CrawlIssueDetail getDetail() {
        return this.getExtension(CrawlIssueDetail.class);
    }

    public void setDetail(CrawlIssueDetail detail) {
        if (detail == null) {
            this.removeExtension(CrawlIssueDetail.class);
        } else {
            this.setExtension(detail);
        }
    }

    public boolean hasDetail() {
        return this.hasExtension(CrawlIssueDetail.class);
    }

    public CrawlIssueIssueType getIssueType() {
        return this.getExtension(CrawlIssueIssueType.class);
    }

    public void setIssueType(CrawlIssueIssueType issueType) {
        if (issueType == null) {
            this.removeExtension(CrawlIssueIssueType.class);
        } else {
            this.setExtension(issueType);
        }
    }

    public boolean hasIssueType() {
        return this.hasExtension(CrawlIssueIssueType.class);
    }

    public List<CrawlIssueLinkedFromUrl> getLinkedFroms() {
        return this.getRepeatingExtension(CrawlIssueLinkedFromUrl.class);
    }

    public void addLinkedFrom(CrawlIssueLinkedFromUrl linkedFrom) {
        this.getLinkedFroms().add(linkedFrom);
    }

    public boolean hasLinkedFroms() {
        return this.hasRepeatingExtension(CrawlIssueLinkedFromUrl.class);
    }

    public CrawlIssueUrl getUrl() {
        return this.getExtension(CrawlIssueUrl.class);
    }

    public void setUrl(CrawlIssueUrl url) {
        if (url == null) {
            this.removeExtension(CrawlIssueUrl.class);
        } else {
            this.setExtension(url);
        }
    }

    public boolean hasUrl() {
        return this.hasExtension(CrawlIssueUrl.class);
    }

    @Override
    protected void validate() {
    }

    public String toString() {
        return "{CrawlIssueEntry " + super.toString() + "}";
    }
}

