/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.Assert;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.GraphqlErrorHelper;
import graphql.PublicApi;
import graphql.execution.ExecutionPath;
import graphql.introspection.Introspection;
import graphql.language.SourceLocation;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@PublicApi
public class TypeMismatchError
implements GraphQLError {
    private final String message;
    private final List<Object> path;
    private final GraphQLType expectedType;

    public TypeMismatchError(ExecutionPath path, GraphQLType expectedType) {
        this.path = Assert.assertNotNull(path).toList();
        this.expectedType = Assert.assertNotNull(expectedType);
        this.message = this.mkMessage(path, expectedType);
    }

    private String mkMessage(ExecutionPath path, GraphQLType expectedType) {
        String expectedTypeKind = GraphQLTypeToTypeKindMapping.getTypeKindFromGraphQLType(expectedType).name();
        return String.format("Can't resolve value (%s) : type mismatch error, expected type %s", path, expectedTypeKind);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public List<SourceLocation> getLocations() {
        return null;
    }

    @Override
    public ErrorType getErrorType() {
        return ErrorType.DataFetchingException;
    }

    @Override
    public List<Object> getPath() {
        return this.path;
    }

    public String toString() {
        return "TypeMismatchError{path=" + this.path + "expectedType=" + this.expectedType + '}';
    }

    public boolean equals(Object o) {
        return GraphqlErrorHelper.equals(this, o);
    }

    public int hashCode() {
        return GraphqlErrorHelper.hashCode(this);
    }

    static class GraphQLTypeToTypeKindMapping {
        private static final Map<Class<? extends GraphQLType>, Introspection.TypeKind> registry = new HashMap<Class<? extends GraphQLType>, Introspection.TypeKind>(){
            {
                this.put(GraphQLEnumType.class, Introspection.TypeKind.ENUM);
                this.put(GraphQLList.class, Introspection.TypeKind.LIST);
                this.put(GraphQLObjectType.class, Introspection.TypeKind.OBJECT);
                this.put(GraphQLScalarType.class, Introspection.TypeKind.SCALAR);
                this.put(GraphQLInputObjectType.class, Introspection.TypeKind.INPUT_OBJECT);
                this.put(GraphQLInterfaceType.class, Introspection.TypeKind.INTERFACE);
                this.put(GraphQLNonNull.class, Introspection.TypeKind.NON_NULL);
                this.put(GraphQLUnionType.class, Introspection.TypeKind.UNION);
            }
        };

        private GraphQLTypeToTypeKindMapping() {
        }

        public static Introspection.TypeKind getTypeKindFromGraphQLType(GraphQLType type) {
            return registry.containsKey(type.getClass()) ? registry.get(type.getClass()) : (Introspection.TypeKind)((Object)Assert.assertShouldNeverHappen("Unknown kind of type: " + type, new Object[0]));
        }
    }
}

