/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.Assert;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.GraphqlErrorHelper;
import graphql.PublicApi;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.UnresolvedTypeException;
import graphql.language.SourceLocation;
import java.util.List;

@PublicApi
public class UnresolvedTypeError
implements GraphQLError {
    private final String message;
    private final List<Object> path;
    private final UnresolvedTypeException exception;

    public UnresolvedTypeError(ExecutionPath path, ExecutionStepInfo info, UnresolvedTypeException exception) {
        this.path = Assert.assertNotNull(path).toList();
        this.exception = Assert.assertNotNull(exception);
        this.message = this.mkMessage(path, exception, Assert.assertNotNull(info));
    }

    private String mkMessage(ExecutionPath path, UnresolvedTypeException exception, ExecutionStepInfo info) {
        return String.format("Can't resolve '%s'. Abstract type '%s' must resolve to an Object type at runtime for field '%s.%s'. %s", path, exception.getInterfaceOrUnionType().getName(), info.getParent().getUnwrappedNonNullType().getName(), info.getFieldDefinition().getName(), exception.getMessage());
    }

    public UnresolvedTypeException getException() {
        return this.exception;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public List<SourceLocation> getLocations() {
        return null;
    }

    @Override
    public ErrorType getErrorType() {
        return ErrorType.DataFetchingException;
    }

    @Override
    public List<Object> getPath() {
        return this.path;
    }

    public String toString() {
        return "UnresolvedTypeError{path=" + this.path + "exception=" + this.exception + '}';
    }

    public boolean equals(Object o) {
        return GraphqlErrorHelper.equals(this, o);
    }

    public int hashCode() {
        return GraphqlErrorHelper.hashCode(this);
    }
}

