/*
 * Decompiled with CFR 0.152.
 */
package graphql.analysis;

import graphql.Assert;
import graphql.PublicApi;
import graphql.analysis.FieldComplexityCalculator;
import graphql.analysis.FieldComplexityEnvironment;
import graphql.analysis.QueryTraversal;
import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.analysis.QueryVisitorStub;
import graphql.execution.AbortExecutionException;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.validation.ValidationError;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@PublicApi
public class MaxQueryComplexityInstrumentation
extends SimpleInstrumentation {
    private final int maxComplexity;
    private final FieldComplexityCalculator fieldComplexityCalculator;

    public MaxQueryComplexityInstrumentation(int maxComplexity) {
        this(maxComplexity, (env, childComplexity) -> 1 + childComplexity);
    }

    public MaxQueryComplexityInstrumentation(int maxComplexity, FieldComplexityCalculator fieldComplexityCalculator) {
        this.maxComplexity = maxComplexity;
        this.fieldComplexityCalculator = Assert.assertNotNull(fieldComplexityCalculator, "calculator can't be null", new Object[0]);
    }

    @Override
    public InstrumentationContext<List<ValidationError>> beginValidation(InstrumentationValidationParameters parameters) {
        return SimpleInstrumentationContext.whenCompleted((errors, throwable) -> {
            if (errors != null && errors.size() > 0 || throwable != null) {
                return;
            }
            QueryTraversal queryTraversal = this.newQueryTraversal(parameters);
            final LinkedHashMap valuesByParent = new LinkedHashMap();
            queryTraversal.visitPostOrder(new QueryVisitorStub(){

                @Override
                public void visitField(QueryVisitorFieldEnvironment env) {
                    int childsComplexity = 0;
                    if (valuesByParent.containsKey(env)) {
                        childsComplexity = ((List)valuesByParent.get(env)).stream().mapToInt(Integer::intValue).sum();
                    }
                    int value = MaxQueryComplexityInstrumentation.this.calculateComplexity(env, childsComplexity);
                    valuesByParent.putIfAbsent(env.getParentEnvironment(), new ArrayList());
                    ((List)valuesByParent.get(env.getParentEnvironment())).add(value);
                }
            });
            int totalComplexity = ((List)valuesByParent.get(null)).stream().mapToInt(Integer::intValue).sum();
            if (totalComplexity > this.maxComplexity) {
                throw this.mkAbortException(totalComplexity, this.maxComplexity);
            }
        });
    }

    protected AbortExecutionException mkAbortException(int totalComplexity, int maxComplexity) {
        return new AbortExecutionException("maximum query complexity exceeded " + totalComplexity + " > " + maxComplexity);
    }

    QueryTraversal newQueryTraversal(InstrumentationValidationParameters parameters) {
        return QueryTraversal.newQueryTraversal().schema(parameters.getSchema()).document(parameters.getDocument()).operationName(parameters.getOperation()).variables(parameters.getVariables()).build();
    }

    private int calculateComplexity(QueryVisitorFieldEnvironment queryVisitorFieldEnvironment, int childsComplexity) {
        if (queryVisitorFieldEnvironment.isTypeNameIntrospectionField()) {
            return 0;
        }
        FieldComplexityEnvironment fieldComplexityEnvironment = this.convertEnv(queryVisitorFieldEnvironment);
        return this.fieldComplexityCalculator.calculate(fieldComplexityEnvironment, childsComplexity);
    }

    private FieldComplexityEnvironment convertEnv(QueryVisitorFieldEnvironment queryVisitorFieldEnvironment) {
        FieldComplexityEnvironment parentEnv = null;
        if (queryVisitorFieldEnvironment.getParentEnvironment() != null) {
            parentEnv = this.convertEnv(queryVisitorFieldEnvironment.getParentEnvironment());
        }
        return new FieldComplexityEnvironment(queryVisitorFieldEnvironment.getField(), queryVisitorFieldEnvironment.getFieldDefinition(), queryVisitorFieldEnvironment.getFieldsContainer(), queryVisitorFieldEnvironment.getArguments(), parentEnv);
    }
}

