/*
 * Decompiled with CFR 0.152.
 */
package graphql.analysis;

import graphql.Assert;
import graphql.PublicApi;
import graphql.analysis.ChildrenOfSelectionProvider;
import graphql.analysis.QueryReducer;
import graphql.analysis.QueryTraversalContext;
import graphql.analysis.QueryVisitor;
import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.analysis.QueryVisitorFieldEnvironmentImpl;
import graphql.analysis.QueryVisitorFragmentSpreadEnvironmentImpl;
import graphql.analysis.QueryVisitorInlineFragmentEnvironmentImpl;
import graphql.analysis.QueryVisitorStub;
import graphql.execution.ConditionalNodes;
import graphql.execution.ValuesResolver;
import graphql.introspection.Introspection;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.NodeTraverser;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.NodeVisitorStub;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.TypeName;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@PublicApi
public class QueryTraversal {
    private final Collection<? extends Node> roots;
    private final GraphQLSchema schema;
    private final Map<String, FragmentDefinition> fragmentsByName;
    private final Map<String, Object> variables;
    private final ConditionalNodes conditionalNodes = new ConditionalNodes();
    private final ValuesResolver valuesResolver = new ValuesResolver();
    private final ChildrenOfSelectionProvider childrenOfSelectionProvider;
    private final GraphQLObjectType rootParentType;

    private QueryTraversal(GraphQLSchema schema, Document document, String operation, Map<String, Object> variables) {
        Assert.assertNotNull(document, "document  can't be null", new Object[0]);
        NodeUtil.GetOperationResult getOperationResult = NodeUtil.getOperation(document, operation);
        this.schema = Assert.assertNotNull(schema, "schema can't be null", new Object[0]);
        this.variables = Assert.assertNotNull(variables, "variables can't be null", new Object[0]);
        this.fragmentsByName = getOperationResult.fragmentsByName;
        this.roots = getOperationResult.operationDefinition.getSelectionSet().getChildren();
        this.rootParentType = this.getRootTypeFromOperation(getOperationResult.operationDefinition);
        this.childrenOfSelectionProvider = new ChildrenOfSelectionProvider(this.fragmentsByName);
    }

    private QueryTraversal(GraphQLSchema schema, Node root, GraphQLObjectType rootParentType, Map<String, FragmentDefinition> fragmentsByName, Map<String, Object> variables) {
        this.schema = Assert.assertNotNull(schema, "schema can't be null", new Object[0]);
        this.variables = Assert.assertNotNull(variables, "variables can't be null", new Object[0]);
        Assert.assertNotNull(root, "root can't be null", new Object[0]);
        this.roots = Collections.singleton(root);
        this.rootParentType = Assert.assertNotNull(rootParentType, "rootParentType can't be null", new Object[0]);
        this.fragmentsByName = Assert.assertNotNull(fragmentsByName, "fragmentsByName can't be null", new Object[0]);
        this.childrenOfSelectionProvider = new ChildrenOfSelectionProvider(fragmentsByName);
    }

    public void visitPostOrder(QueryVisitor visitor) {
        this.visitImpl(visitor, false);
    }

    public void visitPreOrder(QueryVisitor visitor) {
        this.visitImpl(visitor, true);
    }

    public <T> T reducePostOrder(final QueryReducer<T> queryReducer, T initialValue) {
        final Object[] acc = new Object[]{initialValue};
        this.visitPostOrder(new QueryVisitorStub(){

            @Override
            public void visitField(QueryVisitorFieldEnvironment env) {
                acc[0] = queryReducer.reduceField(env, acc[0]);
            }
        });
        return (T)acc[0];
    }

    public <T> T reducePreOrder(final QueryReducer<T> queryReducer, T initialValue) {
        final Object[] acc = new Object[]{initialValue};
        this.visitPreOrder(new QueryVisitorStub(){

            @Override
            public void visitField(QueryVisitorFieldEnvironment env) {
                acc[0] = queryReducer.reduceField(env, acc[0]);
            }
        });
        return (T)acc[0];
    }

    private GraphQLObjectType getRootTypeFromOperation(OperationDefinition operationDefinition) {
        switch (operationDefinition.getOperation()) {
            case MUTATION: {
                return Assert.assertNotNull(this.schema.getMutationType());
            }
            case QUERY: {
                return Assert.assertNotNull(this.schema.getQueryType());
            }
            case SUBSCRIPTION: {
                return Assert.assertNotNull(this.schema.getSubscriptionType());
            }
        }
        return (GraphQLObjectType)Assert.assertShouldNeverHappen();
    }

    private List<Node> childrenOf(Node selection) {
        return this.childrenOfSelectionProvider.getSelections((Selection)selection);
    }

    private void visitImpl(QueryVisitor visitFieldCallback, boolean preOrder) {
        LinkedHashMap rootVars = new LinkedHashMap();
        rootVars.put(QueryTraversalContext.class, new QueryTraversalContext(this.rootParentType, this.rootParentType, null, null));
        QueryVisitorStub noOp = new QueryVisitorStub();
        QueryVisitor preOrderCallback = preOrder ? visitFieldCallback : noOp;
        QueryVisitor postOrderCallback = !preOrder ? visitFieldCallback : noOp;
        NodeTraverser nodeTraverser = new NodeTraverser(rootVars, this::childrenOf);
        nodeTraverser.depthFirst((NodeVisitor)new NodeVisitorImpl(preOrderCallback, postOrderCallback), this.roots);
    }

    public static Builder newQueryTraversal() {
        return new Builder();
    }

    @PublicApi
    public static class Builder {
        private GraphQLSchema schema;
        private Document document;
        private String operation;
        private Map<String, Object> variables;
        private Node root;
        private GraphQLObjectType rootParentType;
        private Map<String, FragmentDefinition> fragmentsByName;

        public Builder schema(GraphQLSchema schema) {
            this.schema = schema;
            return this;
        }

        public Builder operationName(String operationName) {
            this.operation = operationName;
            return this;
        }

        public Builder document(Document document) {
            this.document = document;
            return this;
        }

        public Builder variables(Map<String, Object> variables) {
            this.variables = variables;
            return this;
        }

        public Builder root(Node root) {
            this.root = root;
            return this;
        }

        public Builder rootParentType(GraphQLObjectType rootParentType) {
            this.rootParentType = rootParentType;
            return this;
        }

        public Builder fragmentsByName(Map<String, FragmentDefinition> fragmentsByName) {
            this.fragmentsByName = fragmentsByName;
            return this;
        }

        public QueryTraversal build() {
            this.checkState();
            if (this.document != null) {
                return new QueryTraversal(this.schema, this.document, this.operation, this.variables);
            }
            return new QueryTraversal(this.schema, this.root, this.rootParentType, this.fragmentsByName, this.variables);
        }

        private void checkState() {
            if (!(this.document == null && this.operation == null || this.root == null && this.rootParentType == null && this.fragmentsByName == null)) {
                throw new IllegalStateException("ambiguous builder");
            }
        }
    }

    private class NodeVisitorImpl
    extends NodeVisitorStub {
        final QueryVisitor preOrderCallback;
        final QueryVisitor postOrderCallback;

        NodeVisitorImpl(QueryVisitor preOrderCallback, QueryVisitor postOrderCallback) {
            this.preOrderCallback = preOrderCallback;
            this.postOrderCallback = postOrderCallback;
        }

        @Override
        public TraversalControl visitInlineFragment(InlineFragment inlineFragment, TraverserContext<Node> context) {
            GraphQLCompositeType fragmentCondition;
            if (!QueryTraversal.this.conditionalNodes.shouldInclude(QueryTraversal.this.variables, inlineFragment.getDirectives())) {
                return TraversalControl.ABORT;
            }
            QueryVisitorInlineFragmentEnvironmentImpl inlineFragmentEnvironment = new QueryVisitorInlineFragmentEnvironmentImpl(inlineFragment);
            if (context.getVar(NodeTraverser.LeaveOrEnter.class) == NodeTraverser.LeaveOrEnter.LEAVE) {
                this.postOrderCallback.visitInlineFragment(inlineFragmentEnvironment);
                return TraversalControl.CONTINUE;
            }
            this.preOrderCallback.visitInlineFragment(inlineFragmentEnvironment);
            QueryTraversalContext parentEnv = context.getParentContext().getVar(QueryTraversalContext.class);
            if (inlineFragment.getTypeCondition() != null) {
                TypeName typeCondition = inlineFragment.getTypeCondition();
                fragmentCondition = (GraphQLCompositeType)QueryTraversal.this.schema.getType(typeCondition.getName());
            } else {
                fragmentCondition = parentEnv.getRawType();
            }
            context.setVar(QueryTraversalContext.class, new QueryTraversalContext(fragmentCondition, fragmentCondition, parentEnv.getEnvironment(), inlineFragment));
            return TraversalControl.CONTINUE;
        }

        @Override
        public TraversalControl visitFragmentSpread(FragmentSpread fragmentSpread, TraverserContext<Node> context) {
            if (!QueryTraversal.this.conditionalNodes.shouldInclude(QueryTraversal.this.variables, fragmentSpread.getDirectives())) {
                return TraversalControl.ABORT;
            }
            FragmentDefinition fragmentDefinition = (FragmentDefinition)QueryTraversal.this.fragmentsByName.get(fragmentSpread.getName());
            if (!QueryTraversal.this.conditionalNodes.shouldInclude(QueryTraversal.this.variables, fragmentDefinition.getDirectives())) {
                return TraversalControl.ABORT;
            }
            QueryVisitorFragmentSpreadEnvironmentImpl fragmentSpreadEnvironment = new QueryVisitorFragmentSpreadEnvironmentImpl(fragmentSpread, fragmentDefinition);
            if (context.getVar(NodeTraverser.LeaveOrEnter.class) == NodeTraverser.LeaveOrEnter.LEAVE) {
                this.postOrderCallback.visitFragmentSpread(fragmentSpreadEnvironment);
                return TraversalControl.CONTINUE;
            }
            this.preOrderCallback.visitFragmentSpread(fragmentSpreadEnvironment);
            QueryTraversalContext parentEnv = context.getParentContext().getVar(QueryTraversalContext.class);
            GraphQLCompositeType typeCondition = (GraphQLCompositeType)QueryTraversal.this.schema.getType(fragmentDefinition.getTypeCondition().getName());
            context.setVar(QueryTraversalContext.class, new QueryTraversalContext(typeCondition, typeCondition, parentEnv.getEnvironment(), fragmentDefinition));
            return TraversalControl.CONTINUE;
        }

        @Override
        public TraversalControl visitField(Field field, TraverserContext<Node> context) {
            QueryTraversalContext parentEnv = context.getParentContext().getVar(QueryTraversalContext.class);
            GraphQLFieldDefinition fieldDefinition = Introspection.getFieldDef(QueryTraversal.this.schema, parentEnv.getRawType(), field.getName());
            boolean isTypeNameIntrospectionField = fieldDefinition == Introspection.TypeNameMetaFieldDef;
            GraphQLFieldsContainer fieldsContainer = !isTypeNameIntrospectionField ? (GraphQLFieldsContainer)((Object)GraphQLTypeUtil.unwrapAll(parentEnv.getOutputType())) : null;
            Map<String, Object> argumentValues = QueryTraversal.this.valuesResolver.getArgumentValues(QueryTraversal.this.schema.getFieldVisibility(), fieldDefinition.getArguments(), field.getArguments(), QueryTraversal.this.variables);
            QueryVisitorFieldEnvironmentImpl environment = new QueryVisitorFieldEnvironmentImpl(isTypeNameIntrospectionField, field, fieldDefinition, parentEnv.getOutputType(), fieldsContainer, parentEnv.getEnvironment(), argumentValues, parentEnv.getSelectionSetContainer());
            NodeTraverser.LeaveOrEnter leaveOrEnter = context.getVar(NodeTraverser.LeaveOrEnter.class);
            if (leaveOrEnter == NodeTraverser.LeaveOrEnter.LEAVE) {
                this.postOrderCallback.visitField(environment);
                return TraversalControl.CONTINUE;
            }
            if (!QueryTraversal.this.conditionalNodes.shouldInclude(QueryTraversal.this.variables, field.getDirectives())) {
                return TraversalControl.ABORT;
            }
            this.preOrderCallback.visitField(environment);
            GraphQLUnmodifiedType unmodifiedType = GraphQLTypeUtil.unwrapAll(fieldDefinition.getType());
            QueryTraversalContext fieldEnv = unmodifiedType instanceof GraphQLCompositeType ? new QueryTraversalContext(fieldDefinition.getType(), (GraphQLCompositeType)((Object)unmodifiedType), environment, field) : new QueryTraversalContext(null, null, environment, field);
            context.setVar(QueryTraversalContext.class, fieldEnv);
            return TraversalControl.CONTINUE;
        }
    }
}

