/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.PublicApi;
import graphql.execution.ExecutionPath;
import graphql.language.Field;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@PublicApi
public class ExecutionStepInfo {
    private final GraphQLType type;
    private final Field field;
    private final GraphQLFieldDefinition fieldDefinition;
    private final ExecutionPath path;
    private final Map<String, Object> arguments;
    private final ExecutionStepInfo parent;

    private ExecutionStepInfo(GraphQLType type, GraphQLFieldDefinition fieldDefinition, Field field, ExecutionPath path, ExecutionStepInfo parent, Map<String, Object> arguments) {
        this.fieldDefinition = fieldDefinition;
        this.field = field;
        this.path = path;
        this.parent = parent;
        this.type = Assert.assertNotNull(type, "you must provide a graphql type", new Object[0]);
        this.arguments = arguments;
    }

    public GraphQLType getType() {
        return this.type;
    }

    public GraphQLType getUnwrappedNonNullType() {
        return GraphQLTypeUtil.unwrapNonNull(this.type);
    }

    public GraphQLFieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    public Field getField() {
        return this.field;
    }

    public ExecutionPath getPath() {
        return this.path;
    }

    public boolean isNonNullType() {
        return GraphQLTypeUtil.isNonNull(this.type);
    }

    public boolean isListType() {
        return GraphQLTypeUtil.isList(this.type);
    }

    public Map<String, Object> getArguments() {
        return new LinkedHashMap<String, Object>(this.arguments);
    }

    public <T> T getArgument(String name) {
        return (T)this.arguments.get(name);
    }

    public ExecutionStepInfo getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public ExecutionStepInfo changeTypeWithPreservedNonNull(GraphQLType newType) {
        Assert.assertTrue(!GraphQLTypeUtil.isNonNull(newType), "newType can't be non null", new Object[0]);
        if (this.isNonNullType()) {
            return new ExecutionStepInfo(GraphQLNonNull.nonNull(newType), this.fieldDefinition, this.field, this.path, this.parent, this.arguments);
        }
        return new ExecutionStepInfo(newType, this.fieldDefinition, this.field, this.path, this.parent, this.arguments);
    }

    public String simplePrint() {
        return GraphQLTypeUtil.simplePrint(this.type);
    }

    public String toString() {
        return "ExecutionStepInfo{ path=" + this.path + ", type=" + this.type + ", parent=" + this.parent + ", fieldDefinition=" + this.fieldDefinition + '}';
    }

    public static Builder newExecutionStepInfo() {
        return new Builder();
    }

    public static class Builder {
        GraphQLType type;
        ExecutionStepInfo parentInfo;
        GraphQLFieldDefinition fieldDefinition;
        Field field;
        ExecutionPath executionPath;
        Map<String, Object> arguments = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        public Builder type(GraphQLType type) {
            this.type = type;
            return this;
        }

        public Builder parentInfo(ExecutionStepInfo executionStepInfo) {
            this.parentInfo = executionStepInfo;
            return this;
        }

        public Builder fieldDefinition(GraphQLFieldDefinition fieldDefinition) {
            this.fieldDefinition = fieldDefinition;
            return this;
        }

        public Builder field(Field field) {
            this.field = field;
            return this;
        }

        public Builder path(ExecutionPath executionPath) {
            this.executionPath = executionPath;
            return this;
        }

        public Builder arguments(Map<String, Object> arguments) {
            this.arguments = new LinkedHashMap<String, Object>(arguments == null ? Collections.emptyMap() : arguments);
            return this;
        }

        public ExecutionStepInfo build() {
            return new ExecutionStepInfo(this.type, this.fieldDefinition, this.field, this.executionPath, this.parentInfo, this.arguments);
        }
    }
}

