/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.PublicSpi;
import graphql.SerializationError;
import graphql.TypeMismatchError;
import graphql.TypeResolutionEnvironment;
import graphql.UnresolvedTypeError;
import graphql.execution.AbortExecutionException;
import graphql.execution.AbsoluteGraphQLError;
import graphql.execution.Async;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.FieldValueInfo;
import graphql.execution.NonNullableFieldValidator;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.execution.TypeResolutionParameters;
import graphql.execution.UnresolvedTypeException;
import graphql.execution.ValuesResolver;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationFieldCompleteParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldParameters;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.schema.CoercingSerializeException;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentBuilder;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.DataFetchingFieldSelectionSetImpl;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.visibility.GraphqlFieldVisibility;
import graphql.util.FpKit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicSpi
public abstract class ExecutionStrategy {
    private static final Logger log = LoggerFactory.getLogger(ExecutionStrategy.class);
    protected final ValuesResolver valuesResolver = new ValuesResolver();
    protected final FieldCollector fieldCollector = new FieldCollector();
    protected final DataFetcherExceptionHandler dataFetcherExceptionHandler;

    protected ExecutionStrategy() {
        this.dataFetcherExceptionHandler = new SimpleDataFetcherExceptionHandler();
    }

    protected ExecutionStrategy(DataFetcherExceptionHandler dataFetcherExceptionHandler) {
        this.dataFetcherExceptionHandler = dataFetcherExceptionHandler;
    }

    public abstract CompletableFuture<ExecutionResult> execute(ExecutionContext var1, ExecutionStrategyParameters var2) throws NonNullableFieldWasNullException;

    protected CompletableFuture<ExecutionResult> resolveField(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        return this.resolveFieldWithInfo(executionContext, parameters).thenCompose(FieldValueInfo::getFieldValue);
    }

    protected CompletableFuture<FieldValueInfo> resolveFieldWithInfo(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext, parameters, parameters.getField().get(0));
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationContext<ExecutionResult> fieldCtx = instrumentation.beginField(new InstrumentationFieldParameters(executionContext, fieldDef, this.createExecutionStepInfo(executionContext, parameters, fieldDef)));
        CompletableFuture<Object> fetchFieldFuture = this.fetchField(executionContext, parameters);
        CompletionStage result = fetchFieldFuture.thenApply(fetchedValue -> this.completeField(executionContext, parameters, fetchedValue));
        CompletionStage executionResultFuture = ((CompletableFuture)result).thenCompose(FieldValueInfo::getFieldValue);
        fieldCtx.onDispatched((CompletableFuture<ExecutionResult>)executionResultFuture);
        ((CompletableFuture)executionResultFuture).whenComplete(fieldCtx::onCompleted);
        return result;
    }

    protected CompletableFuture<Object> fetchField(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        CompletableFuture<Object> fetchedValue;
        Field field = parameters.getField().get(0);
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field);
        GraphqlFieldVisibility fieldVisibility = executionContext.getGraphQLSchema().getFieldVisibility();
        Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(fieldVisibility, fieldDef.getArguments(), field.getArguments(), executionContext.getVariables());
        GraphQLOutputType fieldType = fieldDef.getType();
        DataFetchingFieldSelectionSet fieldCollector = DataFetchingFieldSelectionSetImpl.newCollector(executionContext, fieldType, parameters.getField());
        ExecutionStepInfo executionStepInfo = this.createExecutionStepInfo(executionContext, parameters, fieldDef);
        DataFetchingEnvironment environment = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(executionContext).source(parameters.getSource()).arguments(argumentValues).fieldDefinition(fieldDef).fields(parameters.getField()).fieldType(fieldType).executionStepInfo(executionStepInfo).parentType(parentType).selectionSet(fieldCollector).build();
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationFieldFetchParameters instrumentationFieldFetchParams = new InstrumentationFieldFetchParameters(executionContext, fieldDef, environment, parameters);
        InstrumentationContext<Object> fetchCtx = instrumentation.beginFieldFetch(instrumentationFieldFetchParams);
        DataFetcher<?> dataFetcher = fieldDef.getDataFetcher();
        dataFetcher = instrumentation.instrumentDataFetcher(dataFetcher, instrumentationFieldFetchParams);
        ExecutionId executionId = executionContext.getExecutionId();
        try {
            log.debug("'{}' fetching field '{}' using data fetcher '{}'...", new Object[]{executionId, executionStepInfo.getPath(), dataFetcher.getClass().getName()});
            Object fetchedValueRaw = dataFetcher.get(environment);
            log.debug("'{}' field '{}' fetch returned '{}'", new Object[]{executionId, executionStepInfo.getPath(), fetchedValueRaw == null ? "null" : fetchedValueRaw.getClass().getName()});
            fetchedValue = Async.toCompletableFuture(fetchedValueRaw);
        }
        catch (Exception e) {
            log.debug(String.format("'%s', field '%s' fetch threw exception", executionId, executionStepInfo.getPath()), (Throwable)e);
            fetchedValue = new CompletableFuture();
            fetchedValue.completeExceptionally(e);
        }
        fetchCtx.onDispatched(fetchedValue);
        return ((CompletableFuture)((CompletableFuture)fetchedValue.handle((result, exception) -> {
            fetchCtx.onCompleted(result, (Throwable)exception);
            if (exception != null) {
                this.handleFetchingException(executionContext, parameters, field, fieldDef, argumentValues, environment, (Throwable)exception);
                return null;
            }
            return result;
        })).thenApply(result -> this.unboxPossibleDataFetcherResult(executionContext, parameters, result))).thenApply(this::unboxPossibleOptional);
    }

    Object unboxPossibleDataFetcherResult(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Object result) {
        if (result instanceof DataFetcherResult) {
            DataFetcherResult dataFetcherResult = (DataFetcherResult)result;
            dataFetcherResult.getErrors().stream().map(relError -> new AbsoluteGraphQLError(parameters, (GraphQLError)relError)).forEach(executionContext::addError);
            return dataFetcherResult.getData();
        }
        return result;
    }

    private void handleFetchingException(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Field field, GraphQLFieldDefinition fieldDef, Map<String, Object> argumentValues, DataFetchingEnvironment environment, Throwable e) {
        DataFetcherExceptionHandlerParameters handlerParameters = DataFetcherExceptionHandlerParameters.newExceptionParameters().executionContext(executionContext).dataFetchingEnvironment(environment).argumentValues(argumentValues).field(field).fieldDefinition(fieldDef).path(parameters.getPath()).exception(e).build();
        this.dataFetcherExceptionHandler.accept(handlerParameters);
        parameters.deferredErrorSupport().onFetchingException(parameters, e);
    }

    protected FieldValueInfo completeField(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Object fetchedValue) {
        Field field = parameters.getField().get(0);
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field);
        ExecutionStepInfo executionStepInfo = this.createExecutionStepInfo(executionContext, parameters, fieldDef);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationFieldCompleteParameters instrumentationParams = new InstrumentationFieldCompleteParameters(executionContext, parameters, fieldDef, executionStepInfo, fetchedValue);
        InstrumentationContext<ExecutionResult> ctxCompleteField = instrumentation.beginFieldComplete(instrumentationParams);
        GraphqlFieldVisibility fieldVisibility = executionContext.getGraphQLSchema().getFieldVisibility();
        Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(fieldVisibility, fieldDef.getArguments(), field.getArguments(), executionContext.getVariables());
        NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, executionStepInfo);
        ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.executionStepInfo(executionStepInfo).arguments(argumentValues).source(fetchedValue).nonNullFieldValidator(nonNullableFieldValidator));
        log.debug("'{}' completing field '{}'...", (Object)executionContext.getExecutionId(), (Object)executionStepInfo.getPath());
        FieldValueInfo fieldValueInfo = this.completeValue(executionContext, newParameters);
        CompletableFuture<ExecutionResult> executionResultFuture = fieldValueInfo.getFieldValue();
        ctxCompleteField.onDispatched(executionResultFuture);
        executionResultFuture.whenComplete(ctxCompleteField::onCompleted);
        return fieldValueInfo;
    }

    protected FieldValueInfo completeValue(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        CompletableFuture<ExecutionResult> fieldValue;
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        Object result = this.unboxPossibleOptional(parameters.getSource());
        GraphQLType fieldType = executionStepInfo.getUnwrappedNonNullType();
        if (result == null) {
            CompletableFuture<ExecutionResult> fieldValue2 = this.completeValueForNull(parameters);
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.NULL).fieldValue(fieldValue2).build();
        }
        if (GraphQLTypeUtil.isList(fieldType)) {
            return this.completeValueForList(executionContext, parameters, result);
        }
        if (fieldType instanceof GraphQLScalarType) {
            CompletableFuture<ExecutionResult> fieldValue3 = this.completeValueForScalar(executionContext, parameters, (GraphQLScalarType)fieldType, result);
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.SCALAR).fieldValue(fieldValue3).build();
        }
        if (fieldType instanceof GraphQLEnumType) {
            CompletableFuture<ExecutionResult> fieldValue4 = this.completeValueForEnum(executionContext, parameters, (GraphQLEnumType)fieldType, result);
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.ENUM).fieldValue(fieldValue4).build();
        }
        try {
            GraphQLObjectType resolvedObjectType = this.resolveType(executionContext, parameters, fieldType);
            fieldValue = this.completeValueForObject(executionContext, parameters, resolvedObjectType, result);
        }
        catch (UnresolvedTypeException ex) {
            this.handleUnresolvedTypeProblem(executionContext, parameters, ex);
            parameters.getNonNullFieldValidator().validate(parameters.getPath(), null);
            fieldValue = CompletableFuture.completedFuture(new ExecutionResultImpl(null, null));
        }
        return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.OBJECT).fieldValue(fieldValue).build();
    }

    private void handleUnresolvedTypeProblem(ExecutionContext context, ExecutionStrategyParameters parameters, UnresolvedTypeException e) {
        UnresolvedTypeError error = new UnresolvedTypeError(parameters.getPath(), parameters.getExecutionStepInfo(), e);
        log.warn(error.getMessage(), (Throwable)e);
        context.addError(error);
        parameters.deferredErrorSupport().onError(error);
    }

    private CompletableFuture<ExecutionResult> completeValueForNull(ExecutionStrategyParameters parameters) {
        return Async.tryCatch(() -> {
            Object nullValue = parameters.getNonNullFieldValidator().validate(parameters.getPath(), null);
            return CompletableFuture.completedFuture(new ExecutionResultImpl(nullValue, null));
        });
    }

    protected FieldValueInfo completeValueForList(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Object result) {
        Iterable<Object> resultIterable = this.toIterable(executionContext, parameters, result);
        try {
            resultIterable = parameters.getNonNullFieldValidator().validate(parameters.getPath(), resultIterable);
        }
        catch (NonNullableFieldWasNullException e) {
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.LIST).fieldValue(Async.exceptionallyCompletedFuture(e)).build();
        }
        if (resultIterable == null) {
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.LIST).fieldValue(CompletableFuture.completedFuture(new ExecutionResultImpl(null, null))).build();
        }
        return this.completeValueForList(executionContext, parameters, resultIterable);
    }

    protected FieldValueInfo completeValueForList(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Iterable<Object> iterableValues) {
        Collection values = FpKit.toCollection(iterableValues);
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        GraphQLList fieldType = (GraphQLList)executionStepInfo.getUnwrappedNonNullType();
        GraphQLFieldDefinition fieldDef = parameters.getExecutionStepInfo().getFieldDefinition();
        Field field = parameters.getExecutionStepInfo().getField();
        InstrumentationFieldCompleteParameters instrumentationParams = new InstrumentationFieldCompleteParameters(executionContext, parameters, fieldDef, this.createExecutionStepInfo(executionContext, parameters, fieldDef), values);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationContext<ExecutionResult> completeListCtx = instrumentation.beginFieldListComplete(instrumentationParams);
        ArrayList<FieldValueInfo> fieldValueInfos = new ArrayList<FieldValueInfo>();
        int index = 0;
        for (Object item2 : values) {
            ExecutionPath indexedPath = parameters.getPath().segment(index);
            ExecutionStepInfo wrappedExecutionStepInfo = ExecutionStepInfo.newExecutionStepInfo().parentInfo(executionStepInfo).type(fieldType.getWrappedType()).path(indexedPath).fieldDefinition(fieldDef).field(field).build();
            NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, wrappedExecutionStepInfo);
            int finalIndex = index++;
            ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.executionStepInfo(wrappedExecutionStepInfo).nonNullFieldValidator(nonNullableFieldValidator).listSize(values.size()).currentListIndex(finalIndex).path(indexedPath).source(item2));
            fieldValueInfos.add(this.completeValue(executionContext, newParameters));
        }
        CompletableFuture resultsFuture = Async.each(fieldValueInfos, (item, i) -> item.getFieldValue());
        CompletableFuture<ExecutionResult> overallResult = new CompletableFuture<ExecutionResult>();
        completeListCtx.onDispatched(overallResult);
        resultsFuture.whenComplete((results, exception) -> {
            if (exception != null) {
                ExecutionResult executionResult = this.handleNonNullException(executionContext, overallResult, (Throwable)exception);
                completeListCtx.onCompleted(executionResult, (Throwable)exception);
                return;
            }
            ArrayList completedResults = new ArrayList();
            for (ExecutionResult completedValue : results) {
                completedResults.add(completedValue.getData());
            }
            ExecutionResultImpl executionResult = new ExecutionResultImpl(completedResults, null);
            overallResult.complete(executionResult);
        });
        overallResult.whenComplete(completeListCtx::onCompleted);
        return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.LIST).fieldValue(overallResult).fieldValueInfos(fieldValueInfos).build();
    }

    protected CompletableFuture<ExecutionResult> completeValueForScalar(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLScalarType scalarType, Object result) {
        Object serialized;
        try {
            serialized = scalarType.getCoercing().serialize(result);
        }
        catch (CoercingSerializeException e) {
            serialized = this.handleCoercionProblem(executionContext, parameters, e);
        }
        if (serialized instanceof Double && ((Double)serialized).isNaN()) {
            serialized = null;
        }
        try {
            serialized = parameters.getNonNullFieldValidator().validate(parameters.getPath(), serialized);
        }
        catch (NonNullableFieldWasNullException e) {
            return Async.exceptionallyCompletedFuture(e);
        }
        return CompletableFuture.completedFuture(new ExecutionResultImpl(serialized, null));
    }

    protected CompletableFuture<ExecutionResult> completeValueForEnum(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLEnumType enumType, Object result) {
        Object serialized;
        try {
            serialized = enumType.getCoercing().serialize(result);
        }
        catch (CoercingSerializeException e) {
            serialized = this.handleCoercionProblem(executionContext, parameters, e);
        }
        try {
            serialized = parameters.getNonNullFieldValidator().validate(parameters.getPath(), serialized);
        }
        catch (NonNullableFieldWasNullException e) {
            return Async.exceptionallyCompletedFuture(e);
        }
        return CompletableFuture.completedFuture(new ExecutionResultImpl(serialized, null));
    }

    protected CompletableFuture<ExecutionResult> completeValueForObject(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLObjectType resolvedObjectType, Object result) {
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        FieldCollectorParameters collectorParameters = FieldCollectorParameters.newParameters().schema(executionContext.getGraphQLSchema()).objectType(resolvedObjectType).fragments(executionContext.getFragmentsByName()).variables(executionContext.getVariables()).build();
        Map<String, List<Field>> subFields = this.fieldCollector.collectFields(collectorParameters, parameters.getField());
        ExecutionStepInfo newExecutionStepInfo = executionStepInfo.changeTypeWithPreservedNonNull(resolvedObjectType);
        NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, newExecutionStepInfo);
        ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.executionStepInfo(newExecutionStepInfo).fields(subFields).nonNullFieldValidator(nonNullableFieldValidator).source(result));
        return executionContext.getQueryStrategy().execute(executionContext, newParameters);
    }

    private Object handleCoercionProblem(ExecutionContext context, ExecutionStrategyParameters parameters, CoercingSerializeException e) {
        SerializationError error = new SerializationError(parameters.getPath(), e);
        log.warn(error.getMessage(), (Throwable)e);
        context.addError(error);
        parameters.deferredErrorSupport().onError(error);
        return null;
    }

    protected Object unboxPossibleOptional(Object result) {
        if (result instanceof Optional) {
            Optional optional = (Optional)result;
            if (optional.isPresent()) {
                return optional.get();
            }
            return null;
        }
        if (result instanceof OptionalInt) {
            OptionalInt optional = (OptionalInt)result;
            if (optional.isPresent()) {
                return optional.getAsInt();
            }
            return null;
        }
        if (result instanceof OptionalDouble) {
            OptionalDouble optional = (OptionalDouble)result;
            if (optional.isPresent()) {
                return optional.getAsDouble();
            }
            return null;
        }
        if (result instanceof OptionalLong) {
            OptionalLong optional = (OptionalLong)result;
            if (optional.isPresent()) {
                return optional.getAsLong();
            }
            return null;
        }
        return result;
    }

    protected Iterable<Object> toIterable(Object result) {
        return FpKit.toCollection(result);
    }

    protected GraphQLObjectType resolveType(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLType fieldType) {
        GraphQLObjectType resolvedType;
        if (fieldType instanceof GraphQLInterfaceType) {
            TypeResolutionParameters resolutionParams = TypeResolutionParameters.newParameters().graphQLInterfaceType((GraphQLInterfaceType)fieldType).field(parameters.getField().get(0)).value(parameters.getSource()).argumentValues(parameters.getArguments()).context(executionContext.getContext()).schema(executionContext.getGraphQLSchema()).build();
            resolvedType = this.resolveTypeForInterface(resolutionParams);
        } else if (fieldType instanceof GraphQLUnionType) {
            TypeResolutionParameters resolutionParams = TypeResolutionParameters.newParameters().graphQLUnionType((GraphQLUnionType)fieldType).field(parameters.getField().get(0)).value(parameters.getSource()).argumentValues(parameters.getArguments()).context(executionContext.getContext()).schema(executionContext.getGraphQLSchema()).build();
            resolvedType = this.resolveTypeForUnion(resolutionParams);
        } else {
            resolvedType = (GraphQLObjectType)fieldType;
        }
        return resolvedType;
    }

    protected GraphQLObjectType resolveTypeForInterface(TypeResolutionParameters params) {
        TypeResolutionEnvironment env = new TypeResolutionEnvironment(params.getValue(), params.getArgumentValues(), params.getField(), params.getGraphQLInterfaceType(), params.getSchema(), params.getContext());
        GraphQLInterfaceType abstractType = params.getGraphQLInterfaceType();
        GraphQLObjectType result = abstractType.getTypeResolver().getType(env);
        if (result == null) {
            throw new UnresolvedTypeException(abstractType);
        }
        if (!params.getSchema().isPossibleType(abstractType, result)) {
            throw new UnresolvedTypeException(abstractType, (GraphQLType)result);
        }
        return result;
    }

    protected GraphQLObjectType resolveTypeForUnion(TypeResolutionParameters params) {
        TypeResolutionEnvironment env = new TypeResolutionEnvironment(params.getValue(), params.getArgumentValues(), params.getField(), params.getGraphQLUnionType(), params.getSchema(), params.getContext());
        GraphQLUnionType abstractType = params.getGraphQLUnionType();
        GraphQLObjectType result = abstractType.getTypeResolver().getType(env);
        if (result == null) {
            throw new UnresolvedTypeException(abstractType);
        }
        if (!params.getSchema().isPossibleType(abstractType, result)) {
            throw new UnresolvedTypeException(abstractType, (GraphQLType)result);
        }
        return result;
    }

    protected Iterable<Object> toIterable(ExecutionContext context, ExecutionStrategyParameters parameters, Object result) {
        if (result.getClass().isArray() || result instanceof Iterable) {
            return this.toIterable(result);
        }
        this.handleTypeMismatchProblem(context, parameters, result);
        return null;
    }

    private void handleTypeMismatchProblem(ExecutionContext context, ExecutionStrategyParameters parameters, Object result) {
        TypeMismatchError error = new TypeMismatchError(parameters.getPath(), parameters.getExecutionStepInfo().getUnwrappedNonNullType());
        log.warn("{} got {}", (Object)error.getMessage(), result.getClass());
        context.addError(error);
        parameters.deferredErrorSupport().onError(error);
    }

    protected GraphQLFieldDefinition getFieldDef(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Field field) {
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        return this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field);
    }

    protected GraphQLFieldDefinition getFieldDef(GraphQLSchema schema, GraphQLObjectType parentType, Field field) {
        return Introspection.getFieldDef(schema, parentType, field.getName());
    }

    protected void assertNonNullFieldPrecondition(NonNullableFieldWasNullException e) throws NonNullableFieldWasNullException {
        ExecutionStepInfo executionStepInfo = e.getExecutionStepInfo();
        if (executionStepInfo.hasParent() && executionStepInfo.getParent().isNonNullType()) {
            throw new NonNullableFieldWasNullException(e);
        }
    }

    protected void assertNonNullFieldPrecondition(NonNullableFieldWasNullException e, CompletableFuture<?> completableFuture) throws NonNullableFieldWasNullException {
        ExecutionStepInfo executionStepInfo = e.getExecutionStepInfo();
        if (executionStepInfo.hasParent() && executionStepInfo.getParent().isNonNullType()) {
            completableFuture.completeExceptionally(new NonNullableFieldWasNullException(e));
        }
    }

    protected ExecutionResult handleNonNullException(ExecutionContext executionContext, CompletableFuture<ExecutionResult> result, Throwable e) {
        ExecutionResult executionResult = null;
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>(executionContext.getErrors());
        Throwable underlyingException = e;
        if (e instanceof CompletionException) {
            underlyingException = e.getCause();
        }
        if (underlyingException instanceof NonNullableFieldWasNullException) {
            this.assertNonNullFieldPrecondition((NonNullableFieldWasNullException)underlyingException, result);
            if (!result.isDone()) {
                executionResult = new ExecutionResultImpl(null, errors);
                result.complete(executionResult);
            }
        } else if (underlyingException instanceof AbortExecutionException) {
            AbortExecutionException abortException = (AbortExecutionException)underlyingException;
            executionResult = abortException.toExecutionResult();
            result.complete(executionResult);
        } else {
            result.completeExceptionally(e);
        }
        return executionResult;
    }

    protected ExecutionStepInfo createExecutionStepInfo(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLFieldDefinition fieldDefinition) {
        GraphQLOutputType fieldType = fieldDefinition.getType();
        Field field = null;
        List<Argument> fieldArgs = Collections.emptyList();
        if (parameters.getField() != null && !parameters.getField().isEmpty()) {
            field = parameters.getField().get(0);
            fieldArgs = field.getArguments();
        }
        GraphqlFieldVisibility fieldVisibility = executionContext.getGraphQLSchema().getFieldVisibility();
        Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(fieldVisibility, fieldDefinition.getArguments(), fieldArgs, executionContext.getVariables());
        return ExecutionStepInfo.newExecutionStepInfo().type(fieldType).fieldDefinition(fieldDefinition).field(field).path(parameters.getPath()).parentInfo(parameters.getExecutionStepInfo()).arguments(argumentValues).build();
    }

    @Internal
    public static String mkNameForPath(Field currentField) {
        return ExecutionStrategy.mkNameForPath(Collections.singletonList(currentField));
    }

    @Internal
    public static String mkNameForPath(List<Field> currentField) {
        Field field = currentField.get(0);
        return field.getAlias() != null ? field.getAlias() : field.getName();
    }
}

