/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.PublicApi;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.NonNullableFieldValidator;
import graphql.execution.defer.DeferredErrorSupport;
import graphql.language.Field;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class ExecutionStrategyParameters {
    private final ExecutionStepInfo executionStepInfo;
    private final Object source;
    private final Map<String, Object> arguments;
    private final Map<String, List<Field>> fields;
    private final NonNullableFieldValidator nonNullableFieldValidator;
    private final ExecutionPath path;
    private final List<Field> currentField;
    private final int listSize;
    private final int currentListIndex;
    private final ExecutionStrategyParameters parent;
    private final DeferredErrorSupport deferredErrorSupport;

    private ExecutionStrategyParameters(ExecutionStepInfo executionStepInfo, Object source, Map<String, List<Field>> fields, Map<String, Object> arguments, NonNullableFieldValidator nonNullableFieldValidator, ExecutionPath path, List<Field> currentField, int listSize, int currentListIndex, ExecutionStrategyParameters parent, DeferredErrorSupport deferredErrorSupport) {
        this.executionStepInfo = Assert.assertNotNull(executionStepInfo, "executionStepInfo is null", new Object[0]);
        this.fields = Assert.assertNotNull(fields, "fields is null", new Object[0]);
        this.source = source;
        this.arguments = arguments;
        this.nonNullableFieldValidator = nonNullableFieldValidator;
        this.path = path;
        this.currentField = currentField;
        this.listSize = listSize;
        this.currentListIndex = currentListIndex;
        this.parent = parent;
        this.deferredErrorSupport = deferredErrorSupport;
    }

    public ExecutionStepInfo getExecutionStepInfo() {
        return this.executionStepInfo;
    }

    public Object getSource() {
        return this.source;
    }

    public Map<String, List<Field>> getFields() {
        return this.fields;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public NonNullableFieldValidator getNonNullFieldValidator() {
        return this.nonNullableFieldValidator;
    }

    public ExecutionPath getPath() {
        return this.path;
    }

    public int getListSize() {
        return this.listSize;
    }

    public int getCurrentListIndex() {
        return this.currentListIndex;
    }

    public ExecutionStrategyParameters getParent() {
        return this.parent;
    }

    public DeferredErrorSupport deferredErrorSupport() {
        return this.deferredErrorSupport;
    }

    public List<Field> getField() {
        return this.currentField;
    }

    public ExecutionStrategyParameters transform(Consumer<Builder> builderConsumer) {
        Builder builder = ExecutionStrategyParameters.newParameters(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public String toString() {
        return String.format("ExecutionStrategyParameters { path=%s, executionStepInfo=%s, source=%s, fields=%s }", this.path, this.executionStepInfo, this.source, this.fields);
    }

    public static Builder newParameters() {
        return new Builder();
    }

    public static Builder newParameters(ExecutionStrategyParameters oldParameters) {
        return new Builder(oldParameters);
    }

    public static class Builder {
        ExecutionStepInfo executionStepInfo;
        Object source;
        Map<String, List<Field>> fields;
        Map<String, Object> arguments;
        NonNullableFieldValidator nonNullableFieldValidator;
        ExecutionPath path = ExecutionPath.rootPath();
        List<Field> currentField;
        int listSize;
        int currentListIndex;
        ExecutionStrategyParameters parent;
        DeferredErrorSupport deferredErrorSupport = new DeferredErrorSupport();

        private Builder() {
        }

        private Builder(ExecutionStrategyParameters oldParameters) {
            this.executionStepInfo = oldParameters.executionStepInfo;
            this.source = oldParameters.source;
            this.fields = oldParameters.fields;
            this.arguments = oldParameters.arguments;
            this.nonNullableFieldValidator = oldParameters.nonNullableFieldValidator;
            this.currentField = oldParameters.currentField;
            this.deferredErrorSupport = oldParameters.deferredErrorSupport;
            this.path = oldParameters.path;
            this.parent = oldParameters.parent;
            this.listSize = oldParameters.listSize;
            this.currentListIndex = oldParameters.currentListIndex;
        }

        public Builder executionStepInfo(ExecutionStepInfo executionStepInfo) {
            this.executionStepInfo = executionStepInfo;
            return this;
        }

        public Builder executionStepInfo(ExecutionStepInfo.Builder executionStepInfoBuilder) {
            this.executionStepInfo = executionStepInfoBuilder.build();
            return this;
        }

        public Builder fields(Map<String, List<Field>> fields) {
            this.fields = fields;
            return this;
        }

        public Builder field(List<Field> currentField) {
            this.currentField = currentField;
            return this;
        }

        public Builder source(Object source) {
            this.source = source;
            return this;
        }

        public Builder arguments(Map<String, Object> arguments) {
            this.arguments = arguments;
            return this;
        }

        public Builder nonNullFieldValidator(NonNullableFieldValidator nonNullableFieldValidator) {
            this.nonNullableFieldValidator = Assert.assertNotNull(nonNullableFieldValidator, "requires a NonNullValidator", new Object[0]);
            return this;
        }

        public Builder path(ExecutionPath path) {
            this.path = path;
            return this;
        }

        public Builder listSize(int listSize) {
            this.listSize = listSize;
            return this;
        }

        public Builder currentListIndex(int currentListIndex) {
            this.currentListIndex = currentListIndex;
            return this;
        }

        public Builder parent(ExecutionStrategyParameters parent) {
            this.parent = parent;
            return this;
        }

        public Builder deferredErrorSupport(DeferredErrorSupport deferredErrorSupport) {
            this.deferredErrorSupport = deferredErrorSupport;
            return this;
        }

        public ExecutionStrategyParameters build() {
            return new ExecutionStrategyParameters(this.executionStepInfo, this.source, this.fields, this.arguments, this.nonNullableFieldValidator, this.path, this.currentField, this.listSize, this.currentListIndex, this.parent, this.deferredErrorSupport);
        }
    }
}

