/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.Internal;
import graphql.execution.InputMapDefinesTooManyFieldsException;
import graphql.execution.NonNullableValueCoercedAsNullException;
import graphql.execution.TypeFromAST;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseValueException;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Internal
public class ValuesResolver {
    public Map<String, Object> coerceArgumentValues(GraphQLSchema schema, List<VariableDefinition> variableDefinitions, Map<String, Object> variableValues) {
        GraphqlFieldVisibility fieldVisibility = schema.getFieldVisibility();
        LinkedHashMap<String, Object> coercedValues = new LinkedHashMap<String, Object>();
        for (VariableDefinition variableDefinition : variableDefinitions) {
            Object coercedValue;
            String variableName = variableDefinition.getName();
            GraphQLType variableType = TypeFromAST.getTypeFromAST(schema, variableDefinition.getType());
            if (!variableValues.containsKey(variableName)) {
                Value defaultValue = variableDefinition.getDefaultValue();
                if (defaultValue != null) {
                    coercedValue = this.coerceValueAst(fieldVisibility, variableType, variableDefinition.getDefaultValue(), null);
                    coercedValues.put(variableName, coercedValue);
                    continue;
                }
                if (!GraphQLTypeUtil.isNonNull(variableType)) continue;
                throw new NonNullableValueCoercedAsNullException(variableDefinition, variableType);
            }
            Object value = variableValues.get(variableName);
            coercedValue = this.getVariableValue(fieldVisibility, variableDefinition, variableType, value);
            coercedValues.put(variableName, coercedValue);
        }
        return coercedValues;
    }

    private Object getVariableValue(GraphqlFieldVisibility fieldVisibility, VariableDefinition variableDefinition, GraphQLType variableType, Object value) {
        if (value == null && variableDefinition.getDefaultValue() != null) {
            return this.coerceValueAst(fieldVisibility, variableType, variableDefinition.getDefaultValue(), null);
        }
        return this.coerceValue(fieldVisibility, variableDefinition, variableDefinition.getName(), variableType, value);
    }

    public Map<String, Object> getArgumentValues(List<GraphQLArgument> argumentTypes, List<Argument> arguments, Map<String, Object> variables) {
        return this.getArgumentValues(DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY, argumentTypes, arguments, variables);
    }

    public Map<String, Object> getArgumentValues(GraphqlFieldVisibility fieldVisibility, List<GraphQLArgument> argumentTypes, List<Argument> arguments, Map<String, Object> variables) {
        if (argumentTypes.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Map<String, Argument> argumentMap = this.argumentMap(arguments);
        for (GraphQLArgument fieldArgument : argumentTypes) {
            String argName = fieldArgument.getName();
            Argument argument = argumentMap.get(argName);
            Object value = argument != null ? this.coerceValueAst(fieldVisibility, fieldArgument.getType(), argument.getValue(), variables) : fieldArgument.getDefaultValue();
            if (!argumentMap.containsKey(argName) && value == null) continue;
            result.put(argName, value);
        }
        return result;
    }

    private Map<String, Argument> argumentMap(List<Argument> arguments) {
        LinkedHashMap<String, Argument> result = new LinkedHashMap<String, Argument>();
        for (Argument argument : arguments) {
            result.put(argument.getName(), argument);
        }
        return result;
    }

    private Object coerceValue(GraphqlFieldVisibility fieldVisibility, VariableDefinition variableDefinition, String inputName, GraphQLType graphQLType, Object value) {
        try {
            if (GraphQLTypeUtil.isNonNull(graphQLType)) {
                Object returnValue = this.coerceValue(fieldVisibility, variableDefinition, inputName, GraphQLTypeUtil.unwrapOne(graphQLType), value);
                if (returnValue == null) {
                    throw new NonNullableValueCoercedAsNullException(variableDefinition, inputName, graphQLType);
                }
                return returnValue;
            }
            if (value == null) {
                return null;
            }
            if (graphQLType instanceof GraphQLScalarType) {
                return this.coerceValueForScalar((GraphQLScalarType)graphQLType, value);
            }
            if (graphQLType instanceof GraphQLEnumType) {
                return this.coerceValueForEnum((GraphQLEnumType)graphQLType, value);
            }
            if (graphQLType instanceof GraphQLList) {
                return this.coerceValueForList(fieldVisibility, variableDefinition, inputName, (GraphQLList)graphQLType, value);
            }
            if (graphQLType instanceof GraphQLInputObjectType) {
                if (value instanceof Map) {
                    return this.coerceValueForInputObjectType(fieldVisibility, variableDefinition, (GraphQLInputObjectType)graphQLType, (Map)value);
                }
                throw new CoercingParseValueException("Expected type 'Map' but was '" + value.getClass().getSimpleName() + "'. Variables for input objects must be an instance of type 'Map'.");
            }
            return Assert.assertShouldNeverHappen("unhandled type %s", graphQLType);
        }
        catch (CoercingParseValueException e) {
            if (e.getLocations() != null) {
                throw e;
            }
            throw new CoercingParseValueException("Variable '" + inputName + "' has an invalid value. " + e.getMessage(), e.getCause(), variableDefinition.getSourceLocation());
        }
    }

    private Object coerceValueForInputObjectType(GraphqlFieldVisibility fieldVisibility, VariableDefinition variableDefinition, GraphQLInputObjectType inputObjectType, Map<String, Object> input) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        List<GraphQLInputObjectField> fields = fieldVisibility.getFieldDefinitions(inputObjectType);
        List fieldNames = fields.stream().map(GraphQLInputObjectField::getName).collect(Collectors.toList());
        for (String inputFieldName : input.keySet()) {
            if (fieldNames.contains(inputFieldName)) continue;
            throw new InputMapDefinesTooManyFieldsException(inputObjectType, inputFieldName);
        }
        for (GraphQLInputObjectField inputField : fields) {
            if (!input.containsKey(inputField.getName()) && !this.alwaysHasValue(inputField)) continue;
            Object value = this.coerceValue(fieldVisibility, variableDefinition, inputField.getName(), inputField.getType(), input.get(inputField.getName()));
            result.put(inputField.getName(), value == null ? inputField.getDefaultValue() : value);
        }
        return result;
    }

    private boolean alwaysHasValue(GraphQLInputObjectField inputField) {
        return inputField.getDefaultValue() != null || GraphQLTypeUtil.isNonNull(inputField.getType());
    }

    private Object coerceValueForScalar(GraphQLScalarType graphQLScalarType, Object value) {
        return graphQLScalarType.getCoercing().parseValue(value);
    }

    private Object coerceValueForEnum(GraphQLEnumType graphQLEnumType, Object value) {
        return graphQLEnumType.getCoercing().parseValue(value);
    }

    private List coerceValueForList(GraphqlFieldVisibility fieldVisibility, VariableDefinition variableDefinition, String inputName, GraphQLList graphQLList, Object value) {
        if (value instanceof Iterable) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object val : (Iterable)value) {
                result.add(this.coerceValue(fieldVisibility, variableDefinition, inputName, graphQLList.getWrappedType(), val));
            }
            return result;
        }
        return Collections.singletonList(this.coerceValue(fieldVisibility, variableDefinition, inputName, graphQLList.getWrappedType(), value));
    }

    private Object coerceValueAst(GraphqlFieldVisibility fieldVisibility, GraphQLType type, Value inputValue, Map<String, Object> variables) {
        if (inputValue instanceof VariableReference) {
            return variables.get(((VariableReference)inputValue).getName());
        }
        if (inputValue instanceof NullValue) {
            return null;
        }
        if (type instanceof GraphQLScalarType) {
            return this.parseLiteral(inputValue, ((GraphQLScalarType)type).getCoercing(), variables);
        }
        if (GraphQLTypeUtil.isNonNull(type)) {
            return this.coerceValueAst(fieldVisibility, GraphQLTypeUtil.unwrapOne(type), inputValue, variables);
        }
        if (type instanceof GraphQLInputObjectType) {
            return this.coerceValueAstForInputObject(fieldVisibility, (GraphQLInputObjectType)type, (ObjectValue)inputValue, variables);
        }
        if (type instanceof GraphQLEnumType) {
            return this.parseLiteral(inputValue, ((GraphQLEnumType)type).getCoercing(), variables);
        }
        if (GraphQLTypeUtil.isList(type)) {
            return this.coerceValueAstForList(fieldVisibility, (GraphQLList)type, inputValue, variables);
        }
        return null;
    }

    private Object parseLiteral(Value inputValue, Coercing coercing, Map<String, Object> variables) {
        return coercing.parseLiteral(inputValue, variables);
    }

    private Object coerceValueAstForList(GraphqlFieldVisibility fieldVisibility, GraphQLList graphQLList, Value value, Map<String, Object> variables) {
        if (value instanceof ArrayValue) {
            ArrayValue arrayValue = (ArrayValue)value;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Value singleValue : arrayValue.getValues()) {
                result.add(this.coerceValueAst(fieldVisibility, graphQLList.getWrappedType(), singleValue, variables));
            }
            return result;
        }
        return Collections.singletonList(this.coerceValueAst(fieldVisibility, graphQLList.getWrappedType(), value, variables));
    }

    private Object coerceValueAstForInputObject(GraphqlFieldVisibility fieldVisibility, GraphQLInputObjectType type, ObjectValue inputValue, Map<String, Object> variables) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Map<String, ObjectField> inputValueFieldsByName = this.mapObjectValueFieldsByName(inputValue);
        List<GraphQLInputObjectField> inputFields = fieldVisibility.getFieldDefinitions(type);
        for (GraphQLInputObjectField inputTypeField : inputFields) {
            if (inputValueFieldsByName.containsKey(inputTypeField.getName())) {
                boolean putObjectInMap = true;
                ObjectField field = inputValueFieldsByName.get(inputTypeField.getName());
                Value fieldInputValue = field.getValue();
                Object fieldObject = null;
                if (fieldInputValue instanceof VariableReference) {
                    String varName = ((VariableReference)fieldInputValue).getName();
                    if (!variables.containsKey(varName)) {
                        putObjectInMap = false;
                    } else {
                        fieldObject = variables.get(varName);
                    }
                } else {
                    fieldObject = this.coerceValueAst(fieldVisibility, inputTypeField.getType(), fieldInputValue, variables);
                }
                if (fieldObject == null && !field.getValue().isEqualTo(NullValue.Null)) {
                    fieldObject = inputTypeField.getDefaultValue();
                }
                if (putObjectInMap) {
                    result.put(field.getName(), fieldObject);
                    continue;
                }
                this.assertNonNullInputField(inputTypeField);
                continue;
            }
            if (inputTypeField.getDefaultValue() != null) {
                result.put(inputTypeField.getName(), inputTypeField.getDefaultValue());
                continue;
            }
            this.assertNonNullInputField(inputTypeField);
        }
        return result;
    }

    private void assertNonNullInputField(GraphQLInputObjectField inputTypeField) {
        if (GraphQLTypeUtil.isNonNull(inputTypeField.getType())) {
            throw new NonNullableValueCoercedAsNullException(inputTypeField);
        }
    }

    private Map<String, ObjectField> mapObjectValueFieldsByName(ObjectValue inputValue) {
        LinkedHashMap<String, ObjectField> inputValueFieldsByName = new LinkedHashMap<String, ObjectField>();
        for (ObjectField objectField : inputValue.getObjectFields()) {
            inputValueFieldsByName.put(objectField.getName(), objectField);
        }
        return inputValueFieldsByName;
    }
}

