/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.fieldvalidation;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.execution.AbortExecutionException;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.fieldvalidation.FieldValidation;
import graphql.execution.instrumentation.fieldvalidation.FieldValidationSupport;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import java.util.List;

@PublicApi
public class FieldValidationInstrumentation
extends SimpleInstrumentation {
    private final FieldValidation fieldValidation;

    public FieldValidationInstrumentation(FieldValidation fieldValidation) {
        this.fieldValidation = Assert.assertNotNull(fieldValidation);
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters) {
        List<GraphQLError> errors = FieldValidationSupport.validateFieldsAndArguments(this.fieldValidation, parameters.getExecutionContext());
        if (errors != null && !errors.isEmpty()) {
            throw new AbortExecutionException(errors);
        }
        return super.beginExecuteOperation(parameters);
    }
}

