/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.reactive;

import graphql.Assert;
import graphql.Internal;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

@Internal
class NonBlockingMutexExecutor
implements Executor {
    private final AtomicReference<RunNode> last = new AtomicReference();

    NonBlockingMutexExecutor() {
    }

    @Override
    public void execute(Runnable command) {
        RunNode newNode = new RunNode(Assert.assertNotNull(command, "Runnable must not be null", new Object[0]));
        RunNode prevLast = this.last.getAndSet(newNode);
        if (prevLast != null) {
            prevLast.lazySet(newNode);
        } else {
            this.runAll(newNode);
        }
    }

    private void reportFailure(Thread runner, Throwable thrown) {
        if (thrown instanceof InterruptedException) {
            runner.interrupt();
        } else {
            Thread.UncaughtExceptionHandler ueh = runner.getUncaughtExceptionHandler();
            if (ueh != null) {
                ueh.uncaughtException(runner, thrown);
            }
        }
    }

    private void run(RunNode current) {
        try {
            current.runnable.run();
        }
        catch (Throwable thrown) {
            this.reportFailure(Thread.currentThread(), thrown);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void runAll(RunNode next) {
        block0: while (true) lbl-1000:
        // 3 sources

        {
            current = next;
            this.run(current);
            next = (RunNode)current.get();
            if (next != null) ** GOTO lbl-1000
            if (this.last.compareAndSet(current, null)) {
                return;
            }
            while (true) {
                if ((next = (RunNode)current.get()) != null) continue block0;
            }
            break;
        }
    }

    private static final class RunNode
    extends AtomicReference<RunNode> {
        private final Runnable runnable;

        private RunNode(Runnable runnable) {
            this.runnable = runnable;
        }
    }
}

