/*
 * Decompiled with CFR 0.152.
 */
package graphql.introspection;

import graphql.Assert;
import graphql.PublicApi;
import graphql.Scalars;
import graphql.language.AstPrinter;
import graphql.language.AstValueHelper;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.ArrayList;
import java.util.List;

@PublicApi
public class Introspection {
    public static final GraphQLEnumType __TypeKind = GraphQLEnumType.newEnum().name("__TypeKind").description("An enum describing what kind of type a given __Type is").value("SCALAR", (Object)TypeKind.SCALAR, "Indicates this type is a scalar.").value("OBJECT", (Object)TypeKind.OBJECT, "Indicates this type is an object. `fields` and `interfaces` are valid fields.").value("INTERFACE", (Object)TypeKind.INTERFACE, "Indicates this type is an interface. `fields` and `possibleTypes` are valid fields.").value("UNION", (Object)TypeKind.UNION, "Indicates this type is a union. `possibleTypes` is a valid field.").value("ENUM", (Object)TypeKind.ENUM, "Indicates this type is an enum. `enumValues` is a valid field.").value("INPUT_OBJECT", (Object)TypeKind.INPUT_OBJECT, "Indicates this type is an input object. `inputFields` is a valid field.").value("LIST", (Object)TypeKind.LIST, "Indicates this type is a list. `ofType` is a valid field.").value("NON_NULL", (Object)TypeKind.NON_NULL, "Indicates this type is a non-null. `ofType` is a valid field.").build();
    public static final DataFetcher kindDataFetcher = environment -> {
        Object type = environment.getSource();
        if (type instanceof GraphQLScalarType) {
            return TypeKind.SCALAR;
        }
        if (type instanceof GraphQLObjectType) {
            return TypeKind.OBJECT;
        }
        if (type instanceof GraphQLInterfaceType) {
            return TypeKind.INTERFACE;
        }
        if (type instanceof GraphQLUnionType) {
            return TypeKind.UNION;
        }
        if (type instanceof GraphQLEnumType) {
            return TypeKind.ENUM;
        }
        if (type instanceof GraphQLInputObjectType) {
            return TypeKind.INPUT_OBJECT;
        }
        if (type instanceof GraphQLList) {
            return TypeKind.LIST;
        }
        if (type instanceof GraphQLNonNull) {
            return TypeKind.NON_NULL;
        }
        return Assert.assertShouldNeverHappen("Unknown kind of type: %s", type);
    };
    public static final GraphQLObjectType __InputValue = GraphQLObjectType.newObject().name("__InputValue").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("type").type(GraphQLNonNull.nonNull(GraphQLTypeReference.typeRef("__Type")))).field(GraphQLFieldDefinition.newFieldDefinition().name("defaultValue").type(Scalars.GraphQLString).dataFetcher(environment -> {
        if (environment.getSource() instanceof GraphQLArgument) {
            GraphQLArgument inputField = (GraphQLArgument)environment.getSource();
            return inputField.getDefaultValue() != null ? Introspection.print(inputField.getDefaultValue(), inputField.getType()) : null;
        }
        if (environment.getSource() instanceof GraphQLInputObjectField) {
            GraphQLInputObjectField inputField = (GraphQLInputObjectField)environment.getSource();
            return inputField.getDefaultValue() != null ? Introspection.print(inputField.getDefaultValue(), inputField.getType()) : null;
        }
        return null;
    })).build();
    public static final GraphQLObjectType __Field = GraphQLObjectType.newObject().name("__Field").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("args").type(GraphQLNonNull.nonNull(GraphQLList.list(GraphQLNonNull.nonNull(__InputValue)))).dataFetcher(environment -> {
        Object type = environment.getSource();
        return ((GraphQLFieldDefinition)type).getArguments();
    })).field(GraphQLFieldDefinition.newFieldDefinition().name("type").type(GraphQLNonNull.nonNull(GraphQLTypeReference.typeRef("__Type")))).field(GraphQLFieldDefinition.newFieldDefinition().name("isDeprecated").type(GraphQLNonNull.nonNull(Scalars.GraphQLBoolean)).dataFetcher(environment -> {
        Object type = environment.getSource();
        return ((GraphQLFieldDefinition)type).isDeprecated();
    })).field(GraphQLFieldDefinition.newFieldDefinition().name("deprecationReason").type(Scalars.GraphQLString)).build();
    public static final GraphQLObjectType __EnumValue = GraphQLObjectType.newObject().name("__EnumValue").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("isDeprecated").type(GraphQLNonNull.nonNull(Scalars.GraphQLBoolean)).dataFetcher(environment -> {
        GraphQLEnumValueDefinition enumValue = (GraphQLEnumValueDefinition)environment.getSource();
        return enumValue.isDeprecated();
    })).field(GraphQLFieldDefinition.newFieldDefinition().name("deprecationReason").type(Scalars.GraphQLString)).build();
    public static final DataFetcher fieldsFetcher = environment -> {
        Object type = environment.getSource();
        Boolean includeDeprecated = (Boolean)environment.getArgument("includeDeprecated");
        if (type instanceof GraphQLFieldsContainer) {
            GraphQLFieldsContainer fieldsContainer = (GraphQLFieldsContainer)type;
            List<GraphQLFieldDefinition> fieldDefinitions = environment.getGraphQLSchema().getFieldVisibility().getFieldDefinitions(fieldsContainer);
            if (includeDeprecated.booleanValue()) {
                return fieldDefinitions;
            }
            ArrayList<GraphQLFieldDefinition> filtered = new ArrayList<GraphQLFieldDefinition>(fieldDefinitions);
            for (GraphQLFieldDefinition fieldDefinition : fieldDefinitions) {
                if (!fieldDefinition.isDeprecated()) continue;
                filtered.remove(fieldDefinition);
            }
            return filtered;
        }
        return null;
    };
    public static final DataFetcher interfacesFetcher = environment -> {
        Object type = environment.getSource();
        if (type instanceof GraphQLObjectType) {
            return ((GraphQLObjectType)type).getInterfaces();
        }
        return null;
    };
    public static final DataFetcher possibleTypesFetcher = environment -> {
        Object type = environment.getSource();
        if (type instanceof GraphQLInterfaceType) {
            return environment.getGraphQLSchema().getImplementations((GraphQLInterfaceType)type);
        }
        if (type instanceof GraphQLUnionType) {
            return ((GraphQLUnionType)type).getTypes();
        }
        return null;
    };
    public static final DataFetcher enumValuesTypesFetcher = environment -> {
        Object type = environment.getSource();
        Boolean includeDeprecated = (Boolean)environment.getArgument("includeDeprecated");
        if (type instanceof GraphQLEnumType) {
            List<GraphQLEnumValueDefinition> values = ((GraphQLEnumType)type).getValues();
            if (includeDeprecated.booleanValue()) {
                return values;
            }
            ArrayList<GraphQLEnumValueDefinition> filtered = new ArrayList<GraphQLEnumValueDefinition>(values);
            for (GraphQLEnumValueDefinition valueDefinition : values) {
                if (!valueDefinition.isDeprecated()) continue;
                filtered.remove(valueDefinition);
            }
            return filtered;
        }
        return null;
    };
    public static final DataFetcher inputFieldsFetcher = environment -> {
        Object type = environment.getSource();
        if (type instanceof GraphQLInputObjectType) {
            GraphqlFieldVisibility fieldVisibility = environment.getGraphQLSchema().getFieldVisibility();
            return fieldVisibility.getFieldDefinitions((GraphQLInputObjectType)type);
        }
        return null;
    };
    public static final DataFetcher OfTypeFetcher = environment -> {
        Object type = environment.getSource();
        if (type instanceof GraphQLModifiedType) {
            return GraphQLTypeUtil.unwrapOne((GraphQLModifiedType)type);
        }
        return null;
    };
    public static final GraphQLObjectType __Type = GraphQLObjectType.newObject().name("__Type").field(GraphQLFieldDefinition.newFieldDefinition().name("kind").type(GraphQLNonNull.nonNull(__TypeKind)).dataFetcher(kindDataFetcher)).field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("fields").type(GraphQLList.list(GraphQLNonNull.nonNull(__Field))).argument(GraphQLArgument.newArgument().name("includeDeprecated").type(Scalars.GraphQLBoolean).defaultValue(false)).dataFetcher(fieldsFetcher)).field(GraphQLFieldDefinition.newFieldDefinition().name("interfaces").type(GraphQLList.list(GraphQLNonNull.nonNull(GraphQLTypeReference.typeRef("__Type")))).dataFetcher(interfacesFetcher)).field(GraphQLFieldDefinition.newFieldDefinition().name("possibleTypes").type(GraphQLList.list(GraphQLNonNull.nonNull(GraphQLTypeReference.typeRef("__Type")))).dataFetcher(possibleTypesFetcher)).field(GraphQLFieldDefinition.newFieldDefinition().name("enumValues").type(GraphQLList.list(GraphQLNonNull.nonNull(__EnumValue))).argument(GraphQLArgument.newArgument().name("includeDeprecated").type(Scalars.GraphQLBoolean).defaultValue(false)).dataFetcher(enumValuesTypesFetcher)).field(GraphQLFieldDefinition.newFieldDefinition().name("inputFields").type(GraphQLList.list(GraphQLNonNull.nonNull(__InputValue))).dataFetcher(inputFieldsFetcher)).field(GraphQLFieldDefinition.newFieldDefinition().name("ofType").type(GraphQLTypeReference.typeRef("__Type")).dataFetcher(OfTypeFetcher)).build();
    public static final GraphQLEnumType __DirectiveLocation = GraphQLEnumType.newEnum().name("__DirectiveLocation").description("An enum describing valid locations where a directive can be placed").value("QUERY", (Object)DirectiveLocation.QUERY, "Indicates the directive is valid on queries.").value("MUTATION", (Object)DirectiveLocation.MUTATION, "Indicates the directive is valid on mutations.").value("FIELD", (Object)DirectiveLocation.FIELD, "Indicates the directive is valid on fields.").value("FRAGMENT_DEFINITION", (Object)DirectiveLocation.FRAGMENT_DEFINITION, "Indicates the directive is valid on fragment definitions.").value("FRAGMENT_SPREAD", (Object)DirectiveLocation.FRAGMENT_SPREAD, "Indicates the directive is valid on fragment spreads.").value("INLINE_FRAGMENT", (Object)DirectiveLocation.INLINE_FRAGMENT, "Indicates the directive is valid on inline fragments.").value("SCHEMA", (Object)DirectiveLocation.SCHEMA, "Indicates the directive is valid on a schema SDL definition.").value("SCALAR", (Object)DirectiveLocation.SCALAR, "Indicates the directive is valid on a scalar SDL definition.").value("OBJECT", (Object)DirectiveLocation.OBJECT, "Indicates the directive is valid on an object SDL definition.").value("FIELD_DEFINITION", (Object)DirectiveLocation.FIELD_DEFINITION, "Indicates the directive is valid on a field SDL definition.").value("ARGUMENT_DEFINITION", (Object)DirectiveLocation.ARGUMENT_DEFINITION, "Indicates the directive is valid on a field argument SDL definition.").value("INTERFACE", (Object)DirectiveLocation.INTERFACE, "Indicates the directive is valid on an interface SDL definition.").value("UNION", (Object)DirectiveLocation.UNION, "Indicates the directive is valid on an union SDL definition.").value("ENUM", (Object)DirectiveLocation.ENUM, "Indicates the directive is valid on an enum SDL definition.").value("ENUM_VALUE", (Object)DirectiveLocation.ENUM_VALUE, "Indicates the directive is valid on an enum value SDL definition.").value("INPUT_OBJECT", (Object)DirectiveLocation.INPUT_OBJECT, "Indicates the directive is valid on an input object SDL definition.").value("INPUT_FIELD_DEFINITION", (Object)DirectiveLocation.INPUT_FIELD_DEFINITION, "Indicates the directive is valid on an input object field SDL definition.").build();
    public static final GraphQLObjectType __Directive = GraphQLObjectType.newObject().name("__Directive").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("locations").type(GraphQLList.list(GraphQLNonNull.nonNull(__DirectiveLocation))).dataFetcher(environment -> {
        GraphQLDirective directive = (GraphQLDirective)environment.getSource();
        return new ArrayList<DirectiveLocation>(directive.validLocations());
    })).field(GraphQLFieldDefinition.newFieldDefinition().name("args").type(GraphQLNonNull.nonNull(GraphQLList.list(GraphQLNonNull.nonNull(__InputValue)))).dataFetcher(environment -> {
        GraphQLDirective directive = (GraphQLDirective)environment.getSource();
        return directive.getArguments();
    })).field(GraphQLFieldDefinition.newFieldDefinition().name("onOperation").type(Scalars.GraphQLBoolean).deprecate("Use `locations`.").dataFetcher(environment -> {
        GraphQLDirective directive = (GraphQLDirective)environment.getSource();
        return directive.isOnOperation();
    })).field(GraphQLFieldDefinition.newFieldDefinition().name("onFragment").type(Scalars.GraphQLBoolean).deprecate("Use `locations`.").dataFetcher(environment -> {
        GraphQLDirective directive = (GraphQLDirective)environment.getSource();
        return directive.isOnFragment() || directive.validLocations().contains((Object)DirectiveLocation.INLINE_FRAGMENT) && directive.validLocations().contains((Object)DirectiveLocation.FRAGMENT_SPREAD);
    })).field(GraphQLFieldDefinition.newFieldDefinition().name("onField").type(Scalars.GraphQLBoolean).deprecate("Use `locations`.").dataFetcher(environment -> {
        GraphQLDirective directive = (GraphQLDirective)environment.getSource();
        return directive.isOnField() || directive.validLocations().contains((Object)DirectiveLocation.FIELD);
    })).build();
    public static final GraphQLObjectType __Schema = GraphQLObjectType.newObject().name("__Schema").description("A GraphQL Introspection defines the capabilities of a GraphQL server. It exposes all available types and directives on the server, the entry points for query, mutation, and subscription operations.").field(GraphQLFieldDefinition.newFieldDefinition().name("types").description("A list of all types supported by this server.").type(GraphQLNonNull.nonNull(GraphQLList.list(GraphQLNonNull.nonNull(__Type)))).dataFetcher(environment -> {
        GraphQLSchema schema = (GraphQLSchema)environment.getSource();
        return schema.getAllTypesAsList();
    })).field(GraphQLFieldDefinition.newFieldDefinition().name("queryType").description("The type that query operations will be rooted at.").type(GraphQLNonNull.nonNull(__Type)).dataFetcher(environment -> {
        GraphQLSchema schema = (GraphQLSchema)environment.getSource();
        return schema.getQueryType();
    })).field(GraphQLFieldDefinition.newFieldDefinition().name("mutationType").description("If this server supports mutation, the type that mutation operations will be rooted at.").type(__Type).dataFetcher(environment -> {
        GraphQLSchema schema = (GraphQLSchema)environment.getSource();
        return schema.getMutationType();
    })).field(GraphQLFieldDefinition.newFieldDefinition().name("directives").description("'A list of all directives supported by this server.").type(GraphQLNonNull.nonNull(GraphQLList.list(GraphQLNonNull.nonNull(__Directive)))).dataFetcher(environment -> environment.getGraphQLSchema().getDirectives())).field(GraphQLFieldDefinition.newFieldDefinition().name("subscriptionType").description("'If this server support subscription, the type that subscription operations will be rooted at.").type(__Type).dataFetcher(environment -> {
        GraphQLSchema schema = (GraphQLSchema)environment.getSource();
        return schema.getSubscriptionType();
    })).build();
    public static final GraphQLFieldDefinition SchemaMetaFieldDef = GraphQLFieldDefinition.newFieldDefinition().name("__schema").type(GraphQLNonNull.nonNull(__Schema)).description("Access the current type schema of this server.").dataFetcher(DataFetchingEnvironment::getGraphQLSchema).build();
    public static final GraphQLFieldDefinition TypeMetaFieldDef = GraphQLFieldDefinition.newFieldDefinition().name("__type").type(__Type).description("Request the type information of a single type.").argument(GraphQLArgument.newArgument().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).dataFetcher(environment -> {
        String name = (String)environment.getArgument("name");
        return environment.getGraphQLSchema().getType(name);
    }).build();
    public static final GraphQLFieldDefinition TypeNameMetaFieldDef = GraphQLFieldDefinition.newFieldDefinition().name("__typename").type(GraphQLNonNull.nonNull(Scalars.GraphQLString)).description("The name of the current Object type at runtime.").dataFetcher(environment -> environment.getParentType().getName()).build();

    private static String print(Object value, GraphQLInputType type) {
        return AstPrinter.printAst(AstValueHelper.astFromValue(value, type));
    }

    public static GraphQLFieldDefinition getFieldDef(GraphQLSchema schema, GraphQLCompositeType parentType, String fieldName) {
        if (schema.getQueryType() == parentType) {
            if (fieldName.equals(SchemaMetaFieldDef.getName())) {
                return SchemaMetaFieldDef;
            }
            if (fieldName.equals(TypeMetaFieldDef.getName())) {
                return TypeMetaFieldDef;
            }
        }
        if (fieldName.equals(TypeNameMetaFieldDef.getName())) {
            return TypeNameMetaFieldDef;
        }
        Assert.assertTrue(parentType instanceof GraphQLFieldsContainer, "should not happen : parent type must be an object or interface %s", parentType);
        GraphQLFieldsContainer fieldsContainer = (GraphQLFieldsContainer)parentType;
        GraphQLFieldDefinition fieldDefinition = schema.getFieldVisibility().getFieldDefinition(fieldsContainer, fieldName);
        Assert.assertTrue(fieldDefinition != null, "Unknown field '%s'", fieldName);
        return fieldDefinition;
    }

    static {
        GraphQLSchema.newSchema().query(GraphQLObjectType.newObject().name("IntrospectionQuery").field(SchemaMetaFieldDef).field(TypeMetaFieldDef).field(TypeNameMetaFieldDef).build()).build();
    }

    public static enum DirectiveLocation {
        QUERY,
        MUTATION,
        FIELD,
        FRAGMENT_DEFINITION,
        FRAGMENT_SPREAD,
        INLINE_FRAGMENT,
        SCHEMA,
        SCALAR,
        OBJECT,
        FIELD_DEFINITION,
        ARGUMENT_DEFINITION,
        INTERFACE,
        UNION,
        ENUM,
        ENUM_VALUE,
        INPUT_OBJECT,
        INPUT_FIELD_DEFINITION;

    }

    public static enum TypeKind {
        SCALAR,
        OBJECT,
        INTERFACE,
        UNION,
        ENUM,
        INPUT_OBJECT,
        LIST,
        NON_NULL;

    }
}

