/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Internal;
import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Comment;
import graphql.language.Definition;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeVisitor;
import graphql.language.SourceLocation;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

@PublicApi
public class Document
extends AbstractNode<Document> {
    private final List<Definition> definitions;

    @Internal
    protected Document(List<Definition> definitions, SourceLocation sourceLocation, List<Comment> comments) {
        super(sourceLocation, comments);
        this.definitions = definitions;
    }

    public Document(List<Definition> definitions) {
        this(definitions, null, new ArrayList<Comment>());
    }

    public List<Definition> getDefinitions() {
        return this.definitions;
    }

    @Override
    public List<Node> getChildren() {
        return new ArrayList<Node>(this.definitions);
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    @Override
    public Document deepCopy() {
        return new Document(this.deepCopy(this.definitions), this.getSourceLocation(), this.getComments());
    }

    public String toString() {
        return "Document{definitions=" + this.definitions + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitDocument(this, context);
    }

    public static Builder newDocument() {
        return new Builder();
    }

    public Document transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeBuilder {
        private List<Definition> definitions = new ArrayList<Definition>();
        private SourceLocation sourceLocation;
        private List<Comment> comments = new ArrayList<Comment>();

        private Builder() {
        }

        private Builder(Document existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = existing.getComments();
            this.definitions = existing.getDefinitions();
        }

        public Builder definitions(List<Definition> definitions) {
            this.definitions = definitions;
            return this;
        }

        public Builder definition(Definition definition) {
            this.definitions.add(definition);
            return this;
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = comments;
            return this;
        }

        public Document build() {
            Document document = new Document(this.definitions, this.sourceLocation, this.comments);
            return document;
        }
    }
}

