/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Internal;
import graphql.PublicApi;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.NodeBuilder;
import graphql.language.SourceLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

@PublicApi
public class EnumTypeExtensionDefinition
extends EnumTypeDefinition {
    @Internal
    protected EnumTypeExtensionDefinition(String name, List<EnumValueDefinition> enumValueDefinitions, List<Directive> directives, Description description, SourceLocation sourceLocation, List<Comment> comments) {
        super(name, enumValueDefinitions, directives, description, sourceLocation, comments);
    }

    @Override
    public EnumTypeExtensionDefinition deepCopy() {
        return new EnumTypeExtensionDefinition(this.getName(), this.deepCopy(this.getEnumValueDefinitions()), this.deepCopy(this.getDirectives()), this.getDescription(), this.getSourceLocation(), this.getComments());
    }

    @Override
    public String toString() {
        return "EnumTypeDefinition{name='" + this.getName() + '\'' + ", enumValueDefinitions=" + this.getEnumValueDefinitions() + ", directives=" + this.getDirectives() + '}';
    }

    public static Builder newEnumTypeExtensionDefinition() {
        return new Builder();
    }

    public EnumTypeExtensionDefinition transformExtension(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeBuilder {
        private SourceLocation sourceLocation;
        private List<Comment> comments = new ArrayList<Comment>();
        private String name;
        private Description description;
        private List<EnumValueDefinition> enumValueDefinitions;
        private List<Directive> directives;

        private Builder() {
        }

        private Builder(EnumTypeExtensionDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = existing.getComments();
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.directives = existing.getDirectives();
            this.enumValueDefinitions = existing.getEnumValueDefinitions();
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = comments;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(Description description) {
            this.description = description;
            return this;
        }

        public Builder enumValueDefinitions(List<EnumValueDefinition> enumValueDefinitions) {
            this.enumValueDefinitions = enumValueDefinitions;
            return this;
        }

        public Builder directives(List<Directive> directives) {
            this.directives = directives;
            return this;
        }

        public EnumTypeExtensionDefinition build() {
            EnumTypeExtensionDefinition enumTypeDefinition = new EnumTypeExtensionDefinition(this.name, this.enumValueDefinitions, this.directives, this.description, this.sourceLocation, this.comments);
            return enumTypeDefinition;
        }
    }
}

