/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Internal;
import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Comment;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.Selection;
import graphql.language.SourceLocation;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

@PublicApi
public class FragmentSpread
extends AbstractNode<FragmentSpread>
implements Selection<FragmentSpread>,
DirectivesContainer<FragmentSpread> {
    private final String name;
    private final List<Directive> directives;

    @Internal
    protected FragmentSpread(String name, List<Directive> directives, SourceLocation sourceLocation, List<Comment> comments) {
        super(sourceLocation, comments);
        this.name = name;
        this.directives = new ArrayList<Directive>(directives);
    }

    public FragmentSpread(String name) {
        this(name, new ArrayList<Directive>(), null, new ArrayList<Comment>());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Directive> getDirectives() {
        return new ArrayList<Directive>(this.directives);
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentSpread that = (FragmentSpread)o;
        return NodeUtil.isEqualTo(this.name, that.name);
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.directives);
        return result;
    }

    @Override
    public FragmentSpread deepCopy() {
        return new FragmentSpread(this.name, this.deepCopy(this.directives), this.getSourceLocation(), this.getComments());
    }

    public String toString() {
        return "FragmentSpread{name='" + this.name + '\'' + ", directives=" + this.directives + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitFragmentSpread(this, context);
    }

    public static Builder newFragmentSpread() {
        return new Builder();
    }

    public static Builder newFragmentSpread(String name) {
        return new Builder().name(name);
    }

    public FragmentSpread transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeBuilder {
        private SourceLocation sourceLocation;
        private List<Comment> comments = new ArrayList<Comment>();
        private String name;
        private List<Directive> directives = new ArrayList<Directive>();

        private Builder() {
        }

        private Builder(FragmentSpread existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = existing.getComments();
            this.name = existing.getName();
            this.directives = existing.getDirectives();
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = comments;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder directives(List<Directive> directives) {
            this.directives = directives;
            return this;
        }

        public FragmentSpread build() {
            FragmentSpread fragmentSpread = new FragmentSpread(this.name, this.directives, this.sourceLocation, this.comments);
            return fragmentSpread;
        }
    }
}

