/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Internal;
import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Comment;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.SelectionSetContainer;
import graphql.language.SourceLocation;
import graphql.language.TypeName;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class InlineFragment
extends AbstractNode<InlineFragment>
implements Selection<InlineFragment>,
SelectionSetContainer<InlineFragment> {
    private final TypeName typeCondition;
    private final List<Directive> directives;
    private final SelectionSet selectionSet;

    @Internal
    protected InlineFragment(TypeName typeCondition, List<Directive> directives, SelectionSet selectionSet, SourceLocation sourceLocation, List<Comment> comments) {
        super(sourceLocation, comments);
        this.typeCondition = typeCondition;
        this.directives = directives;
        this.selectionSet = selectionSet;
    }

    public InlineFragment(TypeName typeCondition) {
        this(typeCondition, new ArrayList<Directive>(), null, null, new ArrayList<Comment>());
    }

    public InlineFragment(TypeName typeCondition, SelectionSet selectionSet) {
        this(typeCondition, new ArrayList<Directive>(), selectionSet, null, new ArrayList<Comment>());
    }

    public TypeName getTypeCondition() {
        return this.typeCondition;
    }

    public List<Directive> getDirectives() {
        return new ArrayList<Directive>(this.directives);
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    @Override
    public SelectionSet getSelectionSet() {
        return this.selectionSet;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.typeCondition != null) {
            result.add(this.typeCondition);
        }
        result.addAll(this.directives);
        result.add(this.selectionSet);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    @Override
    public InlineFragment deepCopy() {
        return new InlineFragment(this.deepCopy(this.typeCondition), this.deepCopy(this.directives), this.deepCopy(this.selectionSet), this.getSourceLocation(), this.getComments());
    }

    public String toString() {
        return "InlineFragment{typeCondition='" + this.typeCondition + '\'' + ", directives=" + this.directives + ", selectionSet=" + this.selectionSet + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitInlineFragment(this, context);
    }

    public static Builder newInlineFragment() {
        return new Builder();
    }

    public InlineFragment transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeBuilder {
        private SourceLocation sourceLocation;
        private List<Comment> comments = new ArrayList<Comment>();
        private TypeName typeCondition;
        private List<Directive> directives = new ArrayList<Directive>();
        private SelectionSet selectionSet;

        private Builder() {
        }

        private Builder(InlineFragment existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = existing.getComments();
            this.typeCondition = existing.getTypeCondition();
            this.directives = existing.getDirectives();
            this.selectionSet = existing.getSelectionSet();
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = comments;
            return this;
        }

        public Builder typeCondition(TypeName typeCondition) {
            this.typeCondition = typeCondition;
            return this;
        }

        public Builder directives(List<Directive> directives) {
            this.directives = directives;
            return this;
        }

        public Builder selectionSet(SelectionSet selectionSet) {
            this.selectionSet = selectionSet;
            return this;
        }

        public InlineFragment build() {
            InlineFragment inlineFragment = new InlineFragment(this.typeCondition, this.directives, this.selectionSet, this.sourceLocation, this.comments);
            return inlineFragment;
        }
    }
}

