/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Internal;
import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Comment;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeVisitor;
import graphql.language.SourceLocation;
import graphql.language.Value;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

@PublicApi
public class ObjectField
extends AbstractNode<ObjectField>
implements NamedNode<ObjectField> {
    private final String name;
    private final Value value;

    @Internal
    protected ObjectField(String name, Value value, SourceLocation sourceLocation, List<Comment> comments) {
        super(sourceLocation, comments);
        this.name = name;
        this.value = value;
    }

    public ObjectField(String name, Value value) {
        this(name, value, null, new ArrayList<Comment>());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Value getValue() {
        return this.value;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(this.value);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectField that = (ObjectField)o;
        return !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    @Override
    public ObjectField deepCopy() {
        return new ObjectField(this.name, this.deepCopy(this.value), this.getSourceLocation(), this.getComments());
    }

    public String toString() {
        return "ObjectField{name='" + this.name + '\'' + ", value=" + this.value + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitObjectField(this, context);
    }

    public static Builder newObjectField() {
        return new Builder();
    }

    public ObjectField transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeBuilder {
        private SourceLocation sourceLocation;
        private String name;
        private List<Comment> comments = new ArrayList<Comment>();
        private Value value;

        private Builder() {
        }

        private Builder(ObjectField existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = existing.getComments();
            this.name = existing.getName();
            this.value = existing.getValue();
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = comments;
            return this;
        }

        public Builder value(Value value) {
            this.value = value;
            return this;
        }

        public ObjectField build() {
            ObjectField objectField = new ObjectField(this.name, this.value, this.sourceLocation, this.comments);
            return objectField;
        }
    }
}

