/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Internal;
import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Comment;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.OperationTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.SourceLocation;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class SchemaDefinition
extends AbstractNode<SchemaDefinition>
implements SDLDefinition<SchemaDefinition> {
    private final List<Directive> directives;
    private final List<OperationTypeDefinition> operationTypeDefinitions;

    @Internal
    protected SchemaDefinition(List<Directive> directives, List<OperationTypeDefinition> operationTypeDefinitions, SourceLocation sourceLocation, List<Comment> comments) {
        super(sourceLocation, comments);
        this.directives = directives;
        this.operationTypeDefinitions = operationTypeDefinitions;
    }

    public List<Directive> getDirectives() {
        return new ArrayList<Directive>(this.directives);
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    public List<OperationTypeDefinition> getOperationTypeDefinitions() {
        return this.operationTypeDefinitions;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.directives);
        result.addAll(this.operationTypeDefinitions);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaDefinition that = (SchemaDefinition)o;
        return true;
    }

    @Override
    public SchemaDefinition deepCopy() {
        return new SchemaDefinition(this.deepCopy(this.directives), this.deepCopy(this.operationTypeDefinitions), this.getSourceLocation(), this.getComments());
    }

    public String toString() {
        return "SchemaDefinition{directives=" + this.directives + ", operationTypeDefinitions=" + this.operationTypeDefinitions + "}";
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitSchemaDefinition(this, context);
    }

    public SchemaDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Builder newSchemaDefinition() {
        return new Builder();
    }

    public static final class Builder
    implements NodeBuilder {
        private SourceLocation sourceLocation;
        private List<Comment> comments = new ArrayList<Comment>();
        private List<Directive> directives = new ArrayList<Directive>();
        private List<OperationTypeDefinition> operationTypeDefinitions = new ArrayList<OperationTypeDefinition>();

        private Builder() {
        }

        private Builder(SchemaDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = existing.getComments();
            this.directives = existing.getDirectives();
            this.operationTypeDefinitions = existing.getOperationTypeDefinitions();
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = comments;
            return this;
        }

        public Builder directives(List<Directive> directives) {
            this.directives = directives;
            return this;
        }

        public Builder directive(Directive directive) {
            this.directives.add(directive);
            return this;
        }

        public Builder operationTypeDefinitions(List<OperationTypeDefinition> operationTypeDefinitions) {
            this.operationTypeDefinitions = operationTypeDefinitions;
            return this;
        }

        public Builder operationTypeDefinition(OperationTypeDefinition operationTypeDefinitions) {
            this.operationTypeDefinitions.add(operationTypeDefinitions);
            return this;
        }

        public SchemaDefinition build() {
            SchemaDefinition schemaDefinition = new SchemaDefinition(this.directives, this.operationTypeDefinitions, this.sourceLocation, this.comments);
            return schemaDefinition;
        }
    }
}

